/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.AttributeNotAvailableException;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.resource.ProjectWorkEnvironment;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class DurationDropDownAction
extends Action
implements IMenuCreator {
    private final IPlanningAttributeIdentifier fDurationAttribute;
    private DurationFormat fDurationFormat = null;
    private SelectionAdapter fListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            MenuItem item = (MenuItem)event.widget;
            long value = (Long)item.getData("duration_value");
            if (value != Long.MIN_VALUE) {
                DurationDropDownAction.this.fPlanItem.setAttributeValue(DurationDropDownAction.this.fDurationAttribute, (Object)new Duration(value));
            } else {
                Duration duration;
                Duration currentDuration = Duration.UNSPECIFIED;
                try {
                    currentDuration = (Duration)DurationDropDownAction.this.fPlanItem.getAttributeValue(DurationDropDownAction.this.fDurationAttribute);
                }
                catch (AttributeNotAvailableException attributeNotAvailableException) {
                    // empty catch block
                }
                DurationDialog dialog = new DurationDialog(DurationDropDownAction.this.fMenu.getShell(), currentDuration);
                if (dialog.open() == 0 && (duration = dialog.getResult()) != null) {
                    DurationDropDownAction.this.fPlanItem.setAttributeValue(DurationDropDownAction.this.fDurationAttribute, (Object)new Duration(duration.longValue()));
                }
            }
        }
    };
    private Menu fMenu;
    private PlanItem fPlanItem;

    private static long getWorkYearMillis(DurationFormat format) {
        return format.getMillisPerDay() * (long)format.getDaysPerWeek() * 52L;
    }

    public DurationDropDownAction(PlanItem planItem, IPlanningAttributeIdentifier durationAttribute) {
        this.fDurationAttribute = durationAttribute;
        this.setMenuCreator(this);
        this.fPlanItem = planItem;
    }

    private void createMenuItem(Menu parent, DurationFormat format, long value) {
        String label = format.format(new Duration(value));
        this.createMenuItem(parent, label, value);
    }

    private void createMenuItem(Menu parent, String label, long value) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(label);
        item.setData("duration_value", (Object)new Long(value));
        item.addSelectionListener((SelectionListener)this.fListener);
    }

    public void dispose() {
        if (this.fMenu != null) {
            if (this.fMenu.isDisposed()) {
                this.fMenu = null;
            } else if (!this.fMenu.isVisible()) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }
    }

    private DurationFormat getDurationFormat() {
        if (this.fDurationFormat == null) {
            this.fDurationFormat = new DurationFormat(0);
            ProjectWorkEnvironment workEnvironment = this.fPlanItem.getPlan().getProjectWorkEnvironment();
            this.fDurationFormat.setMillisPerDay(workEnvironment.getWorkMillisPerDay());
            this.fDurationFormat.setDaysPerWeek(workEnvironment.getWorkDaysPerWeek());
            EstimateOutputFormat outputFormat = this.fPlanItem.getPlan().getEstimateOutputFormat();
            if (EstimateOutputFormat.Hours.equals((Object)outputFormat)) {
                this.fDurationFormat.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
            }
        }
        return this.fDurationFormat;
    }

    public Menu getMenu(Control parent) {
        this.dispose();
        this.fMenu = new Menu(parent);
        DurationFormat format = this.getDurationFormat();
        if (PlanItem.EFFORT.equals(this.fDurationAttribute) && EstimateMode.TimeRemaining.equals((Object)this.fPlanItem.getPlan().getDurationSupport().getEstimateMode())) {
            this.createMenuItem(this.fMenu, format, 0L);
        }
        this.createMenuItem(this.fMenu, format, 1800000L);
        this.createMenuItem(this.fMenu, format, 3600000L);
        this.createMenuItem(this.fMenu, format, 0x6DDD00L);
        this.createMenuItem(this.fMenu, format, 14400000L);
        long millis = format.getMillisPerDay();
        this.createMenuItem(this.fMenu, format, millis);
        this.createMenuItem(this.fMenu, format, 2L * millis);
        this.createMenuItem(this.fMenu, format, 3L * millis);
        this.createMenuItem(this.fMenu, format, (long)format.getDaysPerWeek() * millis);
        new MenuItem(this.fMenu, 2);
        this.createMenuItem(this.fMenu, Messages.DurationDropDownAction_MENUITEM_NO_ESTIMATE, -1L);
        this.createMenuItem(this.fMenu, Messages.DurationDropDownAction_MENUITEM_OPEN_ESTIMATE_DIALOG, Long.MIN_VALUE);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return this.fMenu;
    }

    private class DurationDialog
    extends StatusDialog {
        private Duration fCurrentValue;
        private ControlDecoration fDecoration;
        private Text fDuration;
        private Duration fResult;

        public DurationDialog(Shell shell, Duration value) {
            super(shell);
            this.fCurrentValue = value;
            this.setTitle(Messages.DurationDropDownAction_TITLE);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)composite);
            GridLayout layout = (GridLayout)composite.getLayout();
            layout.numColumns = 2;
            layout.horizontalSpacing = 8;
            Label label = new Label(composite, 0);
            label.setText(Messages.DurationDropDownAction_LABEL);
            this.fDuration = new Text(composite, 133120);
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            this.fDecoration = new ControlDecoration((Control)this.fDuration, 16512);
            this.fDecoration.setImage(registry.getFieldDecoration("DEC_INFORMATION").getImage());
            this.fDecoration.setDescriptionText(Messages.DurationDropDownAction_DECORATION_DESCRIPTION);
            this.fDecoration.show();
            final DurationFormat format = DurationDropDownAction.this.getDurationFormat();
            if (this.fCurrentValue.isSpecified()) {
                this.fDuration.setText(format.format(this.fCurrentValue));
                this.fDuration.selectAll();
            }
            this.fDuration.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    try {
                        String text = DurationDialog.this.fDuration.getText().trim();
                        if (text.length() == 0) {
                            DurationDialog.this.fResult = Duration.UNSPECIFIED;
                        } else {
                            DurationDialog.this.fResult = format.parse(text);
                        }
                        if (DurationDialog.this.fResult.longValue() > DurationDropDownAction.getWorkYearMillis(format)) {
                            DurationDialog.this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, Messages.DurationDropDownAction_ESTIMATE_TOO_BIG, null));
                        } else {
                            DurationDialog.this.updateStatus(Status.OK_STATUS);
                        }
                    }
                    catch (ParseException exception) {
                        DurationDialog.this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, exception.getLocalizedMessage(), null));
                    }
                }
            });
            GridData data = new GridData(768);
            data.minimumWidth = this.convertWidthInCharsToPixels(Messages.DurationDropDownAction_ESTIMATE_TOO_BIG.length());
            this.fDuration.setLayoutData((Object)data);
            Dialog.applyDialogFont((Control)composite);
            UI.hookHelpListener((Control)composite, "com.ibm.team.apt.ide.ui.dialog_estimation");
            return composite;
        }

        public Duration getResult() {
            return this.fResult;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }
    }
}

