/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.AbstractTextEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextConverter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Transformation;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.internal.text.DocumentSupport;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.SourceViewerSupport;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class DescriptionEditor
extends AbstractTextEditor {
    private IViewEntry<PlanItem> fEntry;
    private SourceViewerSupport fSourceViewerSupport;
    private IDocumentListener fDocumentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            DescriptionEditor.this.fireContentChanged();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };
    private FocusListener fFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            DescriptionEditor.this.stopEditSession();
        }
    };

    public DescriptionEditor(Composite parent, int style) {
        super(parent, style | 4 | 0x800);
    }

    @Override
    public IViewEntry<?> getEntry() {
        return this.fEntry;
    }

    @Override
    public void transferOwnership(PlanItemGadget gadget) {
        this.setOwner(gadget.getDescription());
        this.fEntry = (IViewEntry)gadget.getOutlineItem().getData();
    }

    @Override
    public boolean isOwner(PlanItemGadget gadget) {
        return this.getOwner() == gadget.getDescription();
    }

    @Override
    protected StyledText createStyledText(Composite parent, int style) {
        this.fSourceViewerSupport = new SourceViewerSupport(parent, false, false, new Point(0, 0), style);
        return this.fSourceViewerSupport.getSourceViewer().getTextWidget();
    }

    @Override
    protected String getTextContent() {
        return TextConverter.fromText2HTML(this.fSourceViewerSupport.getSourceViewer().getDocument());
    }

    @Override
    public void dispose() {
        this.fSourceViewerSupport.dispose();
    }

    @Override
    public void startEditSession(GText newOwner, IViewEntry<?> entry, Transformation transformation) {
        this.stopEditSession();
        if (newOwner != null && entry != null && entry.getElement() instanceof PlanItem) {
            this.setOwner(newOwner);
            this.fEntry = entry;
            this.fMaximumWidth = this.getOwner().getMaximumWidth();
            Rectangle bounds = Rectangles.create(transformation.toViewPort(this.getOwner().getBounds()));
            if (bounds.width < this.fMaximumWidth && (this.getStyle() & 4) != 0) {
                bounds.width = this.fMaximumWidth;
            }
            this.setBounds(bounds);
            DocumentSupport support = new DocumentSupport(this.getPlanItem().getHTMLDescription());
            IDocument document = support.getDocument();
            this.fSourceViewerSupport.getSourceViewer().setInput((Object)document);
            this.getOwner().startEditSession(this);
            this.fEditControl.setVisible(true);
            this.fEditControl.setFocus();
            this.fEditControl.addFocusListener(this.fFocusListener);
            document.addDocumentListener(this.fDocumentListener);
        } else {
            IDocument document = this.fSourceViewerSupport.getSourceViewer().getDocument();
            if (document != null) {
                document.removeDocumentListener(this.fDocumentListener);
            }
            this.fSourceViewerSupport.getSourceViewer().setInput(null);
            this.fEditControl.removeFocusListener(this.fFocusListener);
            this.fEditControl.setVisible(false);
        }
    }

    @Override
    public void storeData() {
        IDocument document = this.fSourceViewerSupport.getSourceViewer().getDocument();
        XMLString description = document instanceof IStyledDocument ? ((IStyledDocument)document).getHTML2() : XMLString.createFromPlainText((String)document.get());
        PlanItem planItem = this.getPlanItem();
        if (planItem != null && planItem.isConnected()) {
            planItem.setHTMLDescription(description);
        }
    }

    @Override
    public void cancelEditSession() {
        this.stopEditSession(false);
    }

    @Override
    public void stopEditSession() {
        this.stopEditSession(true);
    }

    private void stopEditSession(boolean store) {
        if (this.getOwner() != null) {
            this.fEditControl.removeFocusListener(this.fFocusListener);
            this.fEditControl.setVisible(false);
            if (store) {
                this.storeData();
            }
            this.getOwner().stopEditSession(this);
            this.setOwner(null);
            this.fEntry = null;
            IDocument document = this.fSourceViewerSupport.getSourceViewer().getDocument();
            document.removeDocumentListener(this.fDocumentListener);
            this.fSourceViewerSupport.getSourceViewer().setInput(null);
        }
    }

    private PlanItem getPlanItem() {
        return this.fEntry != null ? (PlanItem)this.fEntry.getElement() : null;
    }
}

