/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.ValueSetDropDownAction;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class AttributeUtils {
    public static String getLabel(PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute, OutlineResources outlineResources) {
        return AttributeUtils.getLabel(planItem, attribute.getValue((Object)planItem), outlineResources);
    }

    public static Image getIcon(PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute, OutlineResources resources) {
        return AttributeUtils.getIcon(planItem, attribute.getValue((Object)planItem), resources);
    }

    private static String getLabel(PlanItem planItem, Object value, OutlineResources outlineResources) {
        if (value instanceof ILiteral) {
            return ((ILiteral)value).getName();
        }
        if (value instanceof IItemHandle) {
            value = AttributeUtils.resolveHandle((IItemHandle)value, planItem.getPlan().getTeamRepository());
        } else {
            if (value instanceof Duration) {
                return AttributeUtils.getDurationText((Duration)value, outlineResources, planItem.getPlan());
            }
            if (value instanceof Date) {
                return SimpleDateFormat.getDateInstance((int)3).format(value);
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    return "";
                }
                StringBuilder result = new StringBuilder();
                for (Object element : collection) {
                    if (result.length() > 0) {
                        result.append(", ");
                    }
                    result.append(AttributeUtils.getLabel(planItem, element, outlineResources));
                }
                return result.toString();
            }
            if (value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                if (length == 0) {
                    return "";
                }
                StringBuilder result = new StringBuilder();
                int i = 0;
                while (i < length) {
                    if (result.length() > 0) {
                        result.append(", ");
                    }
                    result.append(AttributeUtils.getLabel(planItem, Array.get(value, i), outlineResources));
                    ++i;
                }
                return result.toString();
            }
            if (value instanceof String) {
                String plainText = (String)value;
                if (plainText.length() == 0) {
                    return plainText;
                }
                String cleanText = XMLString.createFromXMLText((String)plainText).getPlainText();
                BufferedReader reader = new BufferedReader(new StringReader(cleanText));
                try {
                    StringBuilder result = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        if (result.length() > 0) {
                            result.append(' ');
                        }
                        result.append(line);
                        if (result.length() > 75) {
                            return String.valueOf(result.substring(0, 75)) + "...";
                        }
                        line = reader.readLine();
                    }
                    return result.toString();
                }
                catch (IOException e) {
                    PlanningUIPlugin.log(e);
                    return "";
                }
            }
        }
        if (value == null) {
            return "--";
        }
        return outlineResources.getStandardLabelProvider().getText(value);
    }

    private static Image getIcon(PlanItem planItem, Object value, OutlineResources resources) {
        if (value == null) {
            return null;
        }
        if (value instanceof ILiteral) {
            URL iconURL = ((ILiteral)value).getIconURL();
            if (iconURL == null) {
                return null;
            }
            return resources.getImage(WorkItemUI.getImageDescriptor((URL)iconURL));
        }
        if (value instanceof IItemHandle) {
            IItem item = AttributeUtils.resolveHandle((IItemHandle)value, planItem.getPlan().getTeamRepository());
            return resources.getStandardLabelProvider().getImage((Object)item);
        }
        if (value instanceof Duration) {
            return AttributeUtils.getDurationImage(resources);
        }
        return resources.getStandardLabelProvider().getImage(value);
    }

    private static String getDurationText(Duration duration, OutlineResources outlineResources, ResolvedPlan plan) {
        return ((PlanOutlineResources)outlineResources).getDurationFormat(plan).format(duration);
    }

    private static Image getDurationImage(OutlineResources outlineResources) {
        return ((PlanOutlineResources)outlineResources).getDurationImage();
    }

    static IItem resolveHandle(final IItemHandle itemHandle, ITeamRepository repository) {
        if (itemHandle instanceof IItem) {
            return (IItem)itemHandle;
        }
        if (itemHandle.hasFullState()) {
            return itemHandle.getFullState();
        }
        final IItemManager itemManager = repository.itemManager();
        IItem shared = itemManager.getSharedItemIfKnown(itemHandle);
        if (shared != null) {
            return shared;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        itemManager.fetchCompleteItem(itemHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
        catch (InterruptedException e) {
            PlanningUIPlugin.log(e);
            return null;
        }
        return itemManager.getSharedItemIfKnown(itemHandle);
    }

    public static class AttributeValueSetDropDownAction
    extends ValueSetDropDownAction<Object> {
        private final IPlanningAttribute fAttribute;
        private final PlanItem fPlanItem;
        private final OutlineResources fOutlineResources;

        public AttributeValueSetDropDownAction(PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute, OutlineResources outlineResources) {
            this.fPlanItem = planItem;
            this.fAttribute = attribute;
            this.fOutlineResources = outlineResources;
        }

        @Override
        protected MenuItem createMenuItem(Menu menu, Object object) {
            MenuItem item = new MenuItem(menu, 0);
            String label = AttributeUtils.getLabel(this.fPlanItem, object, this.fOutlineResources);
            item.setText(label);
            Image icon = AttributeUtils.getIcon(this.fPlanItem, object, this.fOutlineResources);
            if (icon != null) {
                item.setImage(icon);
            }
            return item;
        }

        @Override
        protected List<Object> fastResolveValues() {
            Collection result = this.fAttribute.getValueSet().getValues();
            for (Object object : result) {
                if (!(object instanceof IItemHandle) || object instanceof IItem) continue;
                return null;
            }
            return new ArrayList<Object>(result);
        }

        @Override
        protected void setValue(Object data) {
            this.fAttribute.setValue((Object)this.fPlanItem, data);
        }

        @Override
        protected List<Object> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
            ArrayList<Object> result = new ArrayList<Object>();
            Collection values = this.fAttribute.getValueSet().getValues();
            for (Object object : values) {
                if (object instanceof IItemHandle) {
                    IItem item = AttributeUtils.resolveHandle((IItemHandle)object, this.fPlanItem.getPlan().getTeamRepository());
                    result.add(item);
                    continue;
                }
                result.add(object);
            }
            return result;
        }

        @Override
        protected void addMenuItems(final Menu menu) {
            if (PlanningAttributeType.INTEGER.equals((Object)this.fAttribute.getAttributeType())) {
                MenuItem item = new MenuItem(menu, 0);
                item.setText(Messages.GPlanItemWorkItemAttribute_OPEN_DIALOG_ACTION_LABEL_1);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NumberSelectionDialog dialog = new NumberSelectionDialog(menu.getShell(), fAttribute.getDisplayName(), (int)((Integer)fAttribute.getValue((Object)fPlanItem)), Long.class);
                        if (dialog.open() == 0) {
                            Number value = dialog.getResult();
                            fAttribute.setValue((Object)fPlanItem, (Object)value);
                        }
                    }
                });
            }
        }
    }

    static class NumberSelectionDialog
    extends StatusDialog {
        private final String fAttributeName;
        private long fValue;
        private final Class<? extends Number> fType;

        public NumberSelectionDialog(Shell parent, String attributeName, Number value, Class<? extends Number> type) {
            super(parent);
            this.setTitle(NLS.bind((String)Messages.GPlanItemWorkItemAttribute_INTEGER_DIALOG_TITLE, (Object)attributeName, (Object[])new Object[0]));
            this.fAttributeName = attributeName;
            this.fValue = value.longValue();
            this.fType = type;
        }

        public Number getResult() {
            if (Long.class.equals(this.fType)) {
                return this.fValue;
            }
            if (Integer.class.equals(this.fType)) {
                return (int)this.fValue;
            }
            throw new IllegalStateException();
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = new Composite(parent, 0);
            result.setLayoutData((Object)new GridData(4, 4, true, true));
            result.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(result, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(String.valueOf(this.fAttributeName) + ':');
            final Text text = new Text(result, 18436);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            text.setText(String.valueOf(this.fValue));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String currentText = text.getText();
                    try {
                        fValue = Long.parseLong(currentText);
                        this.updateStatus(this.validate());
                    }
                    catch (NumberFormatException ex) {
                        this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), Messages.GPlanItemWorkItemAttribute_INTEGER_DIALOG_ERROR_MESSAGE));
                    }
                }
            });
            return result;
        }

        protected IStatus validate() {
            if (Integer.class.equals(this.fType) && (this.fValue > Integer.MAX_VALUE || this.fValue < Integer.MIN_VALUE)) {
                return new Status(4, PlanningUI.getPluginId(), Messages.GPlanItemWorkItemAttribute_INTEGER_DIALOG_ERROR_MESSAGE);
            }
            return Status.OK_STATUS;
        }
    }

    public static class OpenIntegerDialogAction
    extends Action {
        private final Shell fShell;
        private final IPlanningAttribute fAttribute;
        private final PlanItem fPlanItem;

        public OpenIntegerDialogAction(PlanItem planItem, IPlanningAttribute<PlanItem, ?> attribute, Shell shell) {
            super(Messages.GPlanItemWorkItemAttribute_OPEN_DIALOG_ACTION_LABEL_2);
            this.fPlanItem = planItem;
            this.fAttribute = attribute;
            this.fShell = shell;
        }

        public void run() {
            NumberSelectionDialog dialog = new NumberSelectionDialog(this.fShell, this.fAttribute.getDisplayName(), ((Number)this.fAttribute.getValue((Object)this.fPlanItem)).intValue(), Long.class);
            if (dialog.open() == 0) {
                Number value = dialog.getResult();
                this.fAttribute.setValue((Object)this.fPlanItem, (Object)value);
            }
        }
    }
}

