/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.scripting.facades.CategoryScriptType;
import com.ibm.team.apt.internal.common.scripting.facades.ContributorScriptType;
import com.ibm.team.apt.internal.common.scripting.facades.ProcessAreaScriptType;
import com.ibm.team.apt.internal.common.scripting.facades.WorkItemTypeScriptType;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.environment.FeatureScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.DefaultDojoEnvironment;
import com.ibm.team.rtc.common.scriptengine.internal.IScriptEnvironmentContext;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PlanningUIScriptEnvironment {
    public static IScriptEnvironment createScriptEnvironment(IPlanAccessor planAccessor) {
        return new FeatureScriptEnvironment(PlanningUIScriptEnvironment.createEnvironmentContext(planAccessor), DefaultDojoEnvironment.createFeatures());
    }

    private static IScriptEnvironmentContext createEnvironmentContext(final IPlanAccessor planAccessor) {
        final ContributorScriptType.IContributorContext contributorContext = new ContributorScriptType.IContributorContext(){

            public IContributor getAuthenticatedContributor() {
                return PlanningClientPlugin.getTeamRepository((IItemHandle)planAccessor.getPlan().getProjectAreaHandle()).loggedInContributor();
            }
        };
        final CategoryScriptType.ICategoryContext categoryContext = new CategoryScriptType.ICategoryContext(){

            public ICategory getCategory(CategoryId categoryId) {
                ItemCollection categories = planAccessor.getPlan().getCategories();
                for (ICategory category : categories) {
                    if (!category.getCategoryId().equals((Object)categoryId)) continue;
                    return category;
                }
                return null;
            }
        };
        final ProcessAreaScriptType.IProcessAreaContext processAreaContext = new ProcessAreaScriptType.IProcessAreaContext(){

            public IProcessArea getParent(IProcessArea area) {
                ResolvedPlan plan = planAccessor.getPlan();
                if (!(plan instanceof ResolvedIterationPlan)) {
                    return null;
                }
                return ((ResolvedIterationPlan)plan).getParentFor(area);
            }
        };
        final WorkItemTypeScriptType.IWorkItemTypeContext workItemTypeContext = new WorkItemTypeScriptType.IWorkItemTypeContext(){

            public boolean isTopLevelType(IWorkItemType workItemType) {
                return planAccessor.getPlan().getTopLevelWorkItemTypes().contains(workItemType.getIdentifier());
            }

            public IWorkflowInfo getWorkflowInfo(IWorkItemType workItemType) {
                IProjectAreaHandle projectAreaHandle = planAccessor.getPlan().getProjectAreaHandle();
                IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectAreaHandle);
                WorkflowManager workflowManager = (WorkflowManager)workItemClient.getWorkflowManager();
                String workflowId = workflowManager.getWorkflowIdForCategory(projectAreaHandle, workItemType.getCategory(), true, (IProgressMonitor)new NullProgressMonitor());
                return planAccessor.getPlan().getWorkflowInfo(workflowId);
            }
        };
        return new IScriptEnvironmentContext(){

            public <T> T get(Class<T> type) {
                if (ResolvedPlan.class.isAssignableFrom(type)) {
                    return type.cast(planAccessor.getPlan());
                }
                if (ContributorScriptType.IContributorContext.class.isAssignableFrom(type)) {
                    return type.cast(contributorContext);
                }
                if (CategoryScriptType.ICategoryContext.class.isAssignableFrom(type)) {
                    return type.cast(categoryContext);
                }
                if (ProcessAreaScriptType.IProcessAreaContext.class.isAssignableFrom(type)) {
                    return type.cast(processAreaContext);
                }
                if (WorkItemTypeScriptType.IWorkItemTypeContext.class.isAssignableFrom(type)) {
                    return type.cast(workItemTypeContext);
                }
                return null;
            }
        };
    }

    public static interface IPlanAccessor {
        public ResolvedPlan getPlan();
    }
}

