/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.client.AbstractPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanItemWorkItemAttribute;
import com.ibm.team.apt.internal.client.ReferenceAttribute;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.ScriptableAttribute;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.RequiredAttributeCheck;
import com.ibm.team.apt.internal.client.planchecker.ScriptablePlanCheck;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IColumnDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PlanningUICustomizationSupport {
    public static List<String> V3_ATTRIBUTES = Arrays.asList("com.ibm.team.apt.attribute.dcTitle", "com.ibm.team.apt.attribute.tracksWorkItem", "com.ibm.team.apt.attribute.trackedWorkItem", "com.ibm.team.apt.attribute.uri", "com.ibm.team.apt.attribute.calm.filter.openDefects", "com.ibm.team.apt.attribute.calm.filter.failingTestCases", "com.ibm.team.apt.attribute.projectArea", "com.ibm.team.apt.attribute.planmodel.timeline", "com.ibm.team.apt.attribute.planmodel.iteration", "com.ibm.team.apt.attribute.planmodel.owner", "com.ibm.team.apt.attribute.planmodel.iterationHierarchy", "com.ibm.team.apt.attribute.planmodel.categoryHierarchy", "com.ibm.team.apt.attribute.planmodel.processAreaHierarchy", "com.ibm.team.apt.attribute.planmodel.processArea2Categories", "com.ibm.team.apt.client.CALMServiceProviderAttribute", "com.ibm.team.apt.attribute.scheduler.agile", "com.ibm.team.apt.attribute.sequenceValueRaw", "com.ibm.team.apt.attribute.accumulatedTime", "com.ibm.team.apt.attribute.accumulatedTimeReadOnly", "com.ibm.team.apt.attribute.planitem.planInclusion", "com.ibm.team.apt.attribute.planitem.startDate", "com.ibm.team.apt.attribute.planitem.workflowInfo", "com.ibm.team.apt.attribute.planitem.humanReadableRanking", "com.ibm.team.apt.attribute.planitem.humanReadableNewRanking", "com.ibm.team.apt.attribute.planitem.store", "com.ibm.team.apt.attribute.planmodel.linkStore", "com.ibm.team.apt.attribute.planitem.folder", "com.ibm.team.apt.attribute.planitem.customSort", "com.ibm.team.apt.attribute.planitem.workflowResolution", "com.ibm.team.apt.attribute.planitem.workflowStateGroup", "com.ibm.team.apt.attribute.planlinks", "com.ibm.team.apt.attribute.proposedTime", "com.ibm.team.apt.attribute.proposedStartDate", "com.ibm.team.apt.attribute.proposedEndDate", "com.ibm.team.apt.attribute.plannedTime", "com.ibm.team.apt.attribute.plannedStartDate", "com.ibm.team.apt.attribute.plannedEndDate", "com.ibm.team.apt.attribute.plannedTimeVariance", "com.ibm.team.apt.attribute.plannedSchedule", "com.ibm.team.apt.attribute.scheduler.rollUp", "com.ibm.team.apt.plancheck.invalidEstimateCheck.attribute", "com.ibm.team.apt.plancheck.priorityMismatch.attribute", "com.ibm.team.apt.plancheck.schedulingCheck.attribute", "com.ibm.team.apt.plancheck.traditionalSchedulingCheck.attribute", "com.ibm.team.apt.attribute.planmodel.allCategory", "com.ibm.team.apt.attribute.contextRoot", "com.ibm.team.apt.plancheck.universalPlanCheck.attribute", "com.ibm.team.apt.plancheck.crossProjectPlanCheck.attribute", "com.ibm.team.apt.client.parentsInclusion", "com.ibm.team.apt.plancheck.archivedWorkItemType.attribute");

    public static List<IPlanningAttribute<?, ?>> createCustomAttributes(List<IAttributeDefinitionDescriptor> attributeDescriptors, IScriptEnvironment scriptEnvironment) {
        ArrayList result = new ArrayList();
        for (IAttributeDefinitionDescriptor attributeDescriptor : attributeDescriptors) {
            if (V3_ATTRIBUTES.contains(attributeDescriptor.getId())) continue;
            if ("com.ibm.team.apt.client.WorkItemAttribute".equals(attributeDescriptor.getImplementationName())) {
                boolean addCustomAttribute = true;
                Identifier workItemAttributeId = null;
                IParameter[] iParameterArray = attributeDescriptor.getParameters();
                int n = iParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameter parameter = iParameterArray[n2];
                    if ("attribute".equals(parameter.getKey())) {
                        workItemAttributeId = Identifier.create(IAttribute.class, (String)parameter.getValue());
                    }
                    if ("addCustomAttributes".equals(parameter.getKey())) {
                        addCustomAttribute = Boolean.parseBoolean(parameter.getValue());
                    }
                    ++n2;
                }
                if (workItemAttributeId == null) continue;
                result.add((IPlanningAttribute<?, ?>)new PlanItemWorkItemAttribute(attributeDescriptor, workItemAttributeId, addCustomAttribute));
                continue;
            }
            if ("com.ibm.team.apt.shared.client.RankingAttribute".equals(attributeDescriptor.getImplementationName()) || "com.ibm.team.apt.shared.client.NewRankingAttribute".equals(attributeDescriptor.getImplementationName())) {
                IParameter[] iParameterArray = attributeDescriptor.getParameters();
                int n = iParameterArray.length;
                int workItemAttributeId = 0;
                while (workItemAttributeId < n) {
                    String enumerationAttributeId;
                    IParameter parameter = iParameterArray[workItemAttributeId];
                    if ("attribute".equals(parameter.getKey()) && (enumerationAttributeId = parameter.getValue()) != null) {
                        Identifier sequenceAttributeId = Identifier.create(IAttribute.class, (String)(String.valueOf(enumerationAttributeId) + '.' + "_pm7NmRYUEd6L1tNIGdz5qQ"));
                        IAttributeDefinitionDescriptor rankSequenceDesc = (IAttributeDefinitionDescriptor)ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
                        rankSequenceDesc.setId(sequenceAttributeId.getStringIdentifier());
                        rankSequenceDesc.setType(PlanningAttributeType.SEQUENCEVALUE);
                        result.add((IPlanningAttribute<?, ?>)new PlanItemWorkItemAttribute(rankSequenceDesc, sequenceAttributeId, true));
                        break;
                    }
                    ++workItemAttributeId;
                }
                result.add((IPlanningAttribute<?, ?>)new ScriptableAttribute(attributeDescriptor, scriptEnvironment));
                continue;
            }
            if ("com.ibm.team.apt.client.ReferenceAttribute".equals(attributeDescriptor.getImplementationName())) {
                if (attributeDescriptor.getId().equals("com.ibm.team.apt.attribute.planlinks")) continue;
                result.add((IPlanningAttribute<?, ?>)new ReferenceAttribute(attributeDescriptor));
                continue;
            }
            if ("com.ibm.team.apt.shared.client.internal.model.attributes.InversReferenceAttribute".equals(attributeDescriptor.getImplementationName())) {
                IParameter param1 = IParameter.FACTORY.create("linkType", attributeDescriptor.getId().substring(attributeDescriptor.getId().lastIndexOf(47) + 1));
                IParameter param2 = IParameter.FACTORY.create("isSource", Boolean.toString(false));
                attributeDescriptor.setParameters(new IParameter[]{param1, param2});
                result.add((IPlanningAttribute<?, ?>)new ReferenceAttribute(attributeDescriptor));
                continue;
            }
            if ("com.ibm.team.apt.client.BuiltInAttribute".equals(attributeDescriptor.getImplementationName())) continue;
            result.add((IPlanningAttribute<?, ?>)new ScriptableAttribute(attributeDescriptor, scriptEnvironment));
        }
        return result;
    }

    public static List<PlanCheck> createPlanChecks(IPlanCheckDescription[] planChecks, IScriptEnvironment scriptEnvironment, ILicenseClient licenseClient, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<PlanCheck> result = new ArrayList<PlanCheck>();
        IPlanCheckDescription[] iPlanCheckDescriptionArray = planChecks;
        int n = planChecks.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IPlanCheckDescription checkDescriptor = iPlanCheckDescriptionArray[n2];
                if ("com.ibm.team.apt.plancheck.requiredAttribute".equals(checkDescriptor.getId())) {
                    result.add((PlanCheck)new RequiredAttributeCheck(checkDescriptor));
                } else {
                    if ("com.ibm.team.tempo.simulation".equals(checkDescriptor.getId())) {
                        try {
                            licenseClient.assertLicense("com.ibm.team.apt.riskManagement.probabilitySimulation", monitor);
                        }
                        catch (LicenseNotGrantedException e) {
                            break block6;
                        }
                    }
                    result.add((PlanCheck)new ScriptablePlanCheck(checkDescriptor, scriptEnvironment));
                }
            }
            ++n2;
        }
        return result;
    }

    public static boolean filterV3PlanMode(IPlanModeDescription description) {
        if ("com.ibm.team.apt.viewmodes.internal.milestone.roadmap".equals(description.getId())) {
            return true;
        }
        IViewModeDescription viewMode = description.getViewMode();
        if ("com.ibm.team.apt.shared.ui.internal.viewmodes.KanbanViewMode".equals(viewMode.getImplementationName())) {
            return true;
        }
        ISortModeDescription sortMode = description.getSortMode();
        return "com.ibm.team.apt.sortmode.newRanking".equals(sortMode.getId());
    }

    public static List<IGroupModeDescription> filterGroupModes(List<IGroupModeDescription> descriptions) {
        ArrayList<IGroupModeDescription> result = new ArrayList<IGroupModeDescription>(descriptions.size());
        for (IGroupModeDescription description : descriptions) {
            if ("com.ibm.team.apt.groupmode.quickQuery".equals(description.getId())) continue;
            result.add(description);
        }
        return result;
    }

    public static List<IViewModeDescription> filterViewModes(List<IViewModeDescription> descriptions) {
        ArrayList<IViewModeDescription> result = new ArrayList<IViewModeDescription>(descriptions.size());
        for (IViewModeDescription description : descriptions) {
            if ("com.ibm.team.apt.internal.viewmode.kanban".equals(description.getId())) continue;
            result.add(description);
        }
        return result;
    }

    public static List<ISortModeDescription> filterSortModes(List<ISortModeDescription> descriptions) {
        ArrayList<ISortModeDescription> result = new ArrayList<ISortModeDescription>(descriptions.size());
        for (ISortModeDescription description : descriptions) {
            if ("com.ibm.team.apt.sortmode.newRanking".equals(description.getId())) continue;
            result.add(description);
        }
        return result;
    }

    public static List<IFilterDescription> excludeWebOnlyFilters(List<IFilterDescription> descriptions) {
        return IterationPlanData.excludeWebOnlyFilters(descriptions);
    }

    public static IAttributeDefinitionDescriptor[] handleV3Columns(IColumnDescriptor[] columns, ResolvedPlan plan) {
        ArrayList<IAttributeDefinitionDescriptor> result = new ArrayList<IAttributeDefinitionDescriptor>();
        IColumnDescriptor[] iColumnDescriptorArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnDescriptor columnDesc = iColumnDescriptorArray[n2];
            IAttributeDefinitionDescriptor attributeDesc = columnDesc.getAttribute();
            if (V3_ATTRIBUTES.contains(attributeDesc.getId())) {
                IPlanningAttribute attribute;
                if ("com.ibm.team.apt.attribute.planitem.humanReadableRanking".equals(attributeDesc.getId()) && !PlanningUICustomizationSupport.hasPriority(columns) && plan != null && (attribute = plan.getAttributeRegistry().getAttribute(PlanItem.PRIORITY)) instanceof AbstractPlanningAttribute) {
                    result.add(((AbstractPlanningAttribute)attribute).getAttributeDescriptor());
                }
            } else {
                result.add(attributeDesc);
            }
            ++n2;
        }
        return result.toArray(new IAttributeDefinitionDescriptor[result.size()]);
    }

    private static boolean hasPriority(IColumnDescriptor[] columns) {
        IColumnDescriptor[] iColumnDescriptorArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnDescriptor column = iColumnDescriptorArray[n2];
            if ("com.ibm.team.apt.attribute.planitem.priority".equals(column.getAttribute().getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

