/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.widgets.PlanElementSelectionTransfer;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineViewer;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class PlanViewerDragAdapter
extends DragSourceAdapter {
    private final OutlineViewer fOutlineViewer;

    public PlanViewerDragAdapter(OutlineViewer outlineViewer) {
        this.fOutlineViewer = outlineViewer;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.fOutlineViewer.getSelection();
        if (selection.isEmpty()) {
            ((DragSource)event.widget).setTransfer(new Transfer[0]);
            event.doit = false;
            return;
        }
        ArrayList<PlanElementSelectionTransfer> supportedTransfers = new ArrayList<PlanElementSelectionTransfer>();
        PlanElementSelectionTransfer pt = PlanElementSelectionTransfer.getTransfer();
        LocalSelectionTransfer lt = LocalSelectionTransfer.getTransfer();
        URIReferenceTransfer ut = URIReferenceTransfer.getInstance();
        pt.setSelection(this.convertSelection(selection));
        pt.setSelectionSetTime(event);
        supportedTransfers.add(pt);
        IStructuredSelection external = this.validateSelection(selection);
        if (external != null) {
            lt.setSelection((ISelection)external);
            supportedTransfers.add((PlanElementSelectionTransfer)lt);
            supportedTransfers.add((PlanElementSelectionTransfer)ut);
        }
        ((DragSource)event.widget).setTransfer(supportedTransfers.toArray(new Transfer[supportedTransfers.size()]));
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        if (URIReferenceTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (selection != null && !selection.isEmpty()) {
                ArrayList<URIReference> references = new ArrayList<URIReference>(selection.size());
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    URIReference reference = Hyperlinks.createHyperlink(iterator.next());
                    if (reference == null) continue;
                    references.add(reference);
                }
                if (!references.isEmpty()) {
                    event.data = references.toArray(new URIReference[references.size()]);
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getTransfer().getSelection();
        } else if (PlanElementSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = PlanElementSelectionTransfer.getTransfer().getSelection();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 0) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fOutlineViewer.getSelection();
        for (IViewEntry entry : selection) {
            if (!EntryUtils.isType(entry, PlanItem.class)) continue;
            ((PlanItem)entry.getElement()).modified();
        }
    }

    protected Object convertToExternal(Object in) {
        return in;
    }

    private IStructuredSelection validateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        int i = 0;
        Object[] convertedSelection = new Object[selection.size()];
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object externalObject = this.convertToExternal(((IViewEntry)iterator.next()).getElement());
            if (externalObject == null) {
                return null;
            }
            convertedSelection[i++] = externalObject;
        }
        return new StructuredSelection(convertedSelection);
    }

    private IStructuredSelection convertSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        ArrayList<Object> convertedSelection = new ArrayList<Object>(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            convertedSelection.add(((IViewEntry)iterator.next()).getElement());
        }
        return new StructuredSelection(convertedSelection);
    }
}

