/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.resource.ProjectWorkEnvironment;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.Resolver;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.ContributorImageResolver;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PlanOutlineResources
extends OutlineResources {
    private final Color fSummaryColor;
    private final Color fNoContentColor;
    private final Color fTextFieldColor;
    private final Font fParentSummaryFont;
    private final Color fParentSummaryColor;
    private final Font fGroupTextFont;
    private final Color fGroupTextColor;
    private final Font fLoadStatusFont;
    private final Color fMarkerIdColumnColor;
    private final Color fTableGridColor;
    private final LineAttributes fTableGridStyle;
    private final Color fItemCompletedColor;
    private final Color fItemSpecialColor;
    private final Image fOutOfOfficeImage;
    private final Image fCompleteImage;
    private final Image fDueDateImage;
    private final Image fDurationImage;
    private final Image fIterationImage;
    private final Image fCategoryImage;
    private final ILabelProvider fWorkItemLabelProvider;
    private final ItemHashMap<IContributorHandle, Image> fOwnerImages;
    private int fGroupNodeSpacing;
    private int fPlanItemSpacing;
    private Font fProgressLabelFont;
    private final Color fProgressBorderColor;
    private final Color fProgressBarColor;
    private BarResources fBarResources;
    private DurationFormat fDurationFormat;

    public PlanOutlineResources(Control control) {
        super(control);
        Font font = control.getFont();
        this.fWorkItemLabelProvider = WorkItemUI.createWorkItemLabelProvider();
        LocalResourceManager manager = this.getResourceManager();
        this.fSummaryColor = JazzResources.getColor((ResourceManager)manager, (ColorDescriptor)PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getColorDescriptor("com.ibm.team.apt.ide.ui.SUMMARY"));
        this.fNoContentColor = PlanningUIPlugin.getDefault().getDarkShadow();
        this.fTextFieldColor = JazzResources.getColor((ResourceManager)manager, (RGB)this.getSystemColor(25));
        this.fGroupTextColor = this.getFormColors().getColor("org.eclipse.ui.forms.TITLE");
        FontData[] newDatas = this.modifyFont(font, 2, 1);
        this.fGroupTextFont = JazzResources.getFont((ResourceManager)manager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
        int shrink = SWT.getPlatform().equals("carbon") ? 2 : 1;
        newDatas = this.modifyFont(font, -shrink, 0);
        this.fLoadStatusFont = JazzResources.getFont((ResourceManager)manager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
        this.fCompleteImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.PLAN_ITEM_COMPLETE);
        this.fDueDateImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.DUE_DATE);
        this.fDurationImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.DURATION);
        this.fIterationImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.ITERATION_PLAN_OBJ);
        this.fCategoryImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.CATEGORY);
        this.fOutOfOfficeImage = JazzResources.getImageWithDefault((ResourceManager)manager, (ImageDescriptor)ImagePool.OUT_OF_OFFICE);
        this.fOwnerImages = new ItemHashMap(32);
        this.fGroupNodeSpacing = 0;
        this.fPlanItemSpacing = (int)((double)this.getFontMetrics().getHeight() * 0.333);
        this.fMarkerIdColumnColor = this.createMarkerIdColumnColor();
        this.fTableGridColor = this.createTableGridColor();
        this.fTableGridStyle = new LineAttributes(1.0f);
        this.fTableGridStyle.style = 6;
        this.fTableGridStyle.dash = new float[]{1.0f, 2.0f};
        this.fItemCompletedColor = PlanningUIPlugin.getDefault().getDarkShadow();
        this.fItemSpecialColor = this.blend(18, 22, 30);
        newDatas = this.modifyFont(font, -shrink, 0);
        this.fProgressLabelFont = JazzResources.getFont((ResourceManager)manager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
        this.fProgressBorderColor = PlanningUIPlugin.getDefault().getMidShadow();
        this.fProgressBarColor = JazzResources.getColor((ResourceManager)manager, (RGB)new RGB(162, 195, 162));
        newDatas = this.modifyFont(font, -shrink, 0);
        this.fParentSummaryFont = JazzResources.getFont((ResourceManager)manager, (FontDescriptor)FontDescriptor.createFrom((FontData[])newDatas), (Font)font);
        this.fParentSummaryColor = JazzResources.getColor((ResourceManager)manager, (RGB)new RGB(151, 116, 88));
        this.fBarResources = new BarResources((ResourceManager)this.getResourceManager(), this.getProgressStatusFont());
    }

    protected FontData[] modifyFont(Font font, int deltaHeight, int deltaStyle) {
        FontData[] datas = font.getFontData();
        FontData[] newDatas = new FontData[datas.length];
        int i = 0;
        while (i < datas.length) {
            FontData data = datas[i];
            newDatas[i] = new FontData(data.getName(), Math.max(6, data.getHeight() + deltaHeight), data.getStyle() | deltaStyle);
            ++i;
        }
        return newDatas;
    }

    protected Color createTableGridColor() {
        return this.blend(22, 25, 75);
    }

    protected Color createMarkerIdColumnColor() {
        return this.blend(22, 25, 40);
    }

    @Override
    protected void dispose() {
        this.fWorkItemLabelProvider.dispose();
        super.dispose();
    }

    public int getGroupNodeSpacing() {
        return this.fGroupNodeSpacing;
    }

    public int getPlanItemSpacing() {
        return this.fPlanItemSpacing;
    }

    @Override
    public int getSpaceWidth() {
        return 2;
    }

    public int getDescriptionSpacing() {
        return 5;
    }

    public int getStatusSpacing() {
        return 4;
    }

    public int getProblemMarkerSpacing() {
        return 5;
    }

    public int getIconSummarySpacing() {
        return 5;
    }

    public int getSummaryIdSpacing() {
        return 2 * this.getSpaceWidth();
    }

    public Color getGroupTextColor() {
        return this.fGroupTextColor;
    }

    public Color getLabelColor() {
        return this.fSummaryColor;
    }

    public Font getGroupTextFont() {
        return this.fGroupTextFont;
    }

    public Font getParentSummaryFont() {
        return this.fParentSummaryFont;
    }

    public Color getParentSummaryColor() {
        return this.fParentSummaryColor;
    }

    public Color getSummaryColor() {
        return this.fSummaryColor;
    }

    public Color getTextFieldColor() {
        return this.fTextFieldColor;
    }

    public Color getNoContentColor() {
        return this.fNoContentColor;
    }

    public Image getCompleteImage() {
        return this.fCompleteImage;
    }

    public Image getDueDateImage() {
        return this.fDueDateImage;
    }

    public Image getOutOfOfficeImage() {
        return this.fOutOfOfficeImage;
    }

    public Image getDurationImage() {
        return this.fDurationImage;
    }

    public Image getIterationImage() {
        return this.fIterationImage;
    }

    public Image getCategoryImage() {
        return this.fCategoryImage;
    }

    public ILabelProvider getWorkItemLabelProvider() {
        return this.fWorkItemLabelProvider;
    }

    public Image getWorkItemTypeImage(IWorkItemType type) {
        ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((IWorkItemType)type);
        return JazzResources.getImageWithDefault((ResourceManager)this.getResourceManager(), (ImageDescriptor)descriptor);
    }

    public Font getGroupStatusFont() {
        return this.getTextFonts().getNormalFont();
    }

    public Color getGroupStatusColor() {
        return this.fGroupTextColor;
    }

    public Font getLoadStatusFont() {
        return this.fLoadStatusFont;
    }

    public Font getProgressStatusFont() {
        return this.fLoadStatusFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamFuture<Image> getOwnerImageFuture(Display display, final IContributor owner) {
        Image result;
        ItemHashMap<IContributorHandle, Image> itemHashMap = this.fOwnerImages;
        synchronized (itemHashMap) {
            result = (Image)this.fOwnerImages.get((IItemHandle)owner);
        }
        if (result != null) {
            return new TeamFuture((Object)result);
        }
        final TeamFuture future = new TeamFuture((Resolver)new ContributorImageResolver(display, this.getResourceManager(), (IContributorHandle)owner));
        future.addListener((ITeamFutureListener)new TeamFutureAdapter<Image>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resolvingDone(TeamFutureEvent<Image> event) {
                ItemHashMap itemHashMap = PlanOutlineResources.this.fOwnerImages;
                synchronized (itemHashMap) {
                    PlanOutlineResources.this.fOwnerImages.put((IItemHandle)owner, (Object)((Image)future.getResult()));
                }
            }
        });
        return future;
    }

    public Color getMarkerIdColumnColor() {
        return this.fMarkerIdColumnColor;
    }

    public int getMarkerColumnWidth() {
        return 16;
    }

    public int getIdSpacing() {
        return 4;
    }

    public Color getItemCompletedColor() {
        return this.fItemCompletedColor;
    }

    public Color getItemSpecialColor() {
        return this.fItemSpecialColor;
    }

    public LineAttributes getTableGridStyle() {
        return this.fTableGridStyle;
    }

    public Color getTableGridColor() {
        return this.fTableGridColor;
    }

    public Font getProgressLabelFont() {
        return this.fProgressLabelFont;
    }

    public Color getProgressBorderColor() {
        return this.fProgressBorderColor;
    }

    public Color getProgressBarColor() {
        return this.fProgressBarColor;
    }

    public BarResources getBarResources() {
        return this.fBarResources;
    }

    public DurationFormat getDurationFormat(ResolvedPlan plan) {
        if (this.fDurationFormat != null) {
            return this.fDurationFormat;
        }
        ProjectWorkEnvironment workEnvironment = plan.getProjectWorkEnvironment();
        this.fDurationFormat = this.createDurationFormat();
        this.fDurationFormat.setMillisPerDay(workEnvironment.getWorkMillisPerDay());
        this.fDurationFormat.setDaysPerWeek(workEnvironment.getWorkDaysPerWeek());
        EstimateOutputFormat outputFormat = plan.getEstimateOutputFormat();
        if (EstimateOutputFormat.Hours.equals((Object)outputFormat)) {
            this.fDurationFormat.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
        }
        return this.fDurationFormat;
    }

    protected DurationFormat createDurationFormat() {
        DurationFormat result = new DurationFormat();
        result.setUnspecifiedString("-");
        return result;
    }
}

