/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.OpenPlanAction;
import com.ibm.team.apt.internal.ide.ui.actions.OpenUserAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.GenericElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.OwnerElement;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;

public class PlanOpenListener
implements IOpenListener {
    private final IWorkbenchPage fPage;

    public PlanOpenListener(IWorkbenchPage page) {
        Assert.isNotNull((Object)page);
        this.fPage = page;
    }

    public void open(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object entry = selection.getFirstElement();
        if (entry instanceof IViewEntry) {
            Object element = ((IViewEntry)entry).getElement();
            if (element instanceof PlanItem) {
                WorkItemUI.openEditor((IWorkbenchPage)this.fPage, (Object)((PlanItem)element).getWorkItemHandle());
            } else if (element instanceof OwnerElement) {
                IContributor owner = ((OwnerElement)element).getOwner();
                new OpenUserAction(this.fPage, owner, null).run();
            } else if (element instanceof GenericElement) {
                OpenPlanAction action = new OpenPlanAction((IWorkbenchSite)this.fPage.getActivePart().getSite(), (PlanViewModel)((IViewEntry)entry).getModel());
                action.selectionChanged(new SelectionChangedEvent((ISelectionProvider)event.getSource(), (ISelection)selection));
                action.run();
            }
        }
    }
}

