/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.client.planchecker.IPlanCheckListener;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckEngine;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.ISidebarAction;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;

public class PlanCheckTriggerAction
extends Action
implements ISidebarAction {
    private final PlanCheckEngine fCheckEngine;
    private final PlanCheck fPlanCheck;
    private boolean fInProgress = false;
    private final Control fControl;
    private IPlanCheckListener fPlanCheckListener = new IPlanCheckListener(){

        public void stateChange(PlanCheck check, final PlanCheck.State newState) {
            if (PlanCheckTriggerAction.this.fPlanCheck.equals(check)) {
                PlanCheckTriggerAction.this.fInProgress = newState == PlanCheck.State.Running;
                UI.asyncExec(PlanCheckTriggerAction.this.fControl, new Runnable(){

                    @Override
                    public void run() {
                        PlanCheckTriggerAction.this.firePropertyChange("inprogress", newState != PlanCheck.State.Running, newState == PlanCheck.State.Running);
                    }
                });
            }
        }
    };

    public PlanCheckTriggerAction(PlanCheckEngine checkEngine, PlanCheck planCheck, Control control) {
        this.fCheckEngine = checkEngine;
        this.fPlanCheck = planCheck;
        this.fControl = control;
        IPlanCheckDescription checkDescription = planCheck.getCheckDescription();
        this.setText(checkDescription.getDisplayName());
        this.setToolTipText(checkDescription.getDescription());
        this.setImageDescriptor(ImagePool.VERIFY_RUN_ENABLED);
        this.setDisabledImageDescriptor(ImagePool.VERIFY_RUN_DISABLED);
        this.fPlanCheck.addListener(this.fPlanCheckListener);
    }

    @Override
    public boolean isInProgress() {
        return this.fInProgress;
    }

    @Override
    public void dispose() {
        this.fPlanCheck.removeListener(this.fPlanCheckListener);
    }

    public void run() {
        this.fCheckEngine.runFullCheck(Collections.singleton(this.fPlanCheck));
    }
}

