/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.ide.ui.common.IGadgetCreator;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.HashMap;
import java.util.Map;

public class GadgetFactory {
    private final Map<Class<?>, IGadgetCreator<?>> fCreators = new HashMap();

    public GadgetFactory(IGadgetCreator[] creators) {
        IGadgetCreator[] iGadgetCreatorArray = creators;
        int n = creators.length;
        int n2 = 0;
        while (n2 < n) {
            IGadgetCreator gadgetCreator = iGadgetCreatorArray[n2];
            this.fCreators.put(gadgetCreator.getEntryType(), gadgetCreator);
            ++n2;
        }
    }

    public <T> GTreeNode<?> createGadget(ContentOutlineItem outlineItem, IViewEntry<T> entry) {
        IGadgetCreator<?> gadgetCreator = this.fCreators.get(entry.getElement().getClass());
        if (gadgetCreator == null) {
            for (IGadgetCreator<?> candidate : this.fCreators.values()) {
                if (!candidate.getEntryType().isInstance(entry.getElement())) continue;
                gadgetCreator = candidate;
                this.fCreators.put(entry.getElement().getClass(), gadgetCreator);
                break;
            }
        }
        if (gadgetCreator != null) {
            return gadgetCreator.createGadget(outlineItem, entry);
        }
        return null;
    }
}

