/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.resources;

import com.ibm.team.apt.internal.ide.ui.aspect.AbstractProcessAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.resources.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class WorkResourcesAspectEditor
extends AbstractProcessAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.workResourcesSpecification";
    private static final String ATTRIBUTE_DAYS = "workDays";
    private static final String ATTRIBUTE_HOURS = "workHours";
    private static final String ATTRIBUTE_MINUTES = "workMinutes";
    private static final String ATTRIBUTE_ENDTIME = "quittingTime";
    private static final String ATTRIBUTE_UPDATE_ALLOCATION_SELF = "disallowAllocationBySelf";
    private static final String ELEMENT_SPECIFICATION = "workResourcesSpecification";
    private static final String WORKING_DAYS_SPECIFICATION = "workingDaysSpecification";
    private static final String DAY_MONDAY = "monday";
    private static final String DAY_TUESDAY = "tuesday";
    private static final String DAY_WEDNESDAY = "wednesday";
    private static final String DAY_THURSDAY = "thursday";
    private static final String DAY_FRIDAY = "friday";
    private static final String DAY_SATURDAY = "saturday";
    private static final String DAY_SUNDAY = "sunday";
    private static final Collection<DayObject> dayObjectList = new ArrayList<DayObject>(7);
    private static final int WORK_DAY_HOURS = 8;
    private static final int WORK_DAY_MINUTES = 0;
    private final Calendar fWorkTimeCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private long fEndTime = 61200000L;
    private int fDays = 5;
    private int fHours = 8;
    private int fMinutes = 0;
    private boolean fUpdateAllocation = true;
    private Spinner fHourSpinner;
    private Spinner fMinutesSpinner;
    private DateTime fEndTimeControl;
    private CheckboxTableViewer fViewer;
    private Button fButtonUpdateAllocation;

    @Override
    protected void createContents(Composite container) {
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        Group workTimeGroup = new Group(container, 16);
        workTimeGroup.setText(Messages.WorkResourcesAspectEditor_WORK_TIME_PER_DAY);
        GridLayout layout = new GridLayout(2, false);
        workTimeGroup.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)workTimeGroup);
        Label label = new Label((Composite)workTimeGroup, 0);
        label.setText(Messages.WorkResourcesAspectEditor_HOURS);
        this.fHourSpinner = new Spinner((Composite)workTimeGroup, 2112);
        this.fHourSpinner.setValues(this.fHours, 0, 24, 0, 1, 4);
        this.fHourSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourcesAspectEditor.this.updateHoursFromUI();
            }
        });
        this.fHourSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkResourcesAspectEditor.this.updateHoursFromUI();
            }
        });
        label = new Label((Composite)workTimeGroup, 0);
        label.setText(Messages.WorkResourcesAspectEditor_MINUTES);
        this.fMinutesSpinner = new Spinner((Composite)workTimeGroup, 2048);
        this.fMinutesSpinner.setValues(this.fMinutes, 0, 60, 0, 1, 10);
        this.fMinutesSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourcesAspectEditor.this.updateMinutesFromUI();
            }
        });
        this.fMinutesSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkResourcesAspectEditor.this.updateMinutesFromUI();
            }
        });
        UI.hookHelpListener((Control)container, "com.ibm.team.apt.ide.ui.aspect_work_env");
        Label endLabel = new Label(container, 64);
        endLabel.setText(Messages.WorkResourcesAspectEditor_END_TIME_LABEL);
        this.fEndTimeControl = new DateTime(container, 34944);
        this.setEndTime();
        this.fEndTimeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourcesAspectEditor.this.fWorkTimeCalendar.setTimeInMillis(0L);
                WorkResourcesAspectEditor.this.fWorkTimeCalendar.set(11, WorkResourcesAspectEditor.this.fEndTimeControl.getHours());
                WorkResourcesAspectEditor.this.fWorkTimeCalendar.set(12, WorkResourcesAspectEditor.this.fEndTimeControl.getMinutes());
                WorkResourcesAspectEditor.this.fEndTime = WorkResourcesAspectEditor.this.fWorkTimeCalendar.getTimeInMillis();
                WorkResourcesAspectEditor.this.setDirty();
            }
        });
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.fEndTimeControl);
        Label workingDaysLabel = new Label(container, 0);
        workingDaysLabel.setText(Messages.WorkResourcesAspectEditor_WORKINGDAYS);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)workingDaysLabel);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2080);
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                DayObject type = (DayObject)element;
                return type.name;
            }
        });
        this.updateUI();
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DayObject day = (DayObject)event.getElement();
                WorkResourcesAspectEditor.this.setWorkingDay(day.id, event.getChecked());
                WorkResourcesAspectEditor.this.setDirty();
            }
        });
        this.fViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.WorkResourcesAspectEditor_WORKINGDAYS;
                }
            }
        });
        GridDataFactory.swtDefaults().span(2, 1).applyTo(this.fViewer.getControl());
        Label permissionsLabel = new Label(container, 0);
        permissionsLabel.setText(Messages.WorkResourcesAspectEditor_PERMISSIONS);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)permissionsLabel);
        this.fButtonUpdateAllocation = new Button(container, 32);
        this.fButtonUpdateAllocation.setText(Messages.WorkResourcesAspectEditor_UPDATE_ALLOCATION_SELF_LABEL);
        this.fButtonUpdateAllocation.setBackground(container.getBackground());
        this.fButtonUpdateAllocation.setSelection(this.fUpdateAllocation);
        this.fButtonUpdateAllocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkResourcesAspectEditor.this.fUpdateAllocation = WorkResourcesAspectEditor.this.fButtonUpdateAllocation.getSelection();
                WorkResourcesAspectEditor.this.setDirty();
            }
        });
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.fButtonUpdateAllocation);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.fButtonUpdateAllocation);
    }

    private void setEndTime() {
        this.fWorkTimeCalendar.setTimeInMillis(this.fEndTime);
        this.fEndTimeControl.setHours(this.fWorkTimeCalendar.get(11));
        this.fEndTimeControl.setMinutes(this.fWorkTimeCalendar.get(12));
    }

    private long readEndTime(String endTime) {
        String[] timeArray = endTime.split(":");
        if (timeArray.length == 3) {
            this.fWorkTimeCalendar.setTimeInMillis(0L);
            this.fWorkTimeCalendar.set(11, Integer.parseInt(timeArray[0]));
            this.fWorkTimeCalendar.set(12, Integer.parseInt(timeArray[1]));
            this.fWorkTimeCalendar.set(13, Integer.parseInt(timeArray[2]));
            return this.fWorkTimeCalendar.getTimeInMillis();
        }
        return this.fEndTime;
    }

    private String writeEndTime(long value) {
        this.fWorkTimeCalendar.setTimeInMillis(this.fEndTime);
        return String.format("%tT", this.fWorkTimeCalendar);
    }

    private void setWorkingDay(String dayId, boolean workingDay) {
        for (DayObject day : dayObjectList) {
            if (!dayId.equals(day.id)) continue;
            day.isWorking = workingDay;
        }
    }

    private void updateUI() {
        this.fViewer.setInput(dayObjectList);
        this.fViewer.setCheckedElements((Object[])this.getWorkingDays());
    }

    private final DayObject[] getWorkingDays() {
        ArrayList<DayObject> result = new ArrayList<DayObject>(dayObjectList.size());
        for (DayObject day : dayObjectList) {
            if (!day.isWorking) continue;
            result.add(day);
        }
        return result.toArray(new DayObject[result.size()]);
    }

    @Override
    protected void doSaveState(IMemento memento) {
        IMemento spec = memento.createChild(ELEMENT_SPECIFICATION);
        IMemento workDaySpec = spec.createChild(WORKING_DAYS_SPECIFICATION);
        int count = 0;
        for (DayObject day : dayObjectList) {
            workDaySpec.putBoolean(day.id, day.isWorking);
            if (!day.isWorking) continue;
            ++count;
        }
        if (dayObjectList.size() > 0) {
            this.fDays = count;
        }
        spec.putInteger(ATTRIBUTE_HOURS, this.fHours);
        spec.putInteger(ATTRIBUTE_MINUTES, this.fMinutes);
        spec.putInteger(ATTRIBUTE_DAYS, this.fDays);
        spec.putString(ATTRIBUTE_ENDTIME, this.writeEndTime(this.fEndTime));
        spec.putBoolean(ATTRIBUTE_UPDATE_ALLOCATION_SELF, this.fUpdateAllocation);
    }

    @Override
    protected void doSetInput(ProcessAspect aspect) {
        this.readConfiguration();
    }

    private void readConfiguration() {
        ModelElement element;
        this.fHours = 8;
        this.fMinutes = 0;
        this.fDays = 5;
        this.initialiseWorkingDays();
        ProcessAspect aspect = this.getAspect();
        if (aspect != null && (element = aspect.getConfigurationElement()) != null && (element = WorkResourcesAspectEditor.findConfigurationElement(element, ELEMENT_SPECIFICATION)) != null) {
            String hours = element.getAttribute(ATTRIBUTE_HOURS);
            String minutes = element.getAttribute(ATTRIBUTE_MINUTES);
            String days = element.getAttribute(ATTRIBUTE_DAYS);
            String endTime = element.getAttribute(ATTRIBUTE_ENDTIME);
            String updateAllocation = element.getAttribute(ATTRIBUTE_UPDATE_ALLOCATION_SELF);
            try {
                this.fHours = Integer.parseInt(hours);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (minutes != null) {
                try {
                    this.fMinutes = Integer.parseInt(minutes);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                this.fDays = Integer.parseInt(days);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (endTime != null) {
                try {
                    this.fEndTime = this.readEndTime(endTime);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((element = WorkResourcesAspectEditor.findConfigurationElement(element, WORKING_DAYS_SPECIFICATION)) != null) {
                int count = 0;
                for (DayObject day : dayObjectList) {
                    String value = element.getAttribute(day.id);
                    day.isWorking = Boolean.parseBoolean(value);
                    if (day.isWorking) {
                        // empty if block
                    }
                    this.fDays = ++count;
                }
            } else {
                int count = 0;
                for (DayObject day : dayObjectList) {
                    day.isWorking = count < this.fDays;
                    ++count;
                }
            }
            this.fUpdateAllocation = Boolean.parseBoolean(updateAllocation);
        }
    }

    private void initialiseWorkingDays() {
        dayObjectList.clear();
        dayObjectList.add(new DayObject(DAY_MONDAY, Messages.WorkResourcesAspectEditor_MONDAY, true));
        dayObjectList.add(new DayObject(DAY_TUESDAY, Messages.WorkResourcesAspectEditor_TUESDAY, true));
        dayObjectList.add(new DayObject(DAY_WEDNESDAY, Messages.WorkResourcesAspectEditor_WEDNESDAY, true));
        dayObjectList.add(new DayObject(DAY_THURSDAY, Messages.WorkResourcesAspectEditor_THURSDAY, true));
        dayObjectList.add(new DayObject(DAY_FRIDAY, Messages.WorkResourcesAspectEditor_FRIDAY, true));
        dayObjectList.add(new DayObject(DAY_SATURDAY, Messages.WorkResourcesAspectEditor_SATURDAY, false));
        dayObjectList.add(new DayObject(DAY_SUNDAY, Messages.WorkResourcesAspectEditor_SUNDAY, false));
    }

    @Override
    protected String getOptionName() {
        return Messages.WorkResourcesAspectEditor_PROJECT_WORK_SETTINGS;
    }

    private void updateHoursFromUI() {
        int selection = this.fHourSpinner.getSelection();
        if (selection != this.fHours) {
            this.fHours = selection;
            this.setDirty();
        }
    }

    private void updateMinutesFromUI() {
        int selection = this.fMinutesSpinner.getSelection();
        if (selection != this.fMinutes) {
            this.fMinutes = selection;
            this.setDirty();
        }
    }

    public void revert() {
        this.readConfiguration();
        this.fHourSpinner.setSelection(this.fHours);
        this.fMinutesSpinner.setSelection(this.fMinutes);
        this.fButtonUpdateAllocation.setSelection(this.fUpdateAllocation);
        this.setEndTime();
        this.updateUI();
        this.setDirty(false);
    }

    protected static final class DayObject {
        public String id;
        public String name;
        public boolean isWorking;

        public DayObject(String dayId, String dayName, boolean working) {
            this.id = dayId;
            this.name = dayName;
            this.isWorking = working;
        }
    }
}

