/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import org.eclipse.core.runtime.IProgressMonitor;

public class BlockedHelper {
    private static final String WORK_ITEMS_ASPECT_ID = "com.ibm.team.workitem.category";

    private BlockedHelper() {
    }

    public static boolean hasPermission(IProjectAreaHandle projectArea, IProgressMonitor monitor) {
        ProcessClientService processClient = (ProcessClientService)PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).getClientLibrary(IProcessItemService.class);
        try {
            boolean assertPermission = processClient.assertPermission("JazzProjectAdmins", monitor);
            return assertPermission;
        }
        catch (TeamRepositoryException e) {
            return false;
        }
    }

    public static TypeCategory[] getWorkItemTypes(IProcessAspectEditorSite aspectSite) {
        return TypeManager.readTypeCategories((ModelElement)BlockedHelper.getWorkItemTypesModel(aspectSite)).toArray(new TypeCategory[0]);
    }

    public static ModelElement getWorkItemTypesModel(IProcessAspectEditorSite aspectSite) {
        return aspectSite.getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
    }

    public static boolean hasConfiguration(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((ITeamRepository)PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea));
        IAttribute blockedAtt = workItemClient.findAttribute(projectArea, "com.ibm.team.apt.attribute.planitem.blocked", monitor);
        return blockedAtt != null;
    }

    public static boolean showProcessSharingWarning(ProcessAspect processAspect, boolean isProcessConsumer) {
        return isProcessConsumer && (!BlockedHelper.isWorkItemTypesConfigured(processAspect) || !BlockedHelper.isPlanningAttributesConfigured(processAspect));
    }

    public static ProcessAspect getPlanAttributesAspect(ProcessAspect processAspect) {
        ProcessAspect projectDataAspect = processAspect.getParentAspect();
        return projectDataAspect.getChildAspect("com.ibm.team.apt.configuration.attributes");
    }

    public static ProcessAspect getTypeManagerAspect(ProcessAspect processAspect) {
        ProcessAspect projectDataAspect = processAspect.getParentAspect().getParentAspect();
        return projectDataAspect.getChildAspect(WORK_ITEMS_ASPECT_ID).getChildAspect("com.ibm.team.workitem.configuration.workItemTypes");
    }

    private static boolean isWorkItemTypesConfigured(ProcessAspect processAspect) {
        return BlockedHelper.getTypeManagerAspect(processAspect).getConfigurationElement() != null;
    }

    private static boolean isPlanningAttributesConfigured(ProcessAspect processAspect) {
        return BlockedHelper.getPlanAttributesAspect(processAspect).getConfigurationElement() != null;
    }
}

