/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked;

import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.util.Collections2;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked.BlockedHelper;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.common.util.XMLUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BlockedConfiguration {
    private final List<TypeCategory> fSelectedWorkItemTypes = Collections.synchronizedList(new ArrayList());
    private boolean fCanActivate = false;
    private TypeCategory[] fTypes;
    private boolean fShowProcessSharingWarning = false;

    public synchronized void setSelectedWorkItemTypes(List<TypeCategory> types) {
        this.fSelectedWorkItemTypes.clear();
        this.fSelectedWorkItemTypes.addAll(types);
    }

    public synchronized List<TypeCategory> getSelectedWorkItemTypes() {
        return this.fSelectedWorkItemTypes;
    }

    public synchronized void setAllWorkItemTypes(TypeCategory[] types) {
        this.fTypes = types;
    }

    public synchronized TypeCategory[] getAllTypes() {
        return this.fTypes;
    }

    public boolean canActivate() {
        return this.fCanActivate;
    }

    public void setCanActivate(boolean canActivate) {
        this.fCanActivate = canActivate;
    }

    public boolean saveIfAvailable(IProcessAspectEditorSite site, ProcessAspect processAspect, String lineDelimiter) {
        if (this.fSelectedWorkItemTypes.isEmpty()) {
            return false;
        }
        this.setCanActivate(false);
        TypeCategory.CustomAttribute[] workItemAttributes = this.createWorkItemAttributes(processAspect, site, lineDelimiter);
        this.createPlanningAttributes(lineDelimiter, processAspect, workItemAttributes);
        return true;
    }

    public void setShowProcessSharingWarning(boolean showProcessSharingWarning) {
        this.fShowProcessSharingWarning = showProcessSharingWarning;
    }

    public boolean isShowProcessSharingWarning() {
        return this.fShowProcessSharingWarning;
    }

    private TypeCategory.CustomAttribute[] createWorkItemAttributes(ProcessAspect processAspect, IProcessAspectEditorSite site, String lineDelimiter) {
        ModelElement workItemTypesModel = BlockedHelper.getWorkItemTypesModel(site);
        TypeCategory.CustomAttribute[] workItemAttributes = new TypeCategory.CustomAttribute[]{new TypeCategory.CustomAttribute("com.ibm.team.apt.attribute.planitem.blocked", Messages.BlockedConfiguration_BLOCKED_ATT, "boolean", true, true, false, workItemTypesModel), new TypeCategory.CustomAttribute("com.ibm.team.apt.attribute.planitem.blockedReason", Messages.BlockedConfiguration_BLOCKED_REASON_ATT, "mediumString", true, true, false, workItemTypesModel)};
        for (TypeCategory typeCategory : this.fSelectedWorkItemTypes) {
            TypeCategory.CustomAttribute[] customAttributeArray = workItemAttributes;
            int n = workItemAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeCategory.CustomAttribute attribute = customAttributeArray[n2];
                typeCategory.addCustomAttribute(attribute);
                ++n2;
            }
        }
        ProcessAspect workItemTypeAspect = this.getTypeManagerAspect(processAspect);
        String xmlTag = workItemTypeAspect.getXmlTag();
        XMLMemento wfMemento = XMLMemento.createWriteRoot((String)xmlTag);
        wfMemento.putString("id", "com.ibm.team.workitem.configuration.workItemTypes");
        String namespace = workItemTypeAspect.getSchemaNamespaceURI();
        if (namespace != null) {
            wfMemento.putString("xmlns", namespace);
        }
        TypeCategory[] all = this.getAllTypes();
        ArrayList<TypeCategory> merged = new ArrayList<TypeCategory>(all.length);
        Map byId = Collections2.createMap(this.fSelectedWorkItemTypes, (Collections2.IKeyFactory)new Collections2.IKeyFactory<TypeCategory, String>(){

            public String createKey(TypeCategory element) {
                return element.getIdentifier();
            }
        });
        TypeCategory[] typeCategoryArray = all;
        int n = all.length;
        int n3 = 0;
        while (n3 < n) {
            TypeCategory typeCategory = typeCategoryArray[n3];
            if (byId.containsKey(typeCategory.getIdentifier())) {
                merged.add((TypeCategory)byId.get(typeCategory.getIdentifier()));
            } else {
                merged.add(typeCategory);
            }
            ++n3;
        }
        this.writeWorkItemTypeCategories(wfMemento, merged);
        String xmlString = XMLUtil.asXMLString((XMLMemento)wfMemento, (String)lineDelimiter);
        workItemTypeAspect.update(xmlString, true);
        return workItemAttributes;
    }

    protected void writeWorkItemTypeCategories(XMLMemento memento, List<TypeCategory> typeCategories) {
        TypeManager.writeTypeCategories((IMemento)memento, typeCategories, null);
    }

    private void createPlanningAttributes(String lineDelimiter, ProcessAspect processAspect, TypeCategory.CustomAttribute ... attributes) {
        ProcessAspect planAttributesAspect = this.getPlanAttributesAspect(processAspect);
        ModelElement element = planAttributesAspect.getConfigurationElement();
        if (element != null) {
            INode node = INode.FACTORY.createNode((Object)element, null);
            HashSet<IAttributeDefinitionDescriptor> processSpecAttributes = new HashSet<IAttributeDefinitionDescriptor>();
            processSpecAttributes.addAll(ConfigurationElementFactory.allInstances(IAttributeDefinitionDescriptor.class, (INode)node));
            TypeCategory.CustomAttribute[] customAttributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeCategory.CustomAttribute customAttribute = customAttributeArray[n2];
                processSpecAttributes.add(this.createProxy(customAttribute));
                ++n2;
            }
            XMLMemento planAttsMemento = XMLMemento.createWriteRoot((String)planAttributesAspect.getXmlTag());
            planAttsMemento.putString("id", "com.ibm.team.apt.configuration.attributes");
            String namespace = planAttributesAspect.getSchemaNamespaceURI();
            if (namespace != null) {
                planAttsMemento.putString("xmlns", namespace);
            }
            for (IConfigurationElement iConfigurationElement : processSpecAttributes) {
                ConfigurationElementFactory.serializeIntoRoot((Object)iConfigurationElement, (IMemento)planAttsMemento);
            }
            this.serializeComplexityAttributeIfExists(node, planAttsMemento);
            planAttributesAspect.update(XMLUtil.asXMLString((XMLMemento)planAttsMemento, (String)lineDelimiter), true);
        }
    }

    private void serializeComplexityAttributeIfExists(INode node, XMLMemento planAttsMemento) {
        IComplexityAttribute complexityAttribute = this.getComplexityAttribute(node);
        if (complexityAttribute != null) {
            ConfigurationElementFactory.serializeIntoRoot((Object)complexityAttribute, (IMemento)planAttsMemento);
        }
    }

    protected IComplexityAttribute getComplexityAttribute(INode node) {
        return (IComplexityAttribute)ConfigurationElementFactory.singleInstance(IComplexityAttribute.class, (INode)node);
    }

    private IAttributeDefinitionDescriptor createProxy(TypeCategory.CustomAttribute customAttribute) {
        IAttributeDefinitionDescriptor result = (IAttributeDefinitionDescriptor)ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
        result.setDisplayName(customAttribute.getName());
        result.setId("com.ibm.team.apt.attributes._" + customAttribute.getId());
        result.setImplementationName("com.ibm.team.apt.client.WorkItemAttribute");
        result.setParameters(new IParameter[]{IParameter.FACTORY.create("attribute", customAttribute.getId())});
        result.setType(PlanItemAttributes.getPlanningAttributeType((String)customAttribute.getAttributeType()));
        return result;
    }

    protected ProcessAspect getPlanAttributesAspect(ProcessAspect processAspect) {
        return BlockedHelper.getPlanAttributesAspect(processAspect);
    }

    protected ProcessAspect getTypeManagerAspect(ProcessAspect processAspect) {
        return BlockedHelper.getTypeManagerAspect(processAspect);
    }
}

