/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.client.workingcopies.IProcessContainerWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.AspectEditorUtil;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ModeledElement;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.ProcessAttachmentIconSelectionDialog;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class RequiredEstimatesEditor
extends OperationDetailsAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.advisor.requiredEstimates";
    private static final String ID = "id";
    private static final String PROPERTIES = "estimates";
    private static final String PROPERTY = "estimate";
    private static final String WORKITEMTYPE = "workItemType";
    private static final String WORKITEMTYPECATEGORY = "workItemTypeCategory";
    private List<Attribute> fBuiltInAttributes;
    private List<TypeCategory> fCategories;
    private Map<ModeledElement, RequiredEstimate> fEstimateTypeMap;
    private TableViewer fPropertiesViewer;
    private List<RequiredEstimate> fRequiredEstimates;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private TypeCategory fUnspecified;

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Table t = new Table(parent, 67586);
        t.setLayoutData((Object)new GridData(4, 4, true, true));
        t.setHeaderVisible(true);
        TableColumn c = new TableColumn(t, 0);
        c.setWidth(250);
        c.setResizable(true);
        c.setText(Messages.RequiredEstimatesEditor_0);
        c = new TableColumn(t, 0);
        c.setWidth(200);
        c.setResizable(true);
        c.setText(Messages.RequiredEstimatesEditor_1);
        this.fPropertiesViewer = new TableViewer(t);
        this.fPropertiesViewer.setColumnProperties(new String[]{Messages.RequiredEstimatesEditor_2, Messages.RequiredEstimatesEditor_3});
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            private String getAttributes(ModeledElement element) {
                HashSet<Attribute> attributes = new HashSet<Attribute>();
                RequiredEstimate prop = (RequiredEstimate)RequiredEstimatesEditor.this.fEstimateTypeMap.get(element);
                if (prop != null) {
                    attributes.addAll(prop.getRequiredAttributes());
                }
                String result = "";
                ArrayList atts = new ArrayList(attributes);
                Collections.sort(atts, new Comparator<Attribute>(){
                    Collator collator = CollatorCache.getInstance();

                    @Override
                    public int compare(Attribute o1, Attribute o2) {
                        if (o1.getName() != null && o2.getName() != null) {
                            return this.collator.compare(o1.getName(), o2.getName());
                        }
                        return -1;
                    }
                });
                if (atts.isEmpty()) {
                    result = Messages.RequiredEstimatesEditor_5;
                } else {
                    for (Attribute a : atts) {
                        result = !result.equals("") ? NLS.bind((String)Messages.RequiredEstimatesEditor_4, (Object)result, (Object[])new Object[]{a.getName()}) : a.getName();
                    }
                }
                return result;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (cell.getColumnIndex() == 0 && element instanceof TypeCategory.Type) {
                    if (((TypeCategory.Type)element).getIcon() != null) {
                        cell.setImage(this.getImage(element, ((TypeCategory.Type)element).getIcon()));
                    } else {
                        cell.setImage(null);
                    }
                    cell.setText(((TypeCategory.Type)element).getName());
                } else if (cell.getColumnIndex() == 1) {
                    String attributes = this.getAttributes((ModeledElement)element);
                    cell.setText(attributes);
                    if (RequiredEstimatesEditor.this.fEstimateTypeMap.get(element) == null || ((RequiredEstimate)RequiredEstimatesEditor.this.fEstimateTypeMap.get(element)).getRequiredAttributes().isEmpty()) {
                        cell.setForeground(PlanningUIPlugin.getDefault().getMidShadow());
                        cell.getViewerRow().setForeground(0, PlanningUIPlugin.getDefault().getMidShadow());
                    } else {
                        cell.setForeground(null);
                        cell.getViewerRow().setForeground(0, null);
                    }
                }
            }

            private Image getImage(final Object element, String iconPath) {
                return AspectEditorUtil.getImage((IProcessContainerWorkingCopy)RequiredEstimatesEditor.this.getAspect().getProcessContainerWorkingCopy(), (String)iconPath, (ResourceManager)RequiredEstimatesEditor.this.fResourceManager, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.fireChanged(element);
                    }
                });
            }

            private void fireChanged(Object element) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
        });
        this.fPropertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (RequiredEstimatesEditor.this.fCategories != null) {
                    ArrayList types = new ArrayList();
                    for (TypeCategory category : RequiredEstimatesEditor.this.fCategories) {
                        types.addAll(category.getTypes());
                    }
                    return types.toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fPropertiesViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RequiredEstimatesEditor.this.editProperty((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Action edit = new Action(Messages.RequiredEstimatesEditor_EDIT){

            public void run() {
                RequiredEstimatesEditor.this.editProperty((IStructuredSelection)RequiredEstimatesEditor.this.fPropertiesViewer.getSelection());
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)edit){
            private final /* synthetic */ IAction val$edit;
            {
                this.val$edit = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                if (RequiredEstimatesEditor.this.fPropertiesViewer != null && ((IStructuredSelection)RequiredEstimatesEditor.this.fPropertiesViewer.getSelection()).size() == 1) {
                    manager.add(this.val$edit);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fPropertiesViewer.getControl());
        this.fPropertiesViewer.getControl().setMenu(menu);
        final Button editButton = toolkit.createButton(parent, Messages.RequiredEstimatesEditor_EDIT, 0x800000);
        GridData data = new GridData(0x1000000, 128, false, false);
        data.verticalIndent = this.fPropertiesViewer.getTable().getHeaderHeight();
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredEstimatesEditor.this.editProperty((IStructuredSelection)RequiredEstimatesEditor.this.fPropertiesViewer.getSelection());
            }
        });
        editButton.setEnabled(false);
        this.fPropertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!editButton.isDisposed()) {
                    editButton.setEnabled(((IStructuredSelection)RequiredEstimatesEditor.this.fPropertiesViewer.getSelection()).size() == 1);
                }
            }
        });
        this.fPropertiesViewer.setInput(this.fCategories);
    }

    private TypeCategory.Type createTypeInUnspecifiedCategory(String typeId) {
        if (this.fUnspecified == null) {
            this.fUnspecified = new TypeCategory(Messages.RequiredEstimatesEditor_8);
            this.fCategories.add(this.fUnspecified);
        }
        TypeCategory typeCategory = this.fUnspecified;
        typeCategory.getClass();
        TypeCategory.Type type = new TypeCategory.Type(typeCategory, typeId, typeId, null, null, new ArrayList());
        this.fUnspecified.addType(type);
        return type;
    }

    public void dispose() {
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    private void editProperty(IStructuredSelection selection) {
        ModeledElement element = (ModeledElement)selection.getFirstElement();
        TypeCategory.Type type = (TypeCategory.Type)element;
        TypeCategory category = type.getCategory();
        RequiredEstimate estimate = this.fEstimateTypeMap.get(element);
        EditEstimateDialog d = new EditEstimateDialog(Display.getCurrent().getActiveShell(), NLS.bind((String)Messages.RequiredEstimatesEditor_9, (Object)element.getName(), (Object[])new Object[0]), category, estimate, this.getBuiltInAttributes(), this.fResourceManager);
        if (d.open() == 0) {
            Collection<Attribute> selectedAttributes = d.getSelectedAttributes();
            if ((estimate == null || estimate.getRequiredAttributes().isEmpty()) && selectedAttributes.isEmpty()) {
                return;
            }
            if (estimate != null && estimate.getRequiredAttributes().containsAll(selectedAttributes) && selectedAttributes.containsAll(estimate.getRequiredAttributes())) {
                return;
            }
            if (estimate == null) {
                estimate = new RequiredEstimate(type);
                this.fRequiredEstimates.add(estimate);
                this.fEstimateTypeMap.put(element, estimate);
            }
            estimate.getRequiredAttributes().clear();
            estimate.getRequiredAttributes().addAll(selectedAttributes);
            this.setDirty();
            this.fPropertiesViewer.refresh();
        }
    }

    private TypeCategory.Type findType(String typeId) {
        if (this.fCategories == null || typeId == null) {
            return null;
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.Type t : cat.getTypes()) {
                if (!t.getId().equals(typeId)) continue;
                return t;
            }
        }
        return null;
    }

    private TypeCategory findTypeCategory(String typeCategoryId) {
        if (this.fCategories == null || typeCategoryId == null) {
            return null;
        }
        for (TypeCategory t : this.fCategories) {
            if (!typeCategoryId.equals(t.getIdentifier())) continue;
            return t;
        }
        return null;
    }

    private String getAttributeName(String attributeId) {
        for (Attribute a : this.getBuiltInAttributes()) {
            if (!a.getId().equals(attributeId)) continue;
            return a.getName();
        }
        for (TypeCategory cat : this.fCategories) {
            for (TypeCategory.CustomAttribute c : cat.getCustomAttributes()) {
                if (!c.getId().equals(attributeId)) continue;
                return c.getName();
            }
        }
        return attributeId;
    }

    private List<Attribute> getBuiltInAttributes() {
        if (this.fBuiltInAttributes == null) {
            final IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
            final ArrayList attributes = new ArrayList(4);
            if (processItem instanceof IProcessArea) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IProcessArea processArea = (IProcessArea)processItem;
                            ITeamRepository teamRepository = (ITeamRepository)processItem.getOrigin();
                            IWorkItemClient workitemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                            try {
                                List builtInAttributes = workitemClient.findBuiltInAttributes(processArea.getProjectArea(), monitor);
                                List resolved = workitemClient.getAuditableCommon().resolveAuditables(builtInAttributes, IAttribute.SMALL_PROFILE, monitor);
                                for (IAttribute attribute : resolved) {
                                    if (!"duration".equals(attribute.getAttributeType())) continue;
                                    attributes.add(attribute);
                                }
                            }
                            catch (TeamRepositoryException e) {
                                PlanningUIPlugin.log(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        PlanningUIPlugin.log(cause);
                    } else {
                        PlanningUIPlugin.log(e);
                    }
                    return Collections.emptyList();
                }
                catch (InterruptedException e) {
                    return Collections.emptyList();
                }
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                for (IAttribute a : attributes) {
                    if (a.isInternal()) continue;
                    Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)a.getIdentifier());
                    this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), a.getDisplayName()));
                }
            } else if (processItem instanceof IProcessDefinition) {
                this.fBuiltInAttributes = new ArrayList<Attribute>();
                AttributeDescriptor[] attributeDescriptorArray = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
                int n = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDescriptor desc = attributeDescriptorArray[n2];
                    if (!desc.isInternal()) {
                        Identifier ident = WorkItemAttributes.getPropertyIdentifier((String)desc.getIdentifier());
                        this.fBuiltInAttributes.add(new Attribute(ident.getStringIdentifier(), desc.getDisplayName()));
                    }
                    ++n2;
                }
            } else {
                throw new UnsupportedOperationException("Neither an IProcessArea nor a IProcessDefinition");
            }
        }
        return this.fBuiltInAttributes;
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.readCategories();
    }

    private void readCategories() {
        ModelElement typeElement = this.getSite().getConfigurationData("com.ibm.team.workitem.configuration.workItemTypes");
        this.fCategories = TypeManager.readTypeCategories((ModelElement)typeElement);
    }

    public void restoreState(IMemento memento) {
        this.fRequiredEstimates = new ArrayList<RequiredEstimate>();
        this.fEstimateTypeMap = new HashMap<ModeledElement, RequiredEstimate>();
        IMemento[] iMementoArray = memento.getChildren(PROPERTIES);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento properties = iMementoArray[n2];
            String typeCategory = properties.getString(WORKITEMTYPECATEGORY);
            String type = properties.getString(WORKITEMTYPE);
            Collection<TypeCategory.Type> types = this.getTypes(typeCategory, type);
            for (TypeCategory.Type tp : types) {
                RequiredEstimate prop = this.fEstimateTypeMap.get(tp);
                if (prop == null) {
                    prop = new RequiredEstimate(tp);
                    this.fEstimateTypeMap.put((ModeledElement)tp, prop);
                }
                IMemento[] iMementoArray2 = properties.getChildren(PROPERTY);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento property = iMementoArray2[n4];
                    String id = property.getString(ID);
                    if (id != null) {
                        prop.addRequiredAttribute(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier(), this.getAttributeName(WorkItemAttributes.getPropertyIdentifier((String)id).getStringIdentifier())));
                    }
                    ++n4;
                }
                this.fRequiredEstimates.add(prop);
            }
            ++n2;
        }
    }

    private Collection<TypeCategory.Type> getTypes(String typeCategory, String typeId) {
        if (typeCategory == null && typeId == null) {
            ArrayList<TypeCategory.Type> types = new ArrayList<TypeCategory.Type>();
            for (TypeCategory cat : this.fCategories) {
                types.addAll(cat.getTypes());
            }
            return types;
        }
        if (typeCategory != null) {
            TypeCategory typeOrCategory = this.findOrCreateTypeCategory(typeCategory);
            return typeOrCategory.getTypes();
        }
        TypeCategory.Type tp = this.findType(typeId);
        if (tp == null) {
            tp = this.createTypeInUnspecifiedCategory(typeId);
        }
        return Collections.singleton(tp);
    }

    private TypeCategory findOrCreateTypeCategory(String typeCategoryId) {
        if (this.fCategories == null || typeCategoryId == null) {
            return null;
        }
        for (TypeCategory t : this.fCategories) {
            if (!typeCategoryId.equals(t.getIdentifier())) continue;
            return t;
        }
        TypeCategory typeCategory = new TypeCategory(typeCategoryId);
        this.fCategories.add(typeCategory);
        return typeCategory;
    }

    public boolean saveState(IMemento memento) {
        if (this.fRequiredEstimates.size() == 0) {
            return false;
        }
        for (RequiredEstimate prop : this.fRequiredEstimates) {
            IMemento properties = memento.createChild(PROPERTIES);
            properties.putString(WORKITEMTYPE, prop.getType().getIdentifier());
            for (Attribute a : prop.getRequiredAttributes()) {
                IMemento attr = properties.createChild(PROPERTY);
                attr.putString(ID, a.getId());
            }
        }
        return true;
    }

    private static final class Attribute {
        private final String fId;
        private final String fName;

        public Attribute(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public boolean equals(Object o) {
            if (o instanceof Attribute) {
                return ((Attribute)o).fId.equals(this.fId);
            }
            return super.equals(o);
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public int hashCode() {
            return this.fId.hashCode();
        }
    }

    private static final class EditEstimateDialog
    extends ProcessAttachmentIconSelectionDialog {
        private final List<Attribute> fAllAttributes;
        private CheckboxTableViewer fAttributeViewer;
        private final RequiredEstimate fEstimate;
        private final Set<Attribute> fRequired;

        public EditEstimateDialog(Shell parentShell, String title, TypeCategory category, RequiredEstimate estimate, List<Attribute> builtInAttributes, ResourceManager resourceManager) {
            super(parentShell, title, null, null, resourceManager);
            this.fEstimate = estimate;
            HashSet<Attribute> attributes = new HashSet<Attribute>(builtInAttributes);
            for (TypeCategory.CustomAttribute attr : category.getCustomAttributes()) {
                if (!"duration".equals(attr.getAttributeType())) continue;
                attributes.add(new Attribute(WorkItemAttributes.getPropertyIdentifier((String)attr.getId()).getStringIdentifier(), attr.getName()));
            }
            this.fAllAttributes = new ArrayList<Attribute>(attributes);
            Collections.sort(this.fAllAttributes, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute o1, Attribute o2) {
                    String name1 = o1.getName() != null ? o1.getName() : o1.getId();
                    String name2 = o2.getName() != null ? o2.getName() : o2.getId();
                    return name1.compareToIgnoreCase(name2);
                }
            });
            this.fRequired = this.fEstimate != null ? new HashSet<Attribute>(this.fEstimate.getRequiredAttributes()) : new HashSet();
        }

        protected void createIconDialogPart(Composite parent) {
        }

        protected void createUpperDialogPart(Composite parent) {
            Label l = new Label(parent, 0);
            l.setText(Messages.RequiredEstimatesEditor_SELECT_REQUIRED_ESTIMATES);
            GridData data = new GridData(4, 4, true, false, 2, 1);
            l.setLayoutData((Object)data);
            Table t = new Table(parent, 67616);
            data = new GridData(4, 4, true, true, 2, 1);
            data.verticalIndent = 5;
            t.setLayoutData((Object)data);
            TableColumn c = new TableColumn(t, 0);
            c.setWidth(300);
            this.fAttributeViewer = new CheckboxTableViewer(t);
            this.fAttributeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    if (cell.getElement() instanceof Attribute) {
                        cell.setText(((Attribute)cell.getElement()).getName());
                        cell.setForeground(null);
                    } else {
                        cell.setText(null);
                    }
                }
            });
            this.fAttributeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return fAllAttributes.toArray();
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.fAttributeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        fRequired.add((Attribute)event.getElement());
                    } else {
                        fRequired.remove(event.getElement());
                    }
                    fAttributeViewer.refresh();
                }
            });
            this.fAttributeViewer.setInput(this.fAllAttributes);
            this.fAttributeViewer.setCheckedElements(this.fRequired.toArray());
        }

        protected Collection<Attribute> getSelectedAttributes() {
            return this.fRequired;
        }

        protected void iconChanged() {
            this.validate();
        }
    }

    private static class RequiredEstimate {
        private final List<Attribute> fRequiredAttributes;
        private final TypeCategory.Type fType;

        public RequiredEstimate(TypeCategory.Type type) {
            this.fType = type;
            this.fRequiredAttributes = new ArrayList<Attribute>();
        }

        public void addRequiredAttribute(Attribute attribute) {
            this.fRequiredAttributes.add(attribute);
        }

        public List<Attribute> getRequiredAttributes() {
            return this.fRequiredAttributes;
        }

        public TypeCategory.Type getType() {
            return this.fType;
        }
    }
}

