/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.apt.internal.common.util.SerializeHelper;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.AbstractPlanAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.ConfigurationDescriptorLabelProvider;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlanAttributesAspectEditor
extends AbstractPlanAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.attributes";
    private static final String ID_ATTR_RANKING = "com.ibm.team.apt.attribute.planitem.ranking";
    private static final String ID_ATTR_COMPLEXITY = "com.ibm.team.apt.attribute.planitem.complexity";
    private static final String KEY_ABBR = "abbreviation";
    private static final String KEY_LBL = "label";
    private static final String KEY_ATTR = "attribute";
    private IComplexityAttribute fComplexityAttribute;
    private IAttributeDefinitionDescriptor fComplexityAttribute2;
    private IAttributeDefinitionDescriptor fRankingAttribute;
    private final Set<IAttributeDefinitionDescriptor> fAttributes = new HashSet<IAttributeDefinitionDescriptor>();
    private final Set<IAttributeDefinitionDescriptor> fProcessSpecAttributes = new HashSet<IAttributeDefinitionDescriptor>();
    private Composite fParent;
    private LocalResourceManager fResources;
    private ControlEnableState fUIState;
    private ComboViewer fCmbComplexity;
    private Text fTxtComplexity;
    private ControlDecoration fLabelDecoration;
    private Image fInfoImage;
    private ComboViewer fCmbRanking;
    private TableViewer fAllAttributesViewer;

    @Override
    protected void doInit(ProcessAspect aspect, boolean isRevert) {
        this.fAttributes.clear();
        this.fProcessSpecAttributes.clear();
        ModelElement element = aspect.getConfigurationElement();
        if (element != null) {
            INode node = INode.FACTORY.createNode((Object)element, null);
            this.fComplexityAttribute = (IComplexityAttribute)ConfigurationElementFactory.singleInstance(IComplexityAttribute.class, (INode)node);
            this.fProcessSpecAttributes.addAll(ConfigurationElementFactory.allInstances(IAttributeDefinitionDescriptor.class, (INode)node));
        }
        if (this.fComplexityAttribute == null) {
            this.fComplexityAttribute = (IComplexityAttribute)ConfigurationElementFactory.emptyInstance(IComplexityAttribute.class);
        }
        new ResolveJob().schedule();
    }

    @Override
    public void doCreateControl(Composite parent, FormToolkit toolkit) {
        this.fParent = parent;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        GridLayoutFactory.fillDefaults().applyTo(this.fParent);
        Composite composite = this.createComplexityAttrSection(this.fParent, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite = this.createRankingSection(this.fParent, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite = this.createAttributesSection(this.fParent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        UI.hookHelpListener((Control)this.fParent, "com.ibm.team.apt.ide.ui.aspect_plan_attributes");
        this.update();
    }

    protected Composite createComplexityAttrSection(Composite parent, final FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 448);
        section.setText(Messages.ComplexityAttributeAspectEditor_COMPLEXITY_TITLE);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(false).applyTo(composite);
        section.setClient((Control)composite);
        GC gc = new GC((Drawable)parent);
        int width = -1;
        try {
            gc.setFont(parent.getFont());
            width = gc.getFontMetrics().getAverageCharWidth();
        }
        finally {
            gc.dispose();
        }
        this.fCmbComplexity = this.createAttributeCombo(composite, toolkit);
        this.fCmbComplexity.setFilters(new ViewerFilter[]{new AttributeTypeFilter(EnumSet.of(PlanningAttributeType.INTEGER, PlanningAttributeType.ENUMERATION, PlanningAttributeType.DURATION)), new WorkItemAttributeFilter(), new AttributeIdFilter(new String[]{ID_ATTR_COMPLEXITY})});
        this.fCmbComplexity.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object element = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (element instanceof IAttributeDefinitionDescriptor) {
                    IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
                    String oldIdentifier = PlanAttributesAspectEditor.this.fComplexityAttribute.setAttributeId(attribute.getId());
                    PlanAttributesAspectEditor.this.fComplexityAttribute.setDisplayName(attribute.getDisplayName());
                    if ("DURATION".equals(attribute.getType().getIdentifier())) {
                        PlanAttributesAspectEditor.this.fComplexityAttribute.setType(attribute.getType().getIdentifier());
                        PlanAttributesAspectEditor.this.fComplexityAttribute.setUnit(DurationFormat.Units.Hours.name());
                    } else {
                        PlanAttributesAspectEditor.this.fComplexityAttribute.setType(null);
                        PlanAttributesAspectEditor.this.fComplexityAttribute.setUnit(null);
                    }
                    PlanAttributesAspectEditor.this.fComplexityAttribute2.setType(attribute.getType());
                    PlanAttributesAspectEditor.this.fComplexityAttribute2.setParameters(IParameter.FACTORY.appendOrOverwrite(PlanAttributesAspectEditor.this.fComplexityAttribute2.getParameters(), IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_ATTR, attribute.getId())));
                    PlanAttributesAspectEditor.this.fComplexityAttribute2.setParameters(IParameter.FACTORY.appendOrOverwrite(PlanAttributesAspectEditor.this.fComplexityAttribute2.getParameters(), IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_LBL, attribute.getDisplayName())));
                    if (oldIdentifier == null || !oldIdentifier.equals(attribute.getId()) && PlanAttributesAspectEditor.this.fComplexityAttribute.getDisplayName() != null) {
                        PlanAttributesAspectEditor.this.fTxtComplexity.setText(attribute.getDisplayName());
                        PlanAttributesAspectEditor.this.setDirty(true);
                    } else {
                        PlanAttributesAspectEditor.this.fTxtComplexity.setText(PlanAttributesAspectEditor.this.fComplexityAttribute.getShortDisplayName());
                    }
                    PlanAttributesAspectEditor.this.fTxtComplexity.selectAll();
                }
            }
        });
        Label label = toolkit.createLabel(composite, Messages.ComplexityAttributeAspectEditor_LABEL_ABBR);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        this.fInfoImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        this.fTxtComplexity = toolkit.createText(composite, "");
        GridDataFactory.swtDefaults().hint(width * 15, -1).indent(this.fInfoImage.getBounds().width, 0).applyTo((Control)this.fTxtComplexity);
        this.fLabelDecoration = new ControlDecoration((Control)this.fTxtComplexity, 0x1004000);
        this.fLabelDecoration.setImage(this.fInfoImage);
        this.fLabelDecoration.hide();
        this.fTxtComplexity.addModifyListener(new ModifyListener(){
            private boolean disable = false;

            public void modifyText(ModifyEvent e) {
                if (this.disable) {
                    return;
                }
                String value = PlanAttributesAspectEditor.this.fTxtComplexity.getText().trim();
                String oldValue = PlanAttributesAspectEditor.this.fComplexityAttribute.setShortDisplayName(value);
                PlanAttributesAspectEditor.this.fComplexityAttribute2.setParameters(IParameter.FACTORY.appendOrOverwrite(PlanAttributesAspectEditor.this.fComplexityAttribute2.getParameters(), IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_ABBR, value)));
                if (value.length() == 0) {
                    IAttributeDefinitionDescriptor attribute = PlanAttributesAspectEditor.this.findAttributeWithId(PlanAttributesAspectEditor.this.fComplexityAttribute.getAttributeId());
                    if (attribute != null) {
                        this.disable = true;
                        PlanAttributesAspectEditor.this.fComplexityAttribute.setShortDisplayName(attribute.getDisplayName());
                        PlanAttributesAspectEditor.this.fComplexityAttribute2.setParameters(IParameter.FACTORY.appendOrOverwrite(PlanAttributesAspectEditor.this.fComplexityAttribute2.getParameters(), IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_ABBR, attribute.getDisplayName())));
                        try {
                            PlanAttributesAspectEditor.this.fTxtComplexity.setForeground(PlanningUIPlugin.getDefault().getMidShadow());
                            PlanAttributesAspectEditor.this.fTxtComplexity.setText(attribute.getDisplayName());
                            PlanAttributesAspectEditor.this.fTxtComplexity.setSelection(0);
                            Listener listener = new Listener(){

                                public void handleEvent(Event event) {
                                    PlanAttributesAspectEditor.this.fTxtComplexity.removeListener(1, (Listener)this);
                                    PlanAttributesAspectEditor.this.fTxtComplexity.removeListener(3, (Listener)this);
                                    disable = true;
                                    try {
                                        PlanAttributesAspectEditor.this.fTxtComplexity.setForeground(toolkit.getColors().getForeground());
                                        PlanAttributesAspectEditor.this.fTxtComplexity.setText("");
                                    }
                                    finally {
                                        disable = false;
                                    }
                                }
                            };
                            PlanAttributesAspectEditor.this.fTxtComplexity.addListener(1, listener);
                            PlanAttributesAspectEditor.this.fTxtComplexity.addListener(3, listener);
                        }
                        finally {
                            this.disable = false;
                        }
                    }
                } else if (value.length() > 8) {
                    PlanAttributesAspectEditor.this.fLabelDecoration.setDescriptionText(Messages.ComplexityAttributeAspectEditor_MSG_HINT_SHORT_LABEL);
                    PlanAttributesAspectEditor.this.fLabelDecoration.show();
                } else {
                    PlanAttributesAspectEditor.this.fLabelDecoration.hide();
                }
                PlanAttributesAspectEditor.this.setDirty(oldValue == null || !oldValue.equals(value));
            }
        });
        return section;
    }

    protected Composite createRankingSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 448);
        section.setText(Messages.ComplexityAttributeAspectEditor_RANKING_TITLE);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        section.setClient((Control)composite);
        this.fCmbRanking = this.createAttributeCombo(composite, toolkit);
        this.fCmbRanking.setFilters(new ViewerFilter[]{new AttributeTypeFilter(EnumSet.of(PlanningAttributeType.ENUMERATION)), new WorkItemAttributeFilter(), new ComplexityAttributeFilter()});
        this.fCmbRanking.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)selection.getFirstElement();
                if (PlanAttributesAspectEditor.this.fRankingAttribute != null && IParameter.FACTORY.findFirst(PlanAttributesAspectEditor.KEY_ATTR, PlanAttributesAspectEditor.this.fRankingAttribute.getParameters()).getValue().equals(attribute.getId())) {
                    return;
                }
                PlanAttributesAspectEditor.this.fRankingAttribute = (IAttributeDefinitionDescriptor)ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
                PlanAttributesAspectEditor.this.fRankingAttribute.setId(PlanAttributesAspectEditor.ID_ATTR_RANKING);
                PlanAttributesAspectEditor.this.fRankingAttribute.setImplementationName("com.ibm.team.apt.shared.client.RankingAttribute");
                PlanAttributesAspectEditor.this.fRankingAttribute.setType(PlanningAttributeType.RANKING);
                IParameter parameter = IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_ATTR, attribute.getId());
                PlanAttributesAspectEditor.this.fRankingAttribute.setParameters(new IParameter[]{parameter});
                PlanAttributesAspectEditor.this.fProcessSpecAttributes.remove(PlanAttributesAspectEditor.this.fRankingAttribute);
                PlanAttributesAspectEditor.this.fProcessSpecAttributes.add(PlanAttributesAspectEditor.this.fRankingAttribute);
                PlanAttributesAspectEditor.this.setDirty(true);
            }
        });
        return section;
    }

    protected ComboViewer createAttributeCombo(Composite parent, FormToolkit toolkit) {
        toolkit.createLabel(parent, Messages.ComplexityAttributeAspectEditor_LABEL_ATTR);
        GC gc = new GC((Drawable)parent);
        int width = -1;
        try {
            gc.setFont(parent.getFont());
            width = gc.getFontMetrics().getAverageCharWidth();
        }
        finally {
            gc.dispose();
        }
        ComboViewer viewer = new ComboViewer(parent, 12);
        GridDataFactory.fillDefaults().hint(width * 25, -1).applyTo(viewer.getControl());
        toolkit.adapt((Composite)viewer.getControl());
        viewer.setContentProvider((IContentProvider)new AbstractPlanAspectEditor.DeferredContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof Action) {
                    return ((Action)element).getText();
                }
                return super.getText(element);
            }
        });
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof Action) {
                    return 1;
                }
                if (o2 instanceof Action) {
                    return -1;
                }
                return super.compare(viewer, o1, o2);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object element = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (element instanceof Action) {
                    ((Action)element).run();
                }
            }
        });
        return viewer;
    }

    protected Composite createAttributesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 258);
        section.setText(Messages.ComplexityAttributeAspectEditor_ATTR_MAPPING_TITLE);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        section.setClient((Control)composite);
        GC gc = new GC((Drawable)parent);
        int height = -1;
        try {
            gc.setFont(parent.getFont());
            height = gc.getFontMetrics().getHeight();
        }
        finally {
            gc.dispose();
        }
        this.fAllAttributesViewer = new TableViewer(composite, 2562);
        Table table = this.fAllAttributesViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        toolkit.adapt(this.fAllAttributesViewer.getControl(), true, true);
        GridDataFactory.fillDefaults().hint(-1, 8 * height).applyTo(this.fAllAttributesViewer.getControl());
        this.fAllAttributesViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof IAttributeDefinitionDescriptor) {
                    IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
                    Identifier identifier = PlanItemAttributes.getAttributeId((IAttributeDefinitionDescriptor)attribute);
                    return NLS.bind((String)Messages.ComplexityAttributeAspectEditor_ATTR_MAPPING_LABEL, (Object)super.getText(element), (Object[])new Object[]{identifier.getStringIdentifier()});
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IAttributeDefinitionDescriptor) {
                    IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
                    return PlanAttributesAspectEditor.this.fResources.createImage(PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attribute) ? ImagePool.ATTR_CUSTOM : ImagePool.ATTR_BUILT_IN);
                }
                return super.getImage(element);
            }
        });
        this.fAllAttributesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fAllAttributesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IAttributeDefinitionDescriptor attr1 = (IAttributeDefinitionDescriptor)e1;
                IAttributeDefinitionDescriptor attr2 = (IAttributeDefinitionDescriptor)e2;
                if (PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attr1) ^ PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attr2)) {
                    return PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attr1) ? -1 : 1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fAllAttributesViewer.setFilters(new ViewerFilter[]{new WorkItemAttributeFilter()});
        Composite toolbar = toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(false, true).applyTo((Control)toolbar);
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo(toolbar);
        Button btn = this.createBtn(toolbar, toolkit, new AddAttributeAction());
        GridDataFactory.fillDefaults().applyTo((Control)btn);
        btn = this.createBtn(toolbar, toolkit, new RemoveAttributeAction());
        GridDataFactory.fillDefaults().applyTo((Control)btn);
        return section;
    }

    protected Button createBtn(Composite parent, FormToolkit toolkit, final Action action) {
        final Button btn = toolkit.createButton(parent, action.getText(), 8);
        btn.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Action action = (Action)event.getSource();
                btn.setText(action.getText());
                btn.setEnabled(action.isEnabled());
            }
        });
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        return btn;
    }

    @Override
    protected void update() {
        if (this.fParent == null) {
            return;
        }
        UI.syncExec((Control)this.fParent, new Runnable(){

            @Override
            public void run() {
                IAttributeDefinitionDescriptor selected;
                if (PlanAttributesAspectEditor.this.isBusy() && PlanAttributesAspectEditor.this.fUIState == null) {
                    PlanAttributesAspectEditor.this.fCmbComplexity.setInput((Object)new Object[]{Messages.ComplexityAttributeAspectEditor_MONITOR_PEDNING});
                    PlanAttributesAspectEditor.this.fCmbComplexity.setSelection((ISelection)new StructuredSelection(PlanAttributesAspectEditor.this.fCmbComplexity.getElementAt(0)), true);
                    PlanAttributesAspectEditor.this.fUIState = ControlEnableState.disable((Control)PlanAttributesAspectEditor.this.fParent);
                } else if (PlanAttributesAspectEditor.this.fUIState != null) {
                    PlanAttributesAspectEditor.this.fUIState.restore();
                    PlanAttributesAspectEditor.this.fUIState = null;
                }
                if (PlanAttributesAspectEditor.this.fAttributes.isEmpty()) {
                    return;
                }
                HashSet<MoreAttributesAction> input = new HashSet<MoreAttributesAction>();
                input.addAll(PlanAttributesAspectEditor.this.fAttributes);
                if (PlanAttributesAspectEditor.this.isInitializedProjectArea(PlanAttributesAspectEditor.this.getProjectArea())) {
                    input.add(new MoreAttributesAction());
                }
                PlanAttributesAspectEditor.this.fCmbComplexity.setInput(input);
                if (PlanAttributesAspectEditor.this.fComplexityAttribute != null && (selected = PlanAttributesAspectEditor.this.findAttributeWithId(PlanAttributesAspectEditor.this.fComplexityAttribute.getAttributeId())) != null) {
                    PlanAttributesAspectEditor.this.fCmbComplexity.setSelection((ISelection)new StructuredSelection((Object)selected), true);
                }
                PlanAttributesAspectEditor.this.fCmbRanking.setInput((Object)PlanAttributesAspectEditor.this.fAttributes);
                if (PlanAttributesAspectEditor.this.fRankingAttribute != null) {
                    IAttributeDefinitionDescriptor selected2;
                    IParameter attribute = IParameter.FACTORY.findFirst(PlanAttributesAspectEditor.KEY_ATTR, PlanAttributesAspectEditor.this.fRankingAttribute.getParameters());
                    IAttributeDefinitionDescriptor iAttributeDefinitionDescriptor = selected2 = attribute != null ? PlanAttributesAspectEditor.this.findAttributeWithId(attribute.getValue()) : null;
                    if (selected2 != null) {
                        PlanAttributesAspectEditor.this.fCmbRanking.setSelection((ISelection)new StructuredSelection((Object)selected2), true);
                    }
                }
                PlanAttributesAspectEditor.this.fAllAttributesViewer.setInput((Object)PlanAttributesAspectEditor.this.fAttributes);
            }
        });
    }

    private IAttributeDefinitionDescriptor findAttributeWithId(String id) {
        for (IAttributeDefinitionDescriptor attribute : this.fAttributes) {
            if (!attribute.getId().equals(id)) continue;
            return attribute;
        }
        return null;
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        memento.putString("xmlns", this.getAspect().getSchemaNamespaceURI());
        boolean update = false;
        if (this.fComplexityAttribute.getAttributeId() != null && this.fComplexityAttribute.getDisplayName() != null) {
            update = true;
            ConfigurationElementFactory.serializeIntoRoot((Object)this.fComplexityAttribute, (IMemento)memento);
            if (this.fProcessSpecAttributes.contains(this.fComplexityAttribute2)) {
                this.fProcessSpecAttributes.remove(this.fComplexityAttribute2);
            }
            this.fProcessSpecAttributes.add(this.fComplexityAttribute2);
        }
        boolean bl = !this.fProcessSpecAttributes.isEmpty();
        this.saveSate(memento, this.fProcessSpecAttributes);
        return update |= bl;
    }

    private static boolean isExistingAttribute(Set<IAttributeDefinitionDescriptor> attributeSet, IAttribute attribute) {
        for (IAttributeDefinitionDescriptor desc : attributeSet) {
            Identifier id = PlanItemAttributes.getAttributeId((IAttributeDefinitionDescriptor)desc);
            if (id == null || !id.getStringIdentifier().equals(attribute.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private boolean isInitializedProjectArea(IProjectAreaHandle projectAreaHandle) {
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
        IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)projectAreaHandle);
        return projectArea != null && projectArea.isInitialized();
    }

    private class AddAttributeAction
    extends WorkItemAttributeAction {
        private static final String MSP_TASK_INFO = "mspTaskInfo";

        public AddAttributeAction() {
            super(Messages.ComplexityAttributeAspectEditor_ADD_LABEL, new IFilter<IAttribute>(){

                public boolean accept(IAttribute element) {
                    if (element.getIdentifier().contains("_pm7NmRYUEd6L1tNIGdz5qQ")) {
                        return false;
                    }
                    if (element.getIdentifier().equals(AddAttributeAction.MSP_TASK_INFO)) {
                        return false;
                    }
                    if (PlanAttributesAspectEditor.isExistingAttribute(PlanAttributesAspectEditor.this.fProcessSpecAttributes, element) || PlanAttributesAspectEditor.isExistingAttribute(PlanAttributesAspectEditor.this.fAttributes, element)) {
                        return false;
                    }
                    try {
                        SerializeHelper.getAttributeType((IAttribute)element);
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                    return !element.isBuiltIn();
                }
            });
        }

        public void run() {
            IAttribute attribute = this.selectAttribute(Messages.ComplexityAttributeAspectEditor_ATTR_MAPPING_TITLE, Messages.ComplexityAttributeAspectEditor_LABEL_ATTR);
            if (attribute == null) {
                return;
            }
            IAttributeDefinitionDescriptor planAttribute = this.createProxy(attribute);
            PlanAttributesAspectEditor.this.fAttributes.add(planAttribute);
            PlanAttributesAspectEditor.this.fProcessSpecAttributes.add(planAttribute);
            PlanAttributesAspectEditor.this.update();
            PlanAttributesAspectEditor.this.setDirty(true);
        }
    }

    private class AttributeIdFilter
    extends ViewerFilter {
        private final Set<String> fAttributes = new HashSet<String>();

        public AttributeIdFilter(String[] attributes) {
            String[] stringArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                this.fAttributes.add(attribute);
                ++n2;
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IAttributeDefinitionDescriptor)) {
                return true;
            }
            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
            return !this.fAttributes.contains(attribute.getId());
        }
    }

    private class AttributeTypeFilter
    extends ViewerFilter {
        private final Collection<PlanningAttributeType> fTypes;

        public AttributeTypeFilter(Collection<PlanningAttributeType> types) {
            this.fTypes = types;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fTypes.isEmpty()) {
                return true;
            }
            if (!(element instanceof IAttributeDefinitionDescriptor)) {
                return true;
            }
            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
            return attribute.getType() != null && this.fTypes.contains(attribute.getType());
        }
    }

    private class ComplexityAttributeFilter
    extends ViewerFilter {
        private ComplexityAttributeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (PlanAttributesAspectEditor.this.fComplexityAttribute2 == null) {
                return true;
            }
            if (!(element instanceof IAttributeDefinitionDescriptor)) {
                return true;
            }
            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
            return !attribute.getImplementationName().equals(PlanAttributesAspectEditor.this.fComplexityAttribute2.getImplementationName());
        }
    }

    private class MoreAttributesAction
    extends WorkItemAttributeAction {
        public MoreAttributesAction() {
            super(Messages.ComplexityAttributeAspectEditor_LABEL_MORE_ACTION, new IFilter<IAttribute>(){

                public boolean accept(IAttribute element) {
                    if (element.isBuiltIn()) {
                        return false;
                    }
                    if (AttributeTypes.isEnumerationAttributeType((String)element.getAttributeType())) {
                        return true;
                    }
                    if ("integer".equals(element.getAttributeType())) {
                        return true;
                    }
                    if ("long".equals(element.getAttributeType())) {
                        return true;
                    }
                    return "duration".equals(element.getAttributeType());
                }
            });
        }

        public void run() {
            IAttribute result = this.selectAttribute(Messages.ComplexityAttributeAspectEditor_ATTR_DIALOG_TITLE, Messages.ComplexityAttributeAspectEditor_ATTR_DIALOG_MSG);
            if (result != null) {
                IAttributeDefinitionDescriptor planAttribute = this.createProxy(result);
                PlanAttributesAspectEditor.this.fAttributes.add(planAttribute);
                PlanAttributesAspectEditor.this.fProcessSpecAttributes.add(planAttribute);
                PlanAttributesAspectEditor.this.update();
                PlanAttributesAspectEditor.this.fCmbComplexity.setSelection((ISelection)new StructuredSelection((Object)planAttribute), true);
                PlanAttributesAspectEditor.this.setDirty(true);
            } else {
                IAttributeDefinitionDescriptor attribute = PlanAttributesAspectEditor.this.findAttributeWithId(PlanAttributesAspectEditor.this.fComplexityAttribute.getAttributeId());
                if (attribute != null) {
                    PlanAttributesAspectEditor.this.fCmbComplexity.setSelection((ISelection)new StructuredSelection((Object)attribute), true);
                } else {
                    PlanAttributesAspectEditor.this.fCmbComplexity.setSelection((ISelection)new StructuredSelection(PlanAttributesAspectEditor.this.fCmbComplexity.getElementAt(0)), true);
                }
            }
        }
    }

    private class RemoveAttributeAction
    extends Action {
        public RemoveAttributeAction() {
            this.setText(Messages.ComplexityAttributeAspectEditor_REMOVE_LABEL);
            PlanAttributesAspectEditor.this.fAllAttributesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    boolean enabled = !selection.isEmpty();
                    Iterator iter = selection.iterator();
                    while (enabled && iter.hasNext()) {
                        IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)iter.next();
                        enabled &= PlanItemAttributes.isWorkItemProxied((IAttributeDefinitionDescriptor)attribute);
                    }
                    RemoveAttributeAction.this.setEnabled(enabled);
                }
            });
        }

        public void run() {
            String message;
            final IStructuredSelection selection = (IStructuredSelection)PlanAttributesAspectEditor.this.fAllAttributesViewer.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            List attributes = selection.toList();
            String string = message = attributes.size() != 1 ? NLS.bind((String)Messages.ComplexityAttributeAspectEditor_REMOVE_CONFIRM_MANY, (Object)attributes.size(), (Object[])new Object[0]) : NLS.bind((String)Messages.ComplexityAttributeAspectEditor_REMOVE_CONFIRM_ONE, (Object)((IAttributeDefinitionDescriptor)attributes.get(0)).getDisplayName(), (Object[])new Object[0]);
            if (!MessageDialog.openConfirm((Shell)PlanAttributesAspectEditor.this.fParent.getShell(), (String)Messages.ComplexityAttributeAspectEditor_REMOVE_CONFIRM_TITLE, (String)message)) {
                return;
            }
            final ArrayList<String> attributeIdentifiers = new ArrayList<String>();
            for (IAttributeDefinitionDescriptor attribute : selection) {
                attributeIdentifiers.add(attribute.getId());
            }
            TeamRunnable runnable = new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    int index;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                    IProjectAreaHandle projectArea = PlanAttributesAspectEditor.this.getProjectArea();
                    IIterationPlanClient planClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectArea);
                    IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea).getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
                    final MultiStatus status = new MultiStatus(PlanningClientPlugin.getPluginId(), 0, "", null);
                    int n = index = PlanAttributesAspectEditor.this.fComplexityAttribute != null ? attributeIdentifiers.indexOf(PlanAttributesAspectEditor.this.fComplexityAttribute.getAttributeId()) : -1;
                    if (index != -1) {
                        status.add((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.ComplexityAttributeAspectEditor_REMOVE_ERR_COMPLEXITY, attributeIdentifiers.get(index), (Object[])new Object[0]), null));
                    }
                    List<Class> dependencies = Arrays.asList(IAttributeDefinitionDescriptor.class, IViewModeDescription.class, IGroupModeDescription.class, ISortModeDescription.class, IFilterDescription.class);
                    progress.beginTask(Messages.ComplexityAttributeAspectEditor_REMOVE_MONITOR, dependencies.size());
                    ArrayList planConfigElements = new ArrayList();
                    for (Class type : dependencies) {
                        planConfigElements.addAll(planClient.findConfigurationElements(type, process, (IProgressMonitor)progress.newChild(1)));
                    }
                    for (IPlanConfigurationElement element : planConfigElements) {
                        IParameter param = IParameter.FACTORY.findFirst(PlanAttributesAspectEditor.KEY_ATTR, element.getParameters());
                        int n2 = index = param == null ? -1 : attributeIdentifiers.indexOf(param.getValue());
                        if (index == -1) continue;
                        status.add((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.ComplexityAttributeAspectEditor_REMOVE_ERR_ELEMENT, attributeIdentifiers.get(index), (Object[])new Object[]{element.getDisplayName()}), null));
                    }
                    UI.asyncExec((Control)PlanAttributesAspectEditor.this.fParent, new Runnable(){

                        @Override
                        public void run() {
                            if (!status.isOK()) {
                                MultiStatus displayStatus = status;
                                if (status.getChildren().length == 1) {
                                    displayStatus = status.getChildren()[0];
                                }
                                ErrorDialog.openError((Shell)PlanAttributesAspectEditor.this.fParent.getShell(), (String)Messages.ComplexityAttributeAspectEditor_ATTR_DIALOG_TITLE, (String)Messages.ComplexityAttributeAspectEditor_REMOVE_ERR_MSG, (IStatus)displayStatus);
                            } else {
                                List removals = selection.toList();
                                PlanAttributesAspectEditor.this.fProcessSpecAttributes.removeAll(removals);
                                PlanAttributesAspectEditor.this.fAttributes.removeAll(removals);
                                PlanAttributesAspectEditor.this.update();
                                PlanAttributesAspectEditor.this.setDirty(true);
                            }
                        }
                    });
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ResolveJob
    extends AbstractPlanAspectEditor.PlanAspectJob {
        private ResolveJob() {
            super(PlanAttributesAspectEditor.this);
        }

        @Override
        protected IStatus runBusy(IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.beginTask(Messages.ComplexityAttributeAspectEditor_MONITOR_RESOLVING_ATTRS, 5);
            PlanAttributesAspectEditor.this.fComplexityAttribute2 = PlanAttributesAspectEditor.this.findConfigurationElements(IAttributeDefinitionDescriptor.class, PlanAttributesAspectEditor.ID_ATTR_COMPLEXITY, (IProgressMonitor)progress.newChild(1));
            PlanAttributesAspectEditor.this.fRankingAttribute = PlanAttributesAspectEditor.this.findConfigurationElements(IAttributeDefinitionDescriptor.class, PlanAttributesAspectEditor.ID_ATTR_RANKING, (IProgressMonitor)progress.newChild(1));
            IProjectAreaHandle projectArea = PlanAttributesAspectEditor.this.getProjectArea();
            IIterationPlanClient planClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectArea);
            IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea).getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
            List descriptors = planClient.findConfigurationElements(IAttributeDefinitionDescriptor.class, process, (IProgressMonitor)progress.newChild(1));
            Iterator iter = descriptors.iterator();
            PlanAttributesAspectEditor.this.fAttributes.addAll(descriptors);
            return Status.OK_STATUS;
        }
    }

    private abstract class WorkItemAttributeAction
    extends Action {
        private final IFilter<IAttribute> fFilter;

        public WorkItemAttributeAction(String text, IFilter<IAttribute> filter) {
            this.setText(text);
            this.fFilter = filter;
        }

        protected IAttribute selectAttribute(String title, String message) {
            return WorkItemAttributesDialog.openDialog(PlanAttributesAspectEditor.this.getProjectArea(), PlanAttributesAspectEditor.this.fParent.getShell(), title, message, this.fFilter);
        }

        protected IAttributeDefinitionDescriptor createProxy(IAttribute attribute) {
            IAttributeDefinitionDescriptor result = (IAttributeDefinitionDescriptor)ConfigurationElementFactory.emptyInstance(IAttributeDefinitionDescriptor.class);
            result.setDisplayName(attribute.getDisplayName());
            result.setId("com.ibm.team.apt.attributes._" + attribute.getIdentifier());
            result.setImplementationName("com.ibm.team.apt.client.WorkItemAttribute");
            result.setParameters(new IParameter[]{IParameter.FACTORY.create(PlanAttributesAspectEditor.KEY_ATTR, attribute.getIdentifier())});
            result.setType(PlanItemAttributes.getPlanningAttributeType((String)attribute.getAttributeType()));
            return result;
        }
    }

    private class WorkItemAttributeFilter
    extends ViewerFilter {
        private WorkItemAttributeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IAttributeDefinitionDescriptor)) {
                return true;
            }
            IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)element;
            return PlanItemAttributes.getAttributeId((IAttributeDefinitionDescriptor)attribute) != null;
        }
    }

    private static class WorkItemAttributesDialog
    extends ListDialog {
        private final IFilter<IAttribute> fFilter;

        static IAttribute openDialog(final IProjectAreaHandle projectArea, final Shell parent, final String title, final String message, final IFilter<IAttribute> filter) {
            final IAttribute[] result = new IAttribute[1];
            TeamRunnable runnable = new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectArea);
                    final List attributes = workItemClient.findAttributes(projectArea, monitor);
                    UI.syncExec((Control)parent, new Runnable(){

                        @Override
                        public void run() {
                            WorkItemAttributesDialog dialog = new WorkItemAttributesDialog(parent, title, message, (IFilter<IAttribute>)filter);
                            dialog.setInput(attributes);
                            if (dialog.open() == 0) {
                                result[0] = (IAttribute)dialog.getResult()[0];
                            }
                        }
                    });
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return result[0];
        }

        public WorkItemAttributesDialog(Shell parent, String title, String message, IFilter<IAttribute> filter) {
            super(parent);
            this.fFilter = filter;
            this.setTitle(title);
            this.setMessage(message);
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IAttribute) {
                        return ((IAttribute)element).getDisplayName();
                    }
                    return super.getText(element);
                }
            });
        }

        protected Control createDialogArea(Composite container) {
            Control result = super.createDialogArea(container);
            this.getTableViewer().setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IAttribute) {
                        return fFilter.accept((Object)((IAttribute)element));
                    }
                    return false;
                }
            }});
            UI.hookHelpListener(result, "com.ibm.team.apt.ide.ui.dialog_attribute_selection");
            return result;
        }
    }
}

