/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates;

import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.plantype.IBacklogIteration;
import com.ibm.team.apt.internal.common.process.AuditablePlanningItemStore;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.EstimateConfiguration;
import com.ibm.team.apt.internal.common.rcp.IPlanningItemStore;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.AbstractPlanAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked.BlockedConfiguration;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked.BlockedHelper;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.blocked.WorkItemTypesDialog;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.ide.ui.internal.aspecteditor.type.TypeCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class EstimationModeAspectEditor
extends AbstractPlanAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.workItemProgressMode";
    private static final Point PROCESS_SHARING_PREFERRED_SIZE = EstimationModeAspectEditor.createSize();
    private static final int INCREASE_PREFERRED_HEIGHT = 15;
    private Composite fContainer;
    private ControlEnableState fEnableState;
    private ComboViewer fEstimateViewer;
    private InformationViewer fInformationViewer;
    private TreeViewer fTreeViewer;
    private EstimateConfiguration fConfiguration;
    private ItemMap<IDevelopmentLine, Node<IIteration>> fAllIterations = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IIteration, IBacklogIteration> fUnplannedIterations = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private Button fButtonEstimatesInHours;
    private Button fButtonBlockedConfiguration;
    private Image fProcessSharingWarningImage;
    private final BlockedConfiguration fBlockedConfiguration = new BlockedConfiguration();

    @Override
    protected void doInit(ProcessAspect aspect, boolean isRevert) {
        ModelElement element = aspect.getConfigurationElement();
        this.fConfiguration = element == null ? new EstimateConfiguration() : new EstimateConfiguration(element);
        new AbstractPlanAspectEditor.PlanAspectJob(this){

            @Override
            protected IStatus runBusy(IProgressMonitor monitor) throws Exception {
                EstimationModeAspectEditor.this.fBlockedConfiguration.setShowProcessSharingWarning(BlockedHelper.showProcessSharingWarning(EstimationModeAspectEditor.this.getAspect(), EstimationModeAspectEditor.this.isProcessConsumer()));
                IProjectAreaHandle pa = EstimationModeAspectEditor.this.getProjectArea();
                if (BlockedHelper.hasPermission(pa, monitor) && EstimationModeAspectEditor.this.isInitializedProjectArea(EstimationModeAspectEditor.this.getProjectArea()) && !BlockedHelper.hasConfiguration(pa, monitor) && !EstimationModeAspectEditor.this.fBlockedConfiguration.isShowProcessSharingWarning()) {
                    EstimationModeAspectEditor.this.fBlockedConfiguration.setCanActivate(true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        new AbstractPlanAspectEditor.PlanAspectJob(this){

            @Override
            protected IStatus runBusy(IProgressMonitor monitor) throws Exception {
                IDevelopmentLineHandle[] lines;
                EstimationModeAspectEditor.this.fUnplannedIterations.clear();
                EstimationModeAspectEditor.this.fAllIterations.clear();
                IProjectAreaHandle projectAreaHandle = EstimationModeAspectEditor.this.getProjectArea();
                IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
                IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectAreaHandle);
                IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
                IDevelopmentLineHandle[] iDevelopmentLineHandleArray = lines = projectArea.getDevelopmentLines();
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    IDevelopmentLineHandle lineHandle = iDevelopmentLineHandleArray[n2];
                    IDevelopmentLine line = (IDevelopmentLine)itemManager.fetchCompleteItem((IItemHandle)lineHandle, 0, monitor);
                    AuditablePlanningItemStore itemStore = new AuditablePlanningItemStore((IAuditableCommon)auditableClient);
                    Node tree = Iterations.fetchIterationTree((IDevelopmentLineHandle)line, (IPlanningItemStore)itemStore, (IProgressMonitor)monitor);
                    EstimationModeAspectEditor.this.fAllIterations.put((IItemHandle)line, (Object)tree);
                    ++n2;
                }
                List<IBacklogIteration> unplannedIterations = EstimationModeAspectEditor.this.findConfigurationElements(IBacklogIteration.class, monitor);
                for (IBacklogIteration unplannedIteration : unplannedIterations) {
                    IIteration iteration = IterationsHelper.resolveIterationFromPath((IProcessAreaHandle)projectArea, (String)unplannedIteration.getPath(), (IAuditableCommon)auditableClient, (IProgressMonitor)monitor);
                    if (iteration == null) continue;
                    EstimationModeAspectEditor.this.fUnplannedIterations.put((IItemHandle)iteration, (Object)unplannedIteration);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public void doCreateControl(Composite container, FormToolkit toolkit) {
        this.fContainer = container;
        GridLayoutFactory.fillDefaults().applyTo(container);
        Composite composite = this.createEstimateSection(container, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite = this.createBlockedSection(container, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite = this.createUnplannedIterationSection(container, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        UI.hookHelpListener((Control)container, "com.ibm.team.apt.ide.ui.aspect_progress");
        this.update();
    }

    protected Composite createEstimateSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 264);
        section.setText(Messages.EstimationModeAspectEditor_ESTIMATE_ATTR_SECTION);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Composite firstRowContainer = toolkit.createComposite(container);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(firstRowContainer);
        section.setClient((Control)container);
        Label label = new Label(firstRowContainer, 131072);
        label.setText(Messages.EstimationModeAspectEditor_TRACK_PROGRESS);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)label);
        this.fEstimateViewer = new ComboViewer(firstRowContainer, 12);
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo(this.fEstimateViewer.getControl());
        this.fEstimateViewer.setLabelProvider((IBaseLabelProvider)new EstimationLabelProvider());
        this.fEstimateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fEstimateViewer.setInput((Object)EstimateMode.values());
        EstimateMode mode = Enum.valueOf(EstimateMode.class, this.fConfiguration.getProgressMode());
        this.fEstimateViewer.setSelection((ISelection)new StructuredSelection((Object)mode), true);
        this.fEstimateViewer.addSelectionChangedListener((ISelectionChangedListener)new EstimateChangeListener());
        this.fButtonEstimatesInHours = new Button(container, 32);
        this.fButtonEstimatesInHours.setBackground(container.getBackground());
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.fButtonEstimatesInHours);
        if (this.fConfiguration != null) {
            this.fButtonEstimatesInHours.setSelection(EstimateOutputFormat.Hours.equals((Object)this.fConfiguration.getEstimateOutputFormat()));
        } else {
            this.fButtonEstimatesInHours.setSelection(false);
        }
        this.fButtonEstimatesInHours.setText(Messages.EstimationModeAspectEditor_ESTIMATE_FORMAT);
        this.fButtonEstimatesInHours.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EstimationModeAspectEditor.this.setDirty();
                if (EstimationModeAspectEditor.this.fConfiguration != null) {
                    EstimationModeAspectEditor.this.fConfiguration.setEstimateOutputFormat(EstimationModeAspectEditor.this.fButtonEstimatesInHours.getSelection() ? EstimateOutputFormat.Hours : EstimateOutputFormat.Mixed);
                }
            }
        });
        return section;
    }

    protected Composite createBlockedSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 392);
        section.setText(Messages.EstimationModeAspectEditor_BLOCKED_SECTION);
        section.setDescription(Messages.EstimationModeAspectEditor_BLOCKED_SECTION_DESCRIPTION);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(container);
        section.setClient((Control)container);
        Composite firstRowContainer = toolkit.createComposite(container);
        int rowColumns = this.fBlockedConfiguration.isShowProcessSharingWarning() ? 2 : 1;
        GridLayoutFactory.fillDefaults().numColumns(rowColumns).applyTo(firstRowContainer);
        this.fButtonBlockedConfiguration = new Button(firstRowContainer, 0);
        this.fButtonBlockedConfiguration.setEnabled(this.fBlockedConfiguration.canActivate());
        this.fButtonBlockedConfiguration.setBackground(container.getBackground());
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.fButtonBlockedConfiguration);
        this.fButtonBlockedConfiguration.setText(Messages.EstimationModeAspectEditor_BLOCKED_BUTTON);
        this.fButtonBlockedConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeCategory[] allTypes = BlockedHelper.getWorkItemTypes(EstimationModeAspectEditor.this.getSite());
                EstimationModeAspectEditor.this.fBlockedConfiguration.setAllWorkItemTypes(allTypes);
                List<TypeCategory> selectedTypes = WorkItemTypesDialog.openDialog(EstimationModeAspectEditor.this.fContainer.getShell(), EstimationModeAspectEditor.this.getSite(), Messages.EstimationModeAspectEditor_BLOCKED_DIALOG, Messages.EstimationModeAspectEditor_BLOCKED_DIALOG_MESSAGE, allTypes);
                if (!selectedTypes.isEmpty()) {
                    EstimationModeAspectEditor.this.fBlockedConfiguration.setSelectedWorkItemTypes(selectedTypes);
                    EstimationModeAspectEditor.this.setDirty();
                }
            }
        });
        if (this.fBlockedConfiguration.isShowProcessSharingWarning()) {
            this.fProcessSharingWarningImage = ImagePool.WARNING_OBJ.createImage();
            final CLabel label = new CLabel(firstRowContainer, 66);
            label.setImage(this.fProcessSharingWarningImage);
            TooltipSupport tooltipSupport = new TooltipSupport((Control)label, true, false){

                protected Object mapElement(int x, int y) {
                    Rectangle bounds;
                    if (label != null && !label.isDisposed() && label.getImage() != null && (bounds = label.getImage().getBounds()).contains(x, y)) {
                        return label;
                    }
                    return null;
                }

                protected String getMarkup(Object element, boolean isFocus) {
                    return Messages.EstimationModeAspectEditor_BLOCKED_SHARED_PROCESS_WARNING;
                }
            };
            tooltipSupport.setPreferredFocusSize(PROCESS_SHARING_PREFERRED_SIZE);
            tooltipSupport.setPreferredHoverSize(PROCESS_SHARING_PREFERRED_SIZE);
        }
        return section;
    }

    protected Composite createUnplannedIterationSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 392);
        section.setText(Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_SECTION);
        section.setDescription(Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_SECTION_DESC);
        Composite container = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(container);
        section.setClient((Control)container);
        this.fInformationViewer = new InformationViewer(container, 0);
        GridDataFactory.fillDefaults().applyTo(this.fInformationViewer.getControl());
        this.fInformationViewer.setLabelProvider(new InformationViewer.MessageLabelProvider());
        this.fInformationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fInformationViewer.addInformationMessageListener(new InformationViewer.IInformationMessageListener(){

            @Override
            public void closed(Object element) {
                ((Collection)EstimationModeAspectEditor.this.fInformationViewer.getInput()).remove(element);
                EstimationModeAspectEditor.this.fInformationViewer.refresh();
            }

            @Override
            public void clicked(Object element, String text) {
            }
        });
        this.fTreeViewer = new TreeViewer(container, 2048);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, this.fTreeViewer.getTree().getItemHeight() * 13).applyTo(this.fTreeViewer.getControl());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new UnplannedIterationLabelProvider());
        this.fTreeViewer.setContentProvider((IContentProvider)new UnplannedIterationContentProvider());
        this.fTreeViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_SECTION;
                }
            }
        });
        ToolBarManager toolBar = new ToolBarManager();
        toolBar.add((IAction)new MarkAsUnplannedAction((ISelectionProvider)this.fTreeViewer));
        section.setTextClient((Control)toolBar.createControl((Composite)section));
        return section;
    }

    @Override
    protected void update() {
        if (this.fContainer == null) {
            return;
        }
        UI.asyncExec((Control)this.fContainer, new Runnable(){

            @Override
            public void run() {
                if (EstimationModeAspectEditor.this.isBusy() && EstimationModeAspectEditor.this.fEnableState == null) {
                    EstimationModeAspectEditor.this.fEnableState = ControlEnableState.disable((Control)EstimationModeAspectEditor.this.fContainer);
                } else if (EstimationModeAspectEditor.this.fEnableState != null) {
                    EstimationModeAspectEditor.this.fEnableState.restore();
                    EstimationModeAspectEditor.this.fEnableState = null;
                }
                if (EstimationModeAspectEditor.this.fEstimateViewer != null) {
                    EstimateMode mode = Enum.valueOf(EstimateMode.class, EstimationModeAspectEditor.this.fConfiguration.getProgressMode());
                    EstimationModeAspectEditor.this.fEstimateViewer.setSelection((ISelection)new StructuredSelection((Object)mode));
                }
                if (EstimationModeAspectEditor.this.fButtonEstimatesInHours != null) {
                    if (EstimationModeAspectEditor.this.fConfiguration != null) {
                        EstimationModeAspectEditor.this.fButtonEstimatesInHours.setSelection(EstimateOutputFormat.Hours.equals((Object)EstimationModeAspectEditor.this.fConfiguration.getEstimateOutputFormat()));
                    } else {
                        EstimationModeAspectEditor.this.fButtonEstimatesInHours.setSelection(false);
                    }
                }
                if (EstimationModeAspectEditor.this.fButtonBlockedConfiguration != null) {
                    EstimationModeAspectEditor.this.fButtonBlockedConfiguration.setEnabled(EstimationModeAspectEditor.this.fBlockedConfiguration.canActivate());
                }
                if (EstimationModeAspectEditor.this.fAllIterations != null && EstimationModeAspectEditor.this.fTreeViewer != null) {
                    Object input = EstimationModeAspectEditor.this.fTreeViewer.getInput();
                    if (input == null || !input.equals(EstimationModeAspectEditor.this.fAllIterations)) {
                        EstimationModeAspectEditor.this.fTreeViewer.setInput((Object)EstimationModeAspectEditor.this.fAllIterations);
                    }
                    for (final IIteration iteration : EstimationModeAspectEditor.this.fUnplannedIterations.keySet()) {
                        for (Node node : EstimationModeAspectEditor.this.fAllIterations.values()) {
                            Node element = (Node)node.depthFirstIterator((IFilter)new IFilter<IIteration>(){

                                public boolean accept(IIteration element) {
                                    return element != null && element.sameItemId((IItemHandle)iteration);
                                }
                            }).next();
                            EstimationModeAspectEditor.this.fTreeViewer.expandToLevel((Object)element, -1);
                        }
                    }
                    EstimationModeAspectEditor.this.fTreeViewer.refresh();
                    Iterator iter = EstimationModeAspectEditor.this.fUnplannedIterations.keySet().iterator();
                    ArrayList<Message> messages = new ArrayList<Message>();
                    while (iter.hasNext()) {
                        IIteration iteration = (IIteration)iter.next();
                        if (iteration.isArchived()) {
                            messages.add(new Message(NLS.bind((String)Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_VERIFY_ARCHIVED, (Object)iteration.getLabel()), Severity.WARNING));
                        }
                        if (iteration.getParent() != null) {
                            messages.add(new Message(NLS.bind((String)Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_VERIFY_PARENT, (Object)iteration.getLabel()), Severity.INFO));
                        }
                        for (Node node : EstimationModeAspectEditor.this.fAllIterations.values()) {
                            Node thisNode = node.find((Object)iteration);
                            if (thisNode == null || thisNode.getChildren().isEmpty()) continue;
                            messages.add(new Message(NLS.bind((String)Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_VERIFY_CHILDREN, (Object)iteration.getLabel()), Severity.INFO));
                        }
                    }
                    EstimationModeAspectEditor.this.fInformationViewer.setInput(messages);
                    EstimationModeAspectEditor.this.fInformationViewer.refresh();
                    if (EstimationModeAspectEditor.this.fEnableState != null) {
                        EstimationModeAspectEditor.this.fEnableState.restore();
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getLabelProvider().dispose();
            this.fTreeViewer.getContentProvider().dispose();
        }
        if (this.fProcessSharingWarningImage != null) {
            this.fProcessSharingWarningImage.dispose();
        }
        this.fAllIterations = null;
        this.fUnplannedIterations = null;
    }

    protected boolean saveState(IMemento memento) {
        memento.putString("id", this.getAspect().getId());
        memento.putString("xmlns", this.getAspect().getSchemaNamespaceURI());
        if (this.fConfiguration != null) {
            this.fConfiguration.writeTo(memento);
        }
        this.fBlockedConfiguration.saveIfAvailable(this.getSite(), this.getAspect(), this.getLineDelimiter());
        this.saveSate(memento, this.fUnplannedIterations.values().toCollection());
        return true;
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    private static Point createSize() {
        Point result = new Point(240, 70);
        result.y += 15;
        return result;
    }

    private boolean isInitializedProjectArea(IProjectAreaHandle projectAreaHandle) {
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
        IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)projectAreaHandle);
        return projectArea != null && projectArea.isInitialized();
    }

    private final class EstimateChangeListener
    implements ISelectionChangedListener {
        private EstimateChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (EstimationModeAspectEditor.this.fConfiguration != null) {
                String value = ((EstimateMode)((IStructuredSelection)event.getSelection()).getFirstElement()).name();
                if (EstimationModeAspectEditor.this.fConfiguration.getProgressMode() == null || !EstimationModeAspectEditor.this.fConfiguration.getProgressMode().equals(value)) {
                    EstimationModeAspectEditor.this.fConfiguration.setProgressMode(value);
                    EstimationModeAspectEditor.this.setDirty();
                }
            }
        }
    }

    private final class EstimationLabelProvider
    extends LabelProvider {
        private EstimationLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EstimateMode) {
                return ((EstimateMode)element).getDisplayName();
            }
            return super.getText(element);
        }
    }

    private final class MarkAsUnplannedAction
    extends Action
    implements ISelectionChangedListener {
        private final ISelectionProvider fProvider;

        public MarkAsUnplannedAction(ISelectionProvider provider) {
            this.fProvider = provider;
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setText(Messages.EstimationModeAspectEditor_LABEL_MARK_AS_UNPLANNED);
            this.setImageDescriptor(ImagePool.ITERATION_UNPLANNED);
        }

        public void run() {
            final IIteration iteration = this.getSelectedIteration();
            if (iteration == null) {
                return;
            }
            EstimationModeAspectEditor.this.setDirty();
            new AbstractPlanAspectEditor.PlanAspectJob(EstimationModeAspectEditor.this){

                @Override
                protected IStatus runBusy(IProgressMonitor monitor) throws Exception {
                    IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)iteration);
                    String path = Iterations.createIterationPath((IIterationHandle)iteration, (IPlanningItemStore)new AuditablePlanningItemStore((IAuditableCommon)auditableClient), (IProgressMonitor)monitor);
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)iteration).itemManager();
                    IDevelopmentLine timeline = (IDevelopmentLine)itemManager.fetchCompleteItem((IItemHandle)iteration.getDevelopmentLine(), 0, monitor);
                    if (EstimationModeAspectEditor.this.fUnplannedIterations.containsKey((IItemHandle)iteration) && ((IBacklogIteration)EstimationModeAspectEditor.this.fUnplannedIterations.get((IItemHandle)iteration)).getId().equals(timeline.getId())) {
                        EstimationModeAspectEditor.this.fUnplannedIterations.remove((Object)iteration);
                    } else {
                        Iterator iter = EstimationModeAspectEditor.this.fUnplannedIterations.entrySet().iterator();
                        ItemArrayList keys = new ItemArrayList(CMode.CURRENT_HANDLEONLY);
                        while (iter.hasNext()) {
                            Map.Entry next = (Map.Entry)iter.next();
                            if (!((IBacklogIteration)next.getValue()).getId().equals(timeline.getId())) continue;
                            keys.add((Object)((IIteration)next.getKey()));
                        }
                        for (IIteration key : keys) {
                            EstimationModeAspectEditor.this.fUnplannedIterations.remove((Object)key);
                        }
                        IBacklogIteration instance = (IBacklogIteration)ConfigurationElementFactory.emptyInstance(IBacklogIteration.class);
                        instance.setTimeLineId(timeline.getId());
                        instance.setPath(path);
                        EstimationModeAspectEditor.this.fUnplannedIterations.put((IItemHandle)iteration, (Object)instance);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IIteration iteration = this.getSelectedIteration();
            this.setEnabled(iteration != null);
        }

        protected IIteration getSelectedIteration() {
            ISelection selection = this.fProvider.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.isEmpty()) {
                return null;
            }
            Object firstElement = structuredSelection.getFirstElement();
            if (!(firstElement instanceof Node)) {
                return null;
            }
            return (IIteration)((firstElement = ((Node)firstElement).getElement()) instanceof IIteration ? firstElement : null);
        }
    }

    private final class UnplannedIterationContentProvider
    implements ITreeContentProvider {
        private ItemMap<IDevelopmentLine, Node<IIteration>> fInput;

        private UnplannedIterationContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDevelopmentLineHandle) {
                return ((Node)this.fInput.get((IItemHandle)parentElement)).getChildren().toArray();
            }
            if (parentElement instanceof Node) {
                return ((Node)parentElement).getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Node) {
                Node node = ((Node)element).getParent();
                if (node.getElement() != null) {
                    return node;
                }
                if ((element = ((Node)element).getElement()) instanceof IIteration) {
                    IDevelopmentLineHandle handle = ((IIteration)element).getDevelopmentLine();
                    for (IDevelopmentLine next : EstimationModeAspectEditor.this.fAllIterations.keySet()) {
                        if (!next.sameItemId((IItemHandle)handle)) continue;
                        return next;
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Node) {
                return !((Node)element).getChildren().isEmpty();
            }
            return true;
        }

        public Object[] getElements(Object inputElement) {
            return this.fInput.keySet().toArray();
        }

        public void dispose() {
            this.fInput = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fInput = (ItemMap)newInput;
        }
    }

    private final class UnplannedIterationLabelProvider
    extends StandardLabelProvider {
        public UnplannedIterationLabelProvider() {
            super((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof Node) {
                element = ((Node)element).getElement();
            }
            super.updateLabel(label, element);
            if (element instanceof IIteration && EstimationModeAspectEditor.this.fUnplannedIterations.containsKey((IItemHandle)element)) {
                OverlayIcon newImage = new OverlayIcon(null, label.getImage(), new ImageDescriptor[]{ImagePool.ITERATION_UNPLANNED_OVR}, new Point(16, 16), 16512);
                label.setImage(this.getResources().createImage((ImageDescriptor)newImage));
                label.setForeground(EstimationModeAspectEditor.this.fContainer.getShell().getDisplay().getSystemColor(9));
                label.setText(NLS.bind((String)Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_DECORATION_PATTERN, (Object)label.getText(), (Object)Messages.EstimationModeAspectEditor_UNPLANNED_ITERATION_DECORATION));
            }
        }
    }
}

