/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates;

import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.ReferenceAttributeProvider;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.process.CompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.ProcessConfigurationNodeProvider;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessItemHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.AbstractConfigurationDataAspectEditor;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractPlanAspectEditor
extends AbstractConfigurationDataAspectEditor {
    private AtomicInteger fBusyState = new AtomicInteger(0);

    protected IProcessItemHandle getProcessItem() {
        return (IProcessItemHandle)this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getItemHandle();
    }

    protected IProjectAreaHandle getProjectArea() {
        IProcessItemHandle processItemHandle = this.getProcessItem();
        if (processItemHandle instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)processItemHandle;
        }
        return null;
    }

    protected <T extends IConfigurationElement> T findConfigurationElements(Class<T> type, final String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IProjectAreaHandle projectArea = this.getProjectArea();
        IIterationPlanClient planClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectArea);
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
        IAuditableCommonProcess process = auditableClient.getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
        CompositeNodeProvider provider = new CompositeNodeProvider((INodeProvider)new NodeProvider(), new INodeProvider[]{new ReferenceAttributeProvider(process, monitor), new ProcessConfigurationNodeProvider(process), StaticConfigurationDataRegistry.getInstance()});
        IFilter<INode> filter = new IFilter<INode>(){

            public boolean accept(INode element) {
                return element.getAttribute("id").equals(identifier);
            }
        };
        return (T)((IConfigurationElement)ConfigurationElementFactory.singleInstance(type, (IFilter)filter, (INodeProvider)provider, (List)planClient.getConfigurationElementMassages(), (IProgressMonitor)progress.newChild(1)));
    }

    protected <T extends IConfigurationElement> List<T> findConfigurationElements(Class<T> type, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IProjectAreaHandle projectArea = this.getProjectArea();
        IIterationPlanClient planClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectArea);
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
        IAuditableCommonProcess process = auditableClient.getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
        CompositeNodeProvider provider = new CompositeNodeProvider((INodeProvider)new NodeProvider(), new INodeProvider[]{new ReferenceAttributeProvider(process, monitor), new ProcessConfigurationNodeProvider(process), StaticConfigurationDataRegistry.getInstance()});
        List list = ConfigurationElementFactory.allInstances(type, (IFilter)ConfigurationElementFactory.nullFilter, (INodeProvider)provider, (List)planClient.getConfigurationElementMassages(), (IProgressMonitor)progress.newChild(1));
        HashSet set = new HashSet(list);
        return new ArrayList(set);
    }

    protected <T extends IConfigurationElement> boolean isProcessSpecDefined(T instance) {
        return ConfigurationElements.isProviderType(instance, NodeProvider.class, (Class[])new Class[]{ProcessConfigurationNodeProvider.class});
    }

    protected void busy(boolean busy) {
        if (busy) {
            this.fBusyState.incrementAndGet();
        } else {
            this.fBusyState.decrementAndGet();
        }
        this.update();
    }

    protected boolean isBusy() {
        return this.fBusyState.get() > 0;
    }

    protected boolean isEnabled() {
        return this.getProjectArea() != null;
    }

    public final void createControl(Composite parent, FormToolkit toolkit) {
        if (!this.isEnabled()) {
            this.createNoProjectAreaMessage(parent, toolkit);
        } else {
            this.doCreateControl(parent, toolkit);
        }
    }

    protected void createNoProjectAreaMessage(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Label label = toolkit.createLabel(parent, Messages.AbstractPlanAspectEditor_MSG_NO_EDITING_FOR_TEMPLATES);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)label);
    }

    public abstract void doCreateControl(Composite var1, FormToolkit var2);

    protected abstract void update();

    protected boolean saveSate(IMemento memento, Collection<? extends IConfigurationElement> elements) {
        memento.putString("xmlns", this.getAspect().getSchemaNamespaceURI());
        for (IConfigurationElement iConfigurationElement : elements) {
            ConfigurationElementFactory.serializeIntoRoot((Object)iConfigurationElement, (IMemento)memento);
        }
        this.update();
        return !elements.isEmpty();
    }

    public void revert() {
        this.doInit(this.getAspect(), true);
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.doInit(this.getAspect(), false);
    }

    protected abstract void doInit(ProcessAspect var1, boolean var2);

    public class DeferredContentProvider
    extends ArrayContentProvider {
        public Object[] getElements(Object inputElement) {
            if (AbstractPlanAspectEditor.this.isBusy()) {
                return new Object[]{Messages.AbstractPlanAspectEditor_MONITOR_PENDING};
            }
            return super.getElements(inputElement);
        }
    }

    public final class NodeProvider
    implements INodeProvider {
        public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
            ModelElement element = AbstractPlanAspectEditor.this.getSite().getConfigurationData(identifier);
            if (element != null) {
                return INode.FACTORY.createNode((Object)element, (INodeProvider)this);
            }
            return null;
        }
    }

    public abstract class PlanAspectJob
    extends FoundationJob {
        public PlanAspectJob() {
            super(NLS.bind((String)Messages.AbstractPlanAspectEditor_JOB_LOAD_DATA, (Object)AbstractPlanAspectEditor.this.getAspect().getName()));
        }

        public boolean shouldSchedule() {
            return AbstractPlanAspectEditor.this.isEnabled();
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            try {
                AbstractPlanAspectEditor.this.busy(true);
                IStatus iStatus = this.runBusy(monitor);
                return iStatus;
            }
            finally {
                AbstractPlanAspectEditor.this.busy(false);
            }
        }

        protected abstract IStatus runBusy(IProgressMonitor var1) throws Exception;
    }
}

