/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.binding;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.ide.ui.aspect.binding.AbstractBindingAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.binding.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class PlanItemBindingAspectEditor
extends AbstractBindingAspectEditor {
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.topLevelPlanWorkItemBinding";
    private Collection<String> fCheckedTypes = new HashSet<String>(16);
    private CheckboxTableViewer fViewer;

    private static AbstractBindingAspectEditor.WorkItemType[] getCheckedTypes(Collection<AbstractBindingAspectEditor.WorkItemType> available, Collection<String> bound) {
        ArrayList<AbstractBindingAspectEditor.WorkItemType> result = new ArrayList<AbstractBindingAspectEditor.WorkItemType>(available.size());
        for (AbstractBindingAspectEditor.WorkItemType type : available) {
            if (!bound.contains(type.id)) continue;
            result.add(type);
        }
        return result.toArray(new AbstractBindingAspectEditor.WorkItemType[result.size()]);
    }

    private static void synchronizeTypes(Collection<String> successors, Collection<String> predecessors) {
        ArrayList<String> toRemove = new ArrayList<String>(predecessors);
        toRemove.removeAll(successors);
        ArrayList<String> toAdd = new ArrayList<String>(successors);
        toAdd.removeAll(predecessors);
        predecessors.removeAll(toRemove);
        predecessors.addAll(toAdd);
    }

    @Override
    protected void createContents(Composite container) {
        GridLayoutFactory.fillDefaults().applyTo(container);
        Label label = new Label(container, 64);
        label.setText(Messages.PlanItemBindingAspectEditor_TOP_LEVEL_WORK_ITEM_TYPES);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2080);
        this.fViewer.setSorter(new ViewerSorter(){
            Collator collator = CollatorCache.getInstance();

            public int compare(Viewer viewer, Object predecessor, Object successor) {
                AbstractBindingAspectEditor.WorkItemType first = (AbstractBindingAspectEditor.WorkItemType)predecessor;
                AbstractBindingAspectEditor.WorkItemType second = (AbstractBindingAspectEditor.WorkItemType)successor;
                return this.collator.compare(first.name, second.name);
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                AbstractBindingAspectEditor.WorkItemType type = (AbstractBindingAspectEditor.WorkItemType)element;
                return type.name;
            }
        });
        this.updateUI();
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractBindingAspectEditor.WorkItemType type = (AbstractBindingAspectEditor.WorkItemType)event.getElement();
                if (event.getChecked()) {
                    PlanItemBindingAspectEditor.this.fCheckedTypes.add(type.id);
                } else {
                    PlanItemBindingAspectEditor.this.fCheckedTypes.remove(type.id);
                }
                PlanItemBindingAspectEditor.this.setDirty();
            }
        });
        UI.hookHelpListener((Control)container, "com.ibm.team.apt.ide.ui.aspect_top_level_types");
    }

    @Override
    protected String getElementName() {
        return "topLevelPlanWorkItemBinding";
    }

    @Override
    protected String getOptionName() {
        return Messages.PlanItemBindingAspectEditor_TOP_LEVEL_WORK_ITEM_TYPE;
    }

    @Override
    protected void doSaveState(IMemento memento) {
        PlanItemBindingAspectEditor.synchronizeTypes(this.fCheckedTypes, this.getBoundWorkItemTypes());
        super.doSaveState(memento);
    }

    public void revert() {
        this.refreshBoundWorkItemTypes();
        this.updateUI();
        this.setDirty(false);
    }

    private void updateUI() {
        Collection<AbstractBindingAspectEditor.WorkItemType> available = this.getAvailableWorkItemTypes();
        Collection<String> bound = this.getBoundWorkItemTypes();
        this.fViewer.setInput(available);
        this.fCheckedTypes.addAll(bound);
        this.fViewer.setCheckedElements((Object[])PlanItemBindingAspectEditor.getCheckedTypes(available, bound));
    }
}

