/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.binding;

import com.ibm.team.apt.internal.ide.ui.aspect.AbstractProcessAspectEditor;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

public abstract class AbstractBindingAspectEditor
extends AbstractProcessAspectEditor {
    private static final String ATTRIBUTE_ICON_URL = "icon";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "workitemType";
    private static final String ELEMENT_TYPE = "type";
    protected static final String WORK_ITEM_CATEGORY = "com.ibm.team.workitem.category";
    protected static final String WORK_ITEM_TYPES = "com.ibm.team.workitem.configuration.workItemTypes";
    private Collection<String> fBoundTypes = new LinkedHashSet<String>(4);

    protected AbstractBindingAspectEditor() {
    }

    @Override
    protected void doSaveState(IMemento memento) {
        for (String type : this.fBoundTypes) {
            memento.createChild(this.getElementName()).putString(ATTRIBUTE_TYPE, type);
        }
    }

    @Override
    protected final void doSetInput(ProcessAspect aspect) {
        this.refreshBoundWorkItemTypes();
    }

    protected final void refreshBoundWorkItemTypes() {
        ModelElement element;
        this.fBoundTypes.clear();
        ProcessAspect aspect = this.getAspect();
        if (aspect != null && (element = aspect.getConfigurationElement()) != null) {
            Collection<ModelElement> results = AbstractBindingAspectEditor.findConfigurationElements(element, this.getElementName());
            for (ModelElement result : results) {
                String type = result.getAttribute(ATTRIBUTE_TYPE);
                if (type == null || "".equals(type)) continue;
                this.fBoundTypes.add(type);
            }
        }
    }

    protected final Collection<WorkItemType> getAvailableWorkItemTypes() {
        ModelElement element;
        ArrayList<WorkItemType> types = new ArrayList<WorkItemType>(32);
        ProcessAspect aspect = this.getWorkItemAspect(WORK_ITEM_TYPES);
        if (aspect != null && (element = aspect.getConfigurationElement()) != null) {
            for (ModelElement child : element.getChildElements()) {
                if (!ELEMENT_TYPE.equals(child.getName())) continue;
                String id = child.getAttribute(ATTRIBUTE_ID);
                String name = child.getAttribute(ATTRIBUTE_NAME);
                String url = child.getAttribute(ATTRIBUTE_ICON_URL);
                if (id == null || "".equals(id)) continue;
                WorkItemType type = new WorkItemType();
                type.id = id;
                type.name = name != null && !"".equals(name) ? name : id;
                type.iconURL = url;
                types.add(type);
            }
        }
        return types;
    }

    public String[] getRelatedDataIds() {
        return new String[]{WORK_ITEM_TYPES};
    }

    protected final Collection<String> getBoundWorkItemTypes() {
        return this.fBoundTypes;
    }

    protected abstract String getElementName();

    protected final ProcessAspect getWorkItemAspect(String id) {
        ProcessAspect aspect = this.getAspect();
        if (aspect == null) {
            return null;
        }
        ProcessAspect parent = aspect.getParentAspect();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getParentAspect()) == null) {
            return null;
        }
        ProcessAspect child = parent.getChildAspect(WORK_ITEM_CATEGORY);
        if (child == null) {
            return null;
        }
        return child.getChildAspect(id);
    }

    protected static final class WorkItemType {
        public String iconURL;
        public String id;
        public String name;

        protected WorkItemType() {
        }
    }
}

