/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.nucleus.query.BaseIterationPlanRecordQueryModel;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.common.util.ItemQueryResults;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.aspect.Messages;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.AbstractPlanAspectEditor;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlanTypeAspectEditor
extends AbstractPlanAspectEditor {
    private final String fgPending = Messages.PlanModesAspectEditor_MONITOR_PENDING;
    private static final int STATUS_VISIBLE_LINES = 2;
    private final Object fgFamily = new Object();
    private final Set<IPlanType> fPlanTypes = new HashSet<IPlanType>();
    private final Set<IPlanType> fProcessSpecPlanTypes = new HashSet<IPlanType>();
    private LocalResourceManager fResources;
    private Composite fParent;
    private ControlEnableState fState;
    private Text fTxtName;
    private Text fTxtIdentifier;
    private Text fTxtDescription;
    private TableViewer fLstPlanTypes;
    private TableViewer fLstPlanModes;
    private Label fStatusImage;
    private Link fStatusLink;
    private Composite fStatusContainer;

    @Override
    protected void doInit(ProcessAspect aspect, boolean isRevert) {
        new ResolveJob().schedule();
    }

    @Override
    public void doCreateControl(Composite parent, FormToolkit toolkit) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fParent = parent;
        GridLayoutFactory.fillDefaults().equalWidth(true).numColumns(2).applyTo(parent);
        Composite composite = this.createPlanModesSection(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite = this.createDetailsSection(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.wireSections();
        this.update();
        UI.hookHelpListener((Control)this.fParent, "com.ibm.team.apt.ide.ui.aspect_plan_types");
    }

    protected void wireSections() {
        this.fLstPlanTypes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                IPlanType planMode = (IPlanType)selection.getFirstElement();
                PlanTypeAspectEditor.this.fTxtName.setText(UI.safeString(planMode.getDisplayName()));
                PlanTypeAspectEditor.this.fTxtIdentifier.setText(UI.safeString(planMode.getId()));
                PlanTypeAspectEditor.this.fTxtDescription.setText(UI.safeString(planMode.getDescription()));
                PlanTypeAspectEditor.this.fLstPlanModes.setInput((Object)planMode.getPlanModes());
                if (PlanTypeAspectEditor.this.fLstPlanModes.getInput() != null) {
                    PlanTypeAspectEditor.this.setWarningMessageForEmptyPlanView(PlanTypeAspectEditor.this.fLstPlanModes.getInput());
                }
            }
        });
    }

    private void setWarningMessageForEmptyPlanView(Object planViews) {
        if (planViews != null && planViews instanceof IPlanModeDescription[]) {
            IPlanModeDescription[] listOfPlanView = (IPlanModeDescription[])planViews;
            if (listOfPlanView.length == 0) {
                if (!this.fStatusImage.isDisposed() && !this.fStatusLink.isDisposed()) {
                    Image warningImage = this.fResources.createImage(com.ibm.team.workitem.ide.ui.internal.ImagePool.WARNING_ICON);
                    String warningMessage = Messages.PlanTypeAspectEditor_EMPTY_PLAN_VIEW_WARNING;
                    if (this.fStatusImage.getImage() != null && !this.fStatusImage.getImage().equals((Object)warningImage)) {
                        this.fStatusImage.setImage(warningImage);
                    }
                    if (this.fStatusLink.getText() != null && !this.fStatusLink.getText().equals(warningMessage)) {
                        this.fStatusLink.setText(warningMessage);
                    }
                    this.fStatusContainer.setVisible(true);
                    GridDataFactory.fillDefaults().align(4, 0x1000000).hint(150, -1).exclude(false).applyTo((Control)this.fStatusContainer);
                    this.fStatusContainer.getParent().layout(false);
                }
            } else {
                this.fStatusContainer.setVisible(false);
                GridDataFactory.fillDefaults().exclude(true).applyTo((Control)this.fStatusContainer);
                this.fStatusContainer.getParent().layout(false);
            }
        }
    }

    protected Composite createPlanModesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 264);
        section.setText(Messages.PlanTypeAspectEditor_TITLE_PLAN_TYPES);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        section.setClient((Control)composite);
        this.fLstPlanTypes = new TableViewer(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fLstPlanTypes.getControl());
        this.fLstPlanTypes.setLabelProvider((IBaseLabelProvider)new PlanTypeLabelProvider());
        this.fLstPlanTypes.setContentProvider((IContentProvider)new AbstractPlanAspectEditor.DeferredContentProvider(this));
        this.fLstPlanTypes.setComparator((ViewerComparator)new PlanTypeComparator());
        this.fLstPlanTypes.setInput(this.fPlanTypes);
        ToolBarManager mgr = new ToolBarManager(0x800000);
        mgr.add((IAction)new RemovePlanTypeAction());
        ToolBar toolbar = mgr.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        return section;
    }

    protected Composite createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 264);
        section.setText(Messages.PlanTypeAspectEditor_TITLE_DETAILS);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        section.setClient((Control)composite);
        toolkit.createLabel(composite, Messages.PlanTypeAspectEditor_LBL_NAME);
        this.fTxtName = toolkit.createText(composite, "", 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTxtName);
        toolkit.createLabel(composite, Messages.PlanTypeAspectEditor_LBL_IDENTIFIER);
        this.fTxtIdentifier = toolkit.createText(composite, "", 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTxtIdentifier);
        toolkit.createLabel(composite, Messages.PlanTypeAspectEditor_LBL_DESC);
        this.fTxtDescription = toolkit.createText(composite, "", 2058);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fTxtDescription);
        toolkit.createLabel(composite, Messages.PlanTypeAspectEditor_LBL_PLAN_MODES);
        this.fStatusContainer = toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).exclude(true).applyTo((Control)this.fStatusContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fStatusContainer);
        this.fStatusContainer.setBackgroundMode(1);
        this.fStatusImage = new Label(this.fStatusContainer, 0);
        toolkit.adapt((Control)this.fStatusImage, false, false);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.fStatusImage);
        this.fStatusImage.setImage(this.fResources.createImage(com.ibm.team.workitem.ide.ui.internal.ImagePool.EMPTY_ICON));
        this.fStatusLink = new Link(this.fStatusContainer, toolkit.getOrientation());
        int minStatusHeight = Utils.convertHeightInCharsToPixels((Control)this.fStatusLink, (int)2);
        GridDataFactory.fillDefaults().hint(-1, minStatusHeight).grab(true, true).applyTo((Control)this.fStatusLink);
        Composite cmpPlanModes = toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)cmpPlanModes);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(cmpPlanModes);
        this.fLstPlanModes = new TableViewer(cmpPlanModes, 2048);
        this.fLstPlanModes.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fLstPlanModes.setLabelProvider((IBaseLabelProvider)new PlanModeLabelProvider());
        this.fLstPlanModes.setComparator(new ViewerComparator());
        toolkit.adapt((Composite)this.fLstPlanModes.getTable());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fLstPlanModes.getControl());
        this.fLstPlanModes.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.PlanTypeAspectEditor_LBL_PLAN_MODES;
                }
            }
        });
        Composite toolbar = toolkit.createComposite(cmpPlanModes);
        GridDataFactory.fillDefaults().grab(false, true).align(0x1000000, 1).applyTo((Control)toolbar);
        GridLayoutFactory.fillDefaults().applyTo(toolbar);
        Button btn = this.createAction(toolbar, toolkit, new AddPlanModeAction());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        btn = this.createAction(toolbar, toolkit, new RemovePlanModeAction());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btn);
        return section;
    }

    protected Button createAction(Composite parent, FormToolkit toolkit, final Action action) {
        final Button btn = toolkit.createButton(parent, action.getText(), 8);
        btn.setEnabled(action.isEnabled());
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                btn.setEnabled(action.isEnabled());
                btn.setText(action.getText());
            }
        });
        return btn;
    }

    @Override
    protected void update() {
        if (this.fParent == null) {
            return;
        }
        UI.asyncExec((Control)this.fParent, new Runnable(){

            @Override
            public void run() {
                if (PlanTypeAspectEditor.this.isBusy() && PlanTypeAspectEditor.this.fState == null) {
                    PlanTypeAspectEditor.this.fState = ControlEnableState.disable((Control)PlanTypeAspectEditor.this.fParent);
                } else if (PlanTypeAspectEditor.this.fState != null) {
                    PlanTypeAspectEditor.this.fState.restore();
                    PlanTypeAspectEditor.this.fState = null;
                }
                PlanTypeAspectEditor.this.fLstPlanTypes.refresh();
                PlanTypeAspectEditor.this.fLstPlanTypes.setSelection(PlanTypeAspectEditor.this.fLstPlanTypes.getSelection());
            }
        });
    }

    private IPlanType getSelectedPlanType() {
        IStructuredSelection selection = (IStructuredSelection)this.fLstPlanTypes.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return (IPlanType)selection.getFirstElement();
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        ArrayList<IPlanType> planTypes = new ArrayList<IPlanType>();
        for (IPlanType planType : this.fProcessSpecPlanTypes) {
            URI iconURI = planType.getIconURI();
            if (iconURI != null) {
                URI relativeIconURI = null;
                try {
                    relativeIconURI = new URI(null, null, iconURI.getPath(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                planType = (IPlanType)ConfigurationElementFactory.copy((Object)planType);
                ConfigurationElements.update((Object)planType, (Object)iconURI, (Object)relativeIconURI);
            }
            planTypes.add(planType);
        }
        return this.saveSate(memento, planTypes);
    }

    private class AddPlanModeAction
    extends PlanTypeAction {
        public AddPlanModeAction() {
            super(Messages.PlanTypeAspectEditor_ADD_LABEL);
            this.setEnabled(false);
        }

        public void run() {
            PlanModeSelectionDialog dialog = new PlanModeSelectionDialog(PlanTypeAspectEditor.this.fParent.getShell());
            if (dialog.open() == 0) {
                IPlanModeDescription planMode = dialog.getPlanMode();
                IPlanType planType = PlanTypeAspectEditor.this.getSelectedPlanType();
                HashSet<IPlanModeDescription> planModes = new HashSet<IPlanModeDescription>();
                planModes.add(planMode);
                planModes.addAll(Arrays.asList(planType.getPlanModes()));
                planType.setPlanModes(planModes.toArray(new IPlanModeDescription[0]));
                this.replace(PlanTypeAspectEditor.this.fProcessSpecPlanTypes, planType);
                PlanTypeAspectEditor.this.setDirty(true);
                PlanTypeAspectEditor.this.update();
            }
        }
    }

    private class PlanModeLabelProvider
    extends LabelProvider {
        private PlanModeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPlanModeDescription) {
                IPlanModeDescription description = (IPlanModeDescription)element;
                return Messages.bind((String)Messages.PlanTypeAspectEditor_PLAN_MODE_LABEL_PROVIDER_PATTERN, (Object)description.getDisplayName(), (Object)description.getId());
            }
            return super.getText(element);
        }
    }

    private class PlanModeSelectionDialog
    extends ListDialog {
        protected TableViewer fTableViewer;

        public PlanModeSelectionDialog(Shell parent) {
            super(parent);
            this.setTitle(Messages.PlanModesAspectEditor_TITLE_SELECT_PLAN);
            this.setMessage(Messages.PlanModesAspectEditor_MSG_SELECT_PLAN);
            this.setLabelProvider((ILabelProvider)new PlanModeLabelProvider());
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setInput(PlanTypeAspectEditor.this.fgPending);
            this.setAddCancelButton(true);
            new FoundationJob(""){

                public boolean belongsTo(Object family) {
                    return family == PlanTypeAspectEditor.this.fgFamily;
                }

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    final List elements = PlanTypeAspectEditor.this.findConfigurationElements(IPlanModeDescription.class, monitor);
                    PlanModeSelectionDialog.this.fTableViewer = PlanModeSelectionDialog.this.getTableViewer();
                    int count = 0;
                    while (PlanModeSelectionDialog.this.fTableViewer == null && count <= 8) {
                        Thread.sleep(250L);
                        PlanModeSelectionDialog.this.fTableViewer = PlanModeSelectionDialog.this.getTableViewer();
                        ++count;
                    }
                    if (PlanModeSelectionDialog.this.fTableViewer == null) {
                        Status status = new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanTypeAspectEditor_PLAN_TYPES_ERROR);
                        return status;
                    }
                    UI.asyncExec(PlanModeSelectionDialog.this.fTableViewer.getControl(), new Runnable(){

                        @Override
                        public void run() {
                            elements.removeAll(Arrays.asList(PlanTypeAspectEditor.this.getSelectedPlanType().getPlanModes()));
                            PlanModeSelectionDialog.this.setInput(elements);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        protected Control createDialogArea(Composite container) {
            Control result = super.createDialogArea(container);
            UI.hookHelpListener(result, "com.ibm.team.apt.ide.ui.dialog_planmode_select");
            return result;
        }

        public IPlanModeDescription getPlanMode() {
            Object[] result = this.getResult();
            if (result == null || result.length == 0) {
                return null;
            }
            Object value = result[0];
            if (value instanceof IPlanModeDescription) {
                return (IPlanModeDescription)value;
            }
            return null;
        }

        public void setInput(Object input) {
            super.setInput(input);
            TableViewer tableViewer = this.getTableViewer();
            if (tableViewer != null) {
                tableViewer.setInput(input);
            }
        }

        protected void cancelPressed() {
            Job.getJobManager().cancel(PlanTypeAspectEditor.this.fgFamily);
            super.cancelPressed();
        }
    }

    private class PlanTypeAction
    extends Action {
        public PlanTypeAction(String text) {
            this.setText(text);
            ISelectionChangedListener listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PlanTypeAction.this.setEnabled(PlanTypeAction.this.computeEnabled());
                }
            };
            PlanTypeAspectEditor.this.fLstPlanTypes.addSelectionChangedListener(listener);
            if (PlanTypeAspectEditor.this.fLstPlanModes != null) {
                PlanTypeAspectEditor.this.fLstPlanModes.addSelectionChangedListener(listener);
            }
        }

        protected boolean computeEnabled() {
            return PlanTypeAspectEditor.this.getSelectedPlanType() != null;
        }

        protected <E> boolean replace(Set<E> set, E element) {
            set.remove(element);
            return set.add(element);
        }
    }

    private class PlanTypeComparator
    extends ViewerComparator {
        private PlanTypeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IPlanType p1 = (IPlanType)e1;
            IPlanType p2 = (IPlanType)e2;
            if (p1.getPlanItems().isReleasePlan() ^ p2.getPlanItems().isReleasePlan()) {
                return p1.getPlanItems().isReleasePlan() ? 1 : -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class PlanTypeLabelProvider
    extends LabelProvider {
        private PlanTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPlanType) {
                return NLS.bind((String)Messages.PlanTypeAspectEditor_PATTERN_PLAN_TYPE, (Object)((IPlanType)element).getDisplayName(), (Object[])new Object[]{PlanTypeAspectEditor.this.fProcessSpecPlanTypes.contains(element) ? Messages.PlanTypeAspectEditor_PATTERN_CUSTOM : Messages.PlanTypeAspectEditor_PATTERN_PREDEFINED});
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IPlanType) {
                return PlanTypeAspectEditor.this.fResources.createImage(PlanningUI.getImageDescriptor((IPlanType)element));
            }
            return super.getImage(element);
        }
    }

    private class RemovePlanModeAction
    extends PlanTypeAction {
        public RemovePlanModeAction() {
            super(Messages.PlanTypeAspectEditor_REMOVE_LABEL);
            this.setEnabled(false);
        }

        @Override
        protected boolean computeEnabled() {
            IStructuredSelection selection = (IStructuredSelection)PlanTypeAspectEditor.this.fLstPlanModes.getSelection();
            return selection != null && !selection.isEmpty();
        }

        public void run() {
            IPlanModeDescription[] listOfPlanView;
            IPlanModeDescription planMode = (IPlanModeDescription)((IStructuredSelection)PlanTypeAspectEditor.this.fLstPlanModes.getSelection()).getFirstElement();
            IPlanType planType = PlanTypeAspectEditor.this.getSelectedPlanType();
            Object planViews = PlanTypeAspectEditor.this.fLstPlanModes.getInput();
            if (planViews != null && planViews instanceof IPlanModeDescription[] && (listOfPlanView = (IPlanModeDescription[])planViews).length <= 1) {
                MessageDialog.openWarning((Shell)PlanTypeAspectEditor.this.fParent.getShell(), (String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_VIEW_WARNING_TITLE, (String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_VIEW_WARNING_MESSAGE);
                return;
            }
            HashSet<IPlanModeDescription> planModes = new HashSet<IPlanModeDescription>();
            planModes.addAll(Arrays.asList(planType.getPlanModes()));
            planModes.remove(planMode);
            planType.setPlanModes(planModes.toArray(new IPlanModeDescription[0]));
            this.replace(PlanTypeAspectEditor.this.fProcessSpecPlanTypes, planType);
            PlanTypeAspectEditor.this.setDirty(true);
            PlanTypeAspectEditor.this.update();
        }
    }

    private class RemovePlanTypeAction
    extends PlanTypeAction {
        public RemovePlanTypeAction() {
            super(Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_LABEL);
            this.setImageDescriptor(ImagePool.REMOVE);
            this.setEnabled(false);
        }

        @Override
        protected boolean computeEnabled() {
            return PlanTypeAspectEditor.this.fProcessSpecPlanTypes.contains(PlanTypeAspectEditor.this.getSelectedPlanType());
        }

        public void run() {
            final IPlanType planType = PlanTypeAspectEditor.this.getSelectedPlanType();
            boolean hides = StaticConfigurationDataRegistry.getInstance().getInstances(IPlanType.class).contains(planType);
            if (!MessageDialog.openConfirm((Shell)PlanTypeAspectEditor.this.fParent.getShell(), (String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_TITLE, (String)(hides ? NLS.bind((String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_MSG_HIDES, (Object)planType.getDisplayName(), (Object[])new Object[0]) : NLS.bind((String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_MSG, (Object)planType.getDisplayName(), (Object[])new Object[0])))) {
                return;
            }
            final ArrayList dependentPlans = new ArrayList();
            TeamRunnable runnable = new TeamRunnable(){

                @Override
                protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_MONITOR, (int)2);
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)PlanTypeAspectEditor.this.getProjectArea()).itemManager();
                    IQueryService queryService = ((IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)PlanTypeAspectEditor.this.getProjectArea())).getQueryService();
                    BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel model = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
                    IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
                    Object[] params = new Object[]{planType.getId()};
                    IPredicate filter = model.planType()._eq((IString)query.newStringArg());
                    query.filter(filter);
                    ItemQueryResults result = new ItemQueryResults(queryService, query, params);
                    progress.worked(1);
                    dependentPlans.addAll(itemManager.fetchCompleteItems(result.getAllItems(), 0, (IProgressMonitor)progress.newChild(1)));
                    progress.done();
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            catch (InterruptedException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            if (!dependentPlans.isEmpty()) {
                MultiStatus status = new MultiStatus(PlanningClientPlugin.getPluginId(), 2, Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_FAILURE, null);
                for (IIterationPlanRecord plan : dependentPlans) {
                    status.add((IStatus)new Status(2, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_DETAIL, (Object)plan.getName(), (Object[])new Object[]{planType.getDisplayName()})));
                }
                MultiStatus dspStatus = status.getChildren().length == 1 ? status.getChildren()[0] : status;
                ErrorDialog.openError((Shell)PlanTypeAspectEditor.this.fParent.getShell(), (String)Messages.PlanTypeAspectEditor_REMOVE_PLAN_TYPE_LABEL, (String)status.getMessage(), (IStatus)dspStatus);
                return;
            }
            PlanTypeAspectEditor.this.fProcessSpecPlanTypes.remove(planType);
            PlanTypeAspectEditor.this.setDirty(true);
            PlanTypeAspectEditor.this.update();
        }
    }

    private class ResolveJob
    extends AbstractPlanAspectEditor.PlanAspectJob {
        private ResolveJob() {
            super(PlanTypeAspectEditor.this);
        }

        @Override
        protected IStatus runBusy(IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            PlanTypeAspectEditor.this.fPlanTypes.clear();
            PlanTypeAspectEditor.this.fProcessSpecPlanTypes.clear();
            List planTypes = PlanTypeAspectEditor.this.findConfigurationElements(IPlanType.class, (IProgressMonitor)progress.newChild(1));
            PlanTypeAspectEditor.this.fPlanTypes.addAll(planTypes);
            for (IPlanType planType : planTypes) {
                if (!PlanTypeAspectEditor.this.isProcessSpecDefined((IConfigurationElement)planType)) continue;
                PlanTypeAspectEditor.this.fProcessSpecPlanTypes.add(planType);
            }
            return Status.OK_STATUS;
        }
    }
}

