/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect;

import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanMode;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.aspect.Messages;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.AbstractPlanAspectEditor;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class PlanModesAspectEditor
extends AbstractPlanAspectEditor {
    private Set<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>> fSharedPlanModes = new HashSet<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>>();
    private Set<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>> fSharedPlanModesRemovals = new HashSet<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>>();
    private Set<IPlanModeDescription> fPredefinedPlanModes = new HashSet<IPlanModeDescription>();
    private Set<IPlanModeDescription> fProcessSpecPlanModes = new HashSet<IPlanModeDescription>();
    private LocalResourceManager fResources;
    private Composite fParent;
    private Text fTxtName;
    private Text fTxtIdentifier;
    private TableViewer fViewerPlanModes;
    private ImageHyperlink fLnkPlanModeState;

    @Override
    protected void doInit(ProcessAspect aspect, boolean isRevert) {
        new ResolverJob().schedule();
    }

    @Override
    public void doCreateControl(Composite parent, FormToolkit toolkit) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fParent = parent;
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(parent);
        Composite composite = this.createPlanModesSection(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite = this.createDetailsSection(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.wireSections();
        this.update();
        UI.hookHelpListener((Control)this.fParent, "com.ibm.team.apt.ide.ui.aspect_plan_modes");
    }

    protected void wireSections() {
        this.fViewerPlanModes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                Object element = selection.getFirstElement();
                if (element instanceof IPlanModeDescription) {
                    IPlanModeDescription planMode = (IPlanModeDescription)element;
                    PlanModesAspectEditor.this.fLnkPlanModeState.setImage(PlanModesAspectEditor.this.fResources.createImage(ImagePool.HTML_COMPLETE));
                    PlanModesAspectEditor.this.fLnkPlanModeState.setText(Messages.PlanModesAspectEditor_MSG_OK_TO_USE);
                    PlanModesAspectEditor.this.fTxtName.setText(UI.safeString(planMode.getDisplayName()));
                    PlanModesAspectEditor.this.fTxtIdentifier.setText(UI.safeString(planMode.getId()));
                } else if (element instanceof IPlanModeDescription.ConfigurationElementCreationReport) {
                    IStatus status = ((IPlanModeDescription.ConfigurationElementCreationReport)element).getStatus();
                    PlanModesAspectEditor.this.fLnkPlanModeState.setImage(PlanModesAspectEditor.this.fResources.createImage(status.isOK() ? ImagePool.HTML_COMPLETE : ImagePool.WARNING_OBJ));
                    PlanModesAspectEditor.this.fLnkPlanModeState.setText(status.isOK() ? Messages.PlanModesAspectEditor_MSG_OK_TO_USE : UI.safeString(status.getMessage()));
                    IPlanModeDescription planMode = (IPlanModeDescription)((IPlanModeDescription.ConfigurationElementCreationReport)element).getResult();
                    if (planMode != null) {
                        PlanModesAspectEditor.this.fTxtName.setText(UI.safeString(planMode.getDisplayName()));
                        PlanModesAspectEditor.this.fTxtIdentifier.setText(UI.safeString(planMode.getId()));
                    } else {
                        PlanModesAspectEditor.this.fTxtName.setText("");
                        PlanModesAspectEditor.this.fTxtIdentifier.setText("");
                    }
                }
                PlanModesAspectEditor.this.fParent.layout(new Control[]{PlanModesAspectEditor.this.fLnkPlanModeState});
            }
        });
    }

    public void setViewerPlanModes(TableViewer viewer) {
        this.fViewerPlanModes = viewer;
    }

    protected Composite createPlanModesSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 264);
        section.setText(Messages.PlanModesAspectEditor_SECTION_TITLE_PLAN_MODES);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        section.setClient((Control)composite);
        this.fViewerPlanModes = new TableViewer(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fViewerPlanModes.getControl());
        this.fViewerPlanModes.setLabelProvider((IBaseLabelProvider)new PlanModeLabelProvider());
        this.fViewerPlanModes.setContentProvider((IContentProvider)new PlanModeContentProvider());
        this.fViewerPlanModes.setComparator((ViewerComparator)new PlanModeComparator());
        this.fViewerPlanModes.setInput((Object)Boolean.TRUE);
        this.fViewerPlanModes.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.PlanModesAspectEditor_SECTION_TITLE_PLAN_MODES;
                }
            }
        });
        ToolBarManager mgr = new ToolBarManager(0x800000);
        mgr.add((IAction)new PromotePlanModeAction());
        mgr.add((IAction)new RemovePlanModeAction());
        ToolBar toolBar = mgr.createControl((Composite)section);
        section.setTextClient((Control)toolBar);
        return section;
    }

    protected Composite createDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 264);
        section.setText(Messages.PlanModesAspectEditor_SECTION_TITLE_DETAILS);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        section.setClient((Control)composite);
        this.fLnkPlanModeState = toolkit.createImageHyperlink(composite, 0x1000000);
        toolkit.getHyperlinkGroup().add((Hyperlink)this.fLnkPlanModeState);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fLnkPlanModeState);
        toolkit.createLabel(composite, Messages.PlanModesAspectEditor_LBL_NAME);
        this.fTxtName = toolkit.createText(composite, "", 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTxtName);
        toolkit.createLabel(composite, Messages.PlanModesAspectEditor_LBL_IDENTIFIER);
        this.fTxtIdentifier = toolkit.createText(composite, "", 2060);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTxtIdentifier);
        return section;
    }

    @Override
    protected void update() {
        if (this.fParent == null) {
            return;
        }
        UI.asyncExec((Control)this.fParent, new Runnable(){

            @Override
            public void run() {
                PlanModesAspectEditor.this.fViewerPlanModes.setInput((Object)PlanModesAspectEditor.this.isBusy());
            }
        });
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        TeamRunnable runnable = new TeamRunnable(){

            @Override
            protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PlanModesAspectEditor_MONITOR_DELETE_SHARED, (int)1);
                if (PlanModesAspectEditor.this.fSharedPlanModesRemovals.isEmpty()) {
                    return;
                }
                List<ISharedPlanMode> sharedPlanModes = PlanModesAspectEditor.map(PlanModesAspectEditor.this.fSharedPlanModesRemovals, new IMapping<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>, ISharedPlanMode>(){

                    @Override
                    public ISharedPlanMode map(IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription> element) {
                        return element == null ? null : element.getSharedPlanMode();
                    }
                });
                try {
                    IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)((IItemHandle)sharedPlanModes.get(0)));
                    client.deleteSharedPlanModeDescription(PlanModesAspectEditor.this.getProjectArea(), sharedPlanModes, (IProgressMonitor)progress);
                }
                catch (TeamOperationCanceledException e) {
                    List<IPlanModeDescription> failedPromotions = PlanModesAspectEditor.map(PlanModesAspectEditor.this.fSharedPlanModesRemovals, new IMapping<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>, IPlanModeDescription>(){

                        @Override
                        public IPlanModeDescription map(IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription> input) {
                            return input == null ? null : (IPlanModeDescription)input.getResult();
                        }
                    });
                    PlanModesAspectEditor.this.fProcessSpecPlanModes.removeAll(failedPromotions);
                    PlanModesAspectEditor.this.fSharedPlanModes.addAll(PlanModesAspectEditor.this.fSharedPlanModesRemovals);
                    throw e;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.saveSate(memento, this.fProcessSpecPlanModes);
    }

    static <T1, T2> List<T2> map(Collection<T1> c1, IMapping<T1, T2> converter) {
        ArrayList<T2> result = new ArrayList<T2>(c1.size());
        Iterator<T1> iter = c1.iterator();
        while (iter.hasNext()) {
            result.add(converter.map(iter.next()));
        }
        return result;
    }

    static interface IMapping<I, O> {
        public O map(I var1);
    }

    private abstract class PlanModeAction
    extends Action {
        public PlanModeAction(String text) {
            this.setText(text);
            PlanModesAspectEditor.this.fViewerPlanModes.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PlanModeAction.this.setEnabled(PlanModeAction.this.computeEnabled());
                }
            });
        }

        public boolean computeEnabled() {
            Object planMode = this.getSelectedElement();
            return PlanModesAspectEditor.this.fProcessSpecPlanModes.contains(planMode) || PlanModesAspectEditor.this.fSharedPlanModes.contains(planMode);
        }

        protected Object getSelectedElement() {
            IStructuredSelection selection = (IStructuredSelection)PlanModesAspectEditor.this.fViewerPlanModes.getSelection();
            if (selection == null || selection.isEmpty()) {
                return null;
            }
            Object element = selection.getFirstElement();
            return element;
        }

        protected IPlanModeDescription getSelectedPlanMode() {
            Object element = this.getSelectedElement();
            if (element == null) {
                return null;
            }
            if (element instanceof IPlanModeDescription) {
                return (IPlanModeDescription)element;
            }
            if (element instanceof IPlanModeDescription.ConfigurationElementCreationReport) {
                return (IPlanModeDescription)((IPlanModeDescription.ConfigurationElementCreationReport)element).getResult();
            }
            return null;
        }
    }

    private class PlanModeComparator
    extends ViewerComparator {
        private PlanModeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (PlanModesAspectEditor.this.fSharedPlanModes.contains(e1) ^ PlanModesAspectEditor.this.fSharedPlanModes.contains(e2)) {
                return PlanModesAspectEditor.this.fSharedPlanModes.contains(e1) ? -1 : 1;
            }
            if (PlanModesAspectEditor.this.fProcessSpecPlanModes.contains(e1) ^ PlanModesAspectEditor.this.fProcessSpecPlanModes.contains(e2)) {
                return PlanModesAspectEditor.this.fProcessSpecPlanModes.contains(e1) ? -1 : 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class PlanModeContentProvider
    extends ArrayContentProvider {
        private PlanModeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Boolean value = (Boolean)inputElement;
            if (!value.booleanValue()) {
                HashSet elements = new HashSet();
                elements.addAll(PlanModesAspectEditor.this.fPredefinedPlanModes);
                elements.addAll(PlanModesAspectEditor.this.fProcessSpecPlanModes);
                elements.addAll(PlanModesAspectEditor.this.fSharedPlanModes);
                return elements.toArray();
            }
            return new Object[]{Messages.PlanModesAspectEditor_PENDING};
        }
    }

    private class PlanModeLabelProvider
    extends LabelProvider {
        private PlanModeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPlanModeDescription) {
                return ((IPlanModeDescription)element).getDisplayName();
            }
            if (element instanceof IPlanModeDescription.ConfigurationElementCreationReport) {
                IPlanModeDescription.ConfigurationElementCreationReport report = (IPlanModeDescription.ConfigurationElementCreationReport)element;
                IPlanModeDescription planMode = (IPlanModeDescription)report.getResult();
                if (planMode == null) {
                    return Messages.PlanModesAspectEditor_LBL_BROKEN_PLAN_MODE;
                }
                return planMode.getDisplayName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (PlanModesAspectEditor.this.fPredefinedPlanModes.contains(element)) {
                return PlanModesAspectEditor.this.fResources.createImage(ImagePool.ATTR_BUILT_IN);
            }
            if (PlanModesAspectEditor.this.fProcessSpecPlanModes.contains(element)) {
                return PlanModesAspectEditor.this.fResources.createImage(ImagePool.ATTR_CUSTOM);
            }
            if (PlanModesAspectEditor.this.fSharedPlanModes.contains(element)) {
                IPlanModeDescription.ConfigurationElementCreationReport report = (IPlanModeDescription.ConfigurationElementCreationReport)element;
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.USER_OVER;
                OverlayIcon imgSharedPlanMode = new OverlayIcon(ImagePool.ATTR_BUILT_IN, imageDescriptorArray, 132096);
                IPlanModeDescription planMode = (IPlanModeDescription)report.getResult();
                if (planMode == null) {
                    ImageDescriptor[] imageDescriptorArray2 = new ImageDescriptor[2];
                    imageDescriptorArray2[1] = ImagePool.WARNING_OVR;
                    return PlanModesAspectEditor.this.fResources.createImage((ImageDescriptor)new OverlayIcon((ImageDescriptor)imgSharedPlanMode, imageDescriptorArray2, 17408));
                }
                return PlanModesAspectEditor.this.fResources.createImage((ImageDescriptor)imgSharedPlanMode);
            }
            return super.getImage(element);
        }
    }

    public class PromotePlanModeAction
    extends PlanModeAction {
        private static final String TREE_MODE = "com.ibm.team.apt.internal.viewmode.tree";
        private static final String KANBAN_MODE = "com.ibm.team.apt.internal.viewmode.kanban";
        private static final String TASKBOARD_MODE = "com.ibm.team.apt.internal.viewmode.taskboard";
        private static final String QUICK_QUERY_FILTER_MODE = "com.ibm.team.apt.filter.quickQuery";

        public PromotePlanModeAction() {
            super(Messages.PlanModesAspectEditor_PROMOTE_LABEL);
            this.setImageDescriptor(ImagePool.OUTDENT);
        }

        @Override
        public boolean computeEnabled() {
            return this.getSelectedPlanMode() != null && PlanModesAspectEditor.this.fSharedPlanModes.contains(this.getSelectedElement());
        }

        public void run() {
            IPlanModeDescription.ConfigurationElementCreationReport report = (IPlanModeDescription.ConfigurationElementCreationReport)this.getSelectedElement();
            IPlanModeDescription planMode = (IPlanModeDescription)report.getResult();
            IFilterDescription[] iFilterDescriptionArray = planMode.getFilters();
            int n = iFilterDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                String implementation;
                IFilterDescription filter = iFilterDescriptionArray[n2];
                String string = implementation = filter != null ? filter.getImplementationName() : null;
                if ("com.ibm.team.apt.shared.ui.internal.filter.QuickQueryFilter".equals(implementation)) {
                    MessageDialog.openInformation((Shell)PlanModesAspectEditor.this.fParent.getShell(), (String)this.getText(), (String)NLS.bind((String)Messages.PlanModesAspectEditor_PROMOTE_MSG_NA, (Object)planMode.getDisplayName(), (Object[])new Object[0]));
                    return;
                }
                ++n2;
            }
            this.convertViewModeToDefinition(planMode.getViewMode());
            if (!MessageDialog.openConfirm((Shell)PlanModesAspectEditor.this.fParent.getShell(), (String)this.getText(), (String)NLS.bind((String)Messages.PlanModesAspectEditor_PROMOTE_MSG, (Object)planMode.getDisplayName(), (Object[])new Object[0]))) {
                return;
            }
            PlanModesAspectEditor.this.fSharedPlanModes.remove(report);
            PlanModesAspectEditor.this.fSharedPlanModesRemovals.add(report);
            PlanModesAspectEditor.this.fPredefinedPlanModes.remove(planMode);
            PlanModesAspectEditor.this.fProcessSpecPlanModes.add(planMode);
            PlanModesAspectEditor.this.update();
            PlanModesAspectEditor.this.setDirty(true);
        }

        public void convertViewModeToDefinition(IViewModeDescription viewmode) {
            String implementation;
            String string = implementation = viewmode != null ? viewmode.getImplementationName() : null;
            if ("com.ibm.team.apt.shared.ui.internal.structure.TreeViewMode".equals(implementation)) {
                viewmode.setId(TREE_MODE);
            } else if ("com.ibm.team.apt.shared.ui.internal.viewmodes.KanbanViewMode".equals(implementation)) {
                viewmode.setId(KANBAN_MODE);
            } else if ("com.ibm.team.apt.shared.ui.internal.structure.TaskboardViewMode".equals(implementation)) {
                viewmode.setId(TASKBOARD_MODE);
            }
        }
    }

    private class RemovePlanModeAction
    extends PlanModeAction {
        private PlanModeLabelProvider fLabelProvider;

        public RemovePlanModeAction() {
            super(Messages.PlanModesAspectEditor_REMOVE_LABEL);
            this.fLabelProvider = new PlanModeLabelProvider();
            this.setImageDescriptor(ImagePool.REMOVE);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)PlanModesAspectEditor.this.fViewerPlanModes.getSelection();
            final Object element = selection.getFirstElement();
            final IPlanModeDescription planModeToDelete = this.getSelectedPlanMode();
            final List predefinedPlanModes = StaticConfigurationDataRegistry.getInstance().getInstances(IPlanModeDescription.class);
            if (MessageDialog.openConfirm((Shell)PlanModesAspectEditor.this.fParent.getShell(), (String)this.getText(), (String)NLS.bind((String)Messages.PlanModesAspectEditor_DEL_CONFIRM, (Object)this.fLabelProvider.getText(element), (Object[])new Object[0]))) {
                final MultiStatus status = new MultiStatus(PlanningClientPlugin.getPluginId(), 0, Messages.PlanModesAspectEditor_REMOVE_FAIL_DEP, null);
                TeamRunnable dependencyCheck = new TeamRunnable(){

                    @Override
                    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                        if (planModeToDelete == null) {
                            return;
                        }
                        if (predefinedPlanModes.contains(planModeToDelete)) {
                            return;
                        }
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.PlanModesAspectEditor_REMOVE_MONITOR_DEP, (int)2);
                        List planTypes = PlanModesAspectEditor.this.findConfigurationElements(IPlanType.class, (IProgressMonitor)progress.newChild(1));
                        progress.setWorkRemaining(planTypes.size());
                        block0: for (IPlanType planType : planTypes) {
                            IPlanModeDescription[] planModes;
                            IPlanModeDescription[] iPlanModeDescriptionArray = planModes = planType.getPlanModes();
                            int n = planModes.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IPlanModeDescription planMode = iPlanModeDescriptionArray[n2];
                                if (planMode.equals(planModeToDelete)) {
                                    status.add((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanModesAspectEditor_REMOVE_FAIL_DEP_DETAIL, (Object)planType.getDisplayName(), (Object[])new Object[]{RemovePlanModeAction.this.fLabelProvider.getText(element)})));
                                    continue block0;
                                }
                                ++n2;
                            }
                        }
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)dependencyCheck);
                }
                catch (InvocationTargetException e) {
                    PlanningClientPlugin.log((Throwable)e);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!status.isOK()) {
                    MultiStatus dspStatus = status.getChildren().length == 1 ? status.getChildren()[0] : status;
                    ErrorDialog.openError((Shell)PlanModesAspectEditor.this.fParent.getShell(), (String)this.getText(), (String)status.getMessage(), (IStatus)dspStatus);
                    return;
                }
                if (PlanModesAspectEditor.this.fSharedPlanModes.contains(element)) {
                    PlanModesAspectEditor.this.fSharedPlanModesRemovals.add((IPlanModeDescription.ConfigurationElementCreationReport)element);
                }
                PlanModesAspectEditor.this.fProcessSpecPlanModes.remove(element);
                PlanModesAspectEditor.this.fSharedPlanModes.remove(element);
                int index = predefinedPlanModes.indexOf(element);
                if (index != -1) {
                    IPlanModeDescription planModeDescription = (IPlanModeDescription)predefinedPlanModes.get(index);
                    PlanModesAspectEditor.this.fPredefinedPlanModes.add(planModeDescription);
                }
                PlanModesAspectEditor.this.setDirty(true);
                PlanModesAspectEditor.this.update();
            }
        }
    }

    private class ResolverJob
    extends FoundationJob {
        public ResolverJob() {
            super("");
            this.setSystem(false);
            this.setUser(false);
        }

        public boolean shouldSchedule() {
            return PlanModesAspectEditor.this.isEnabled();
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            PlanModesAspectEditor.this.busy(true);
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                IProjectAreaHandle projectArea = PlanModesAspectEditor.this.getProjectArea();
                IterationPlanClient planClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectArea);
                List elements = PlanModesAspectEditor.this.findConfigurationElements(IPlanModeDescription.class, (IProgressMonitor)progress.newChild(1));
                for (IPlanModeDescription planMode : elements) {
                    if (PlanModesAspectEditor.this.isProcessSpecDefined((IConfigurationElement)planMode)) {
                        PlanModesAspectEditor.this.fProcessSpecPlanModes.add(planMode);
                        continue;
                    }
                    PlanModesAspectEditor.this.fPredefinedPlanModes.add(planMode);
                }
                PlanModesAspectEditor.this.fSharedPlanModes.addAll(planClient.fetchSharedPlanModeDescriptions(projectArea, (IProgressMonitor)progress.newChild(1)));
            }
            finally {
                PlanModesAspectEditor.this.busy(false);
            }
            return Status.OK_STATUS;
        }
    }
}

