/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.ISchedulerDescription;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.aspect.DeprecatedConfigurationElementFilter;
import com.ibm.team.apt.internal.ide.ui.aspect.Messages;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.AbstractPlanAspectEditor;
import com.ibm.team.apt.internal.ide.ui.editor.ConfigurationDescriptorLabelProvider;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.internal.util.PublicAttributeHelper;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PlanConfigurationElementAspectEditor
extends AbstractPlanAspectEditor {
    private static final String GROUP_PROVIDER_IMPLEMENTATION = "com.ibm.team.apt.shared.ui.internal.structure.EnumerationGroupProvider";
    protected static final String SORT_PROVIDER_IMPLEMENTATION = "com.ibm.team.apt.shared.ui.internal.sortmode.GenericPlanItemSorter";
    private Set<IGroupModeDescription> fGroupModes = new HashSet<IGroupModeDescription>();
    private Set<ISortModeDescription> fSortModes = new HashSet<ISortModeDescription>();
    private Set<IFilterDescription> fFilters = new HashSet<IFilterDescription>();
    private Set<IPlanConfigurationElement> fProcessSpecElements = new HashSet<IPlanConfigurationElement>();
    private LocalResourceManager fResources;
    private Composite fParent;
    private TableViewer fGroupModesViewer;
    private TableViewer fSortModesViewer;
    private TableViewer fFiltersViewer;

    @Override
    protected void doInit(ProcessAspect aspect, boolean isRevert) {
        this.fProcessSpecElements.clear();
        new ResolveJob().schedule();
        ModelElement element = aspect.getConfigurationElement();
        if (element != null) {
            INode node = INode.FACTORY.createNode((Object)element, null);
            this.fProcessSpecElements.addAll(ConfigurationElementFactory.allInstances(IViewModeDescription.class, (INode)node));
            this.fProcessSpecElements.addAll(ConfigurationElementFactory.allInstances(ISchedulerDescription.class, (INode)node));
            this.fProcessSpecElements.addAll(ConfigurationElementFactory.allInstances(IGroupModeDescription.class, (INode)node));
            this.fProcessSpecElements.addAll(ConfigurationElementFactory.allInstances(ISortModeDescription.class, (INode)node));
            this.fProcessSpecElements.addAll(ConfigurationElementFactory.allInstances(IFilterDescription.class, (INode)node));
        }
    }

    @Override
    public void doCreateControl(Composite parent, FormToolkit toolkit) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fParent = parent;
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        Section section = toolkit.createSection(parent, 328);
        section.setText(Messages.PlanConfigurationElementAspectEditor_TITLE_GROUPINGS);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        this.fGroupModesViewer = this.createViewer((Composite)section);
        section.setClient(this.fGroupModesViewer.getControl());
        section.setTextClient(this.createTextClient((Composite)section, IGroupModeDescription.class, this.fGroupModes, GROUP_PROVIDER_IMPLEMENTATION, this.fGroupModesViewer, Messages.PlanConfigurationElementAspectEditor_ADD_GROUPING));
        section = toolkit.createSection(parent, 328);
        section.setText(Messages.PlanConfigurationElementAspectEditor_TITLE_SORTINGS);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        this.fSortModesViewer = this.createViewer((Composite)section);
        section.setClient(this.fSortModesViewer.getControl());
        section.setTextClient(this.createTextClient((Composite)section, ISortModeDescription.class, this.fSortModes, SORT_PROVIDER_IMPLEMENTATION, this.fSortModesViewer, Messages.PlanConfigurationElementAspectEditor_ADD_SORTING_CRITERION));
        section = toolkit.createSection(parent, 328);
        section.setText(Messages.PlanConfigurationElementAspectEditor_TITLE_FILTERS);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        this.fFiltersViewer = this.createViewer((Composite)section);
        section.setClient(this.fFiltersViewer.getControl());
        section.setTextClient(this.createTextClient((Composite)section, IFilterDescription.class, this.fFilters, null, this.fFiltersViewer, null));
        UI.hookHelpListener((Control)this.fParent, "com.ibm.team.apt.ide.ui.aspect_plan_mode_elements");
        this.update();
    }

    private TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        viewer.setContentProvider((IContentProvider)new AbstractPlanAspectEditor.DeferredContentProvider(this));
        viewer.setLabelProvider((IBaseLabelProvider)new PlanConfigurationElementLabelProvider());
        viewer.setComparator((ViewerComparator)new PlanConfigurationComparator());
        viewer.addFilter((ViewerFilter)new DeprecatedConfigurationElementFilter());
        final String accessibleLabel = ((Section)parent).getText();
        viewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = accessibleLabel;
                }
            }
        });
        return viewer;
    }

    private <T extends IPlanConfigurationElement> Control createTextClient(Composite parent, Class<T> type, Set<T> target, String implementation, TableViewer viewer, String addDialogLabel) {
        final EditPlanElementAction<T> editAction = new EditPlanElementAction<T>(type, target, implementation, (ISelectionProvider)viewer);
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (editAction.isEnabled()) {
                    editAction.run();
                }
            }
        });
        ToolBarManager mgr = new ToolBarManager(0x800000);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new ToolbarUpdater(mgr));
        mgr.add(editAction);
        if (implementation != null) {
            mgr.add(new AddPlanElementAction<T>(type, target, implementation, addDialogLabel));
        }
        mgr.add(new RemovePlanElementAction<T>(type, target, (ISelectionProvider)viewer));
        return mgr.createControl(parent);
    }

    @Override
    protected void update() {
        if (this.fParent == null) {
            return;
        }
        UI.asyncExec((Control)this.fParent, new Runnable(){

            @Override
            public void run() {
                PlanConfigurationElementAspectEditor.this.fGroupModesViewer.setInput((Object)PlanConfigurationElementAspectEditor.this.fGroupModes);
                PlanConfigurationElementAspectEditor.this.fSortModesViewer.setInput((Object)PlanConfigurationElementAspectEditor.this.fSortModes);
                PlanConfigurationElementAspectEditor.this.fFiltersViewer.setInput((Object)PlanConfigurationElementAspectEditor.this.fFilters);
            }
        });
    }

    public void dispose() {
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected boolean saveState(IMemento memento) {
        return this.saveSate(memento, this.fProcessSpecElements);
    }

    private class AddPlanElementAction<T extends IPlanConfigurationElement>
    extends Action {
        private Class<T> fType;
        private Set<T> fTarget;
        private String fDialogTitle;
        private String fImplementation;

        public AddPlanElementAction(Class<T> type, Set<T> target, String implementation, String dialogTitle) {
            this.fType = type;
            this.fTarget = target;
            this.setText(Messages.PlanConfigurationElementAspectEditor_ADD_LABEL);
            this.setImageDescriptor(ImagePool.ADD_COLUMN);
            this.fImplementation = implementation;
            this.fDialogTitle = dialogTitle;
        }

        public void run() {
            IPlanConfigurationElement element = (IPlanConfigurationElement)ConfigurationElementFactory.emptyInstance(this.fType);
            element.setId(UUID.generate().getUuidValue());
            element.setImplementationName(this.fImplementation);
            PlanElementDialog dialog = new PlanElementDialog(PlanConfigurationElementAspectEditor.this, PlanConfigurationElementAspectEditor.this.fParent.getShell(), element, EnumSet.allOf(Edits.class), this.fImplementation);
            dialog.setTitle(this.fDialogTitle);
            if (dialog.open() == 0) {
                IPlanConfigurationElement result = (IPlanConfigurationElement)this.fType.cast(dialog.getResult());
                this.fTarget.add(result);
                PlanConfigurationElementAspectEditor.this.fProcessSpecElements.add(result);
                PlanConfigurationElementAspectEditor.this.setDirty(true);
            }
            PlanConfigurationElementAspectEditor.this.update();
        }
    }

    private class EditPlanElementAction<T extends IPlanConfigurationElement>
    extends Action {
        protected final Class<T> fType;
        protected final Set<T> fTarget;
        protected final ISelectionProvider fProvider;
        private final String fImplementation;

        public EditPlanElementAction(Class<T> type, Set<T> target, String implementation, ISelectionProvider provider) {
            this.fType = type;
            this.fTarget = target;
            this.fImplementation = implementation;
            this.fProvider = provider;
            this.setText(Messages.PlanConfigurationElementAspectEditor_EDIT_LABEL);
            this.setImageDescriptor(ImagePool.EDIT_ENABLED);
            this.setDisabledImageDescriptor(ImagePool.EDIT_DISABLED);
        }

        public boolean isEnabled() {
            if (this.fProvider == null) {
                return false;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fProvider.getSelection();
            return selection != null && !selection.isEmpty() && this.fType.isInstance(selection.getFirstElement());
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.fProvider.getSelection();
            IPlanConfigurationElement element = (IPlanConfigurationElement)selection.getFirstElement();
            EnumSet<Edits> edits = this.fImplementation != null && this.fImplementation.equals(element.getImplementationName()) ? EnumSet.of(Edits.Name, Edits.Attribute) : EnumSet.of(Edits.Name);
            PlanElementDialog dialog = new PlanElementDialog(PlanConfigurationElementAspectEditor.this, PlanConfigurationElementAspectEditor.this.fParent.getShell(), element, edits, this.fImplementation);
            dialog.setTitle(this.getText());
            if (dialog.open() == 0) {
                IPlanConfigurationElement result = (IPlanConfigurationElement)this.fType.cast(dialog.getResult());
                this.replace(this.fTarget, result);
                this.replace(PlanConfigurationElementAspectEditor.this.fProcessSpecElements, result);
                PlanConfigurationElementAspectEditor.this.setDirty(true);
            }
            PlanConfigurationElementAspectEditor.this.update();
        }

        private <E extends IPlanConfigurationElement> boolean replace(Set<E> set, E element) {
            if (set.contains(element)) {
                set.remove(element);
            }
            return set.add(element);
        }
    }

    private static enum Edits {
        Name,
        Implementation,
        Attribute,
        Parameters;

    }

    private class PlanConfigurationComparator
    extends ViewerComparator {
        Collator collator = CollatorCache.getInstance();

        private PlanConfigurationComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (PlanConfigurationElementAspectEditor.this.fProcessSpecElements.contains(e1) ^ PlanConfigurationElementAspectEditor.this.fProcessSpecElements.contains(e2)) {
                return PlanConfigurationElementAspectEditor.this.fProcessSpecElements.contains(e1) ? -1 : 1;
            }
            return this.collator.compare(this.getLabel((IPlanConfigurationElement)e1), this.getLabel((IPlanConfigurationElement)e2));
        }

        private String getLabel(IPlanConfigurationElement element) {
            String result = element.getDisplayName();
            if (result == null) {
                result = element.getId();
            }
            return result;
        }
    }

    private class PlanConfigurationElementLabelProvider
    extends ConfigurationDescriptorLabelProvider {
        private PlanConfigurationElementLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlanConfigurationElementAspectEditor.this.fProcessSpecElements.contains(element) ? PlanConfigurationElementAspectEditor.this.fResources.createImage(ImagePool.ATTR_CUSTOM) : PlanConfigurationElementAspectEditor.this.fResources.createImage(ImagePool.ATTR_BUILT_IN);
        }
    }

    protected static class PlanElementDialog<T extends IPlanConfigurationElement>
    extends StatusDialog {
        private EnumSet<Edits> fEdits;
        private T fResult;
        private Set<IAttributeDefinitionDescriptor> fEnumAttributes;
        private AtomicInteger fBusyCount;
        private String dialogImplementation;
        private Composite fParent;
        private Text fTxtName;
        private Text fTxtImplentation;
        private ComboViewer fCmbAttributes;
        private ControlEnableState fUiState;
        private boolean fPrePopulated;
        final /* synthetic */ PlanConfigurationElementAspectEditor this$0;

        public PlanElementDialog(Shell parent, T element, EnumSet<Edits> edits, String implementation) {
            this.this$0 = var1_1;
            super(parent);
            this.fEnumAttributes = new HashSet<IAttributeDefinitionDescriptor>();
            this.fBusyCount = new AtomicInteger();
            this.fEdits = edits;
            this.fResult = element;
            this.dialogImplementation = implementation;
            new AttributeLoader().schedule();
        }

        public IPlanConfigurationElement getResult() {
            return this.fResult;
        }

        protected Set<IAttributeDefinitionDescriptor> getSortingAttributes() {
            return this.fEnumAttributes;
        }

        protected Control createDialogArea(Composite composite) {
            this.initializeDialogUnits((Control)composite);
            this.fParent = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fParent);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fParent);
            Label label = new Label(this.fParent, 0);
            label.setText(Messages.PlanConfigurationElementAspectEditor_LBL_NAME);
            this.fTxtName = new Text(this.fParent, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTxtName);
            this.fTxtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PlanElementDialog.this.validateFields(true);
                }
            });
            label = new Label(this.fParent, 0);
            label.setText(Messages.PlanConfigurationElementAspectEditor_LBL_IMPLEMENTATION);
            this.fTxtImplentation = new Text(this.fParent, 2052);
            this.fTxtImplentation.setEnabled(false);
            GridDataFactory.fillDefaults().grab(true, false).hint(this.convertWidthInCharsToPixels(45), -1).applyTo((Control)this.fTxtImplentation);
            label = new Label(this.fParent, 0);
            label.setText(Messages.PlanConfigurationElementAspectEditor_LBL_ATTR);
            this.fCmbAttributes = new ComboViewer(this.fParent, 12);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(this.fCmbAttributes.getControl());
            this.fCmbAttributes.setLabelProvider((IBaseLabelProvider)new ConfigurationDescriptorLabelProvider());
            this.fCmbAttributes.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fCmbAttributes.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PlanElementDialog.this.validateFields(true);
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)selection.getFirstElement();
                    IParameter[] parameters = PlanElementDialog.this.fResult.getParameters();
                    parameters = parameters == null ? new IParameter[]{} : parameters;
                    IParameter param = IParameter.FACTORY.findFirst("attribute", parameters);
                    if (param == null) {
                        param = IParameter.FACTORY.create("attribute", null);
                        parameters = IParameter.FACTORY.append(parameters, param, new IParameter[0]);
                    }
                    param.setValue(attribute.getId());
                    PlanElementDialog.this.fResult.setParameters(parameters);
                }
            });
            this.fCmbAttributes.setInput(this.fEnumAttributes);
            Dialog.applyDialogFont((Control)this.fParent);
            UI.hookHelpListener((Control)this.fParent, "com.ibm.team.apt.ide.ui.dialog_planmode_element");
            return this.fParent;
        }

        private void validateFields(boolean showErrorText) {
            this.checkNameField(showErrorText);
            if (this.getStatus().isOK()) {
                this.checkAttributeField(showErrorText);
            }
        }

        private void checkNameField(boolean showErrorText) {
            String value = this.fTxtName.getText().trim();
            if (value.length() == 0) {
                Status status = new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanConfigurationElementAspectEditor_MSG_NAME_MUST_BE);
                if (showErrorText) {
                    this.updateStatus((IStatus)status);
                } else {
                    this.updateButtonsEnableState((IStatus)status);
                }
            } else {
                this.fResult.setDisplayName(value);
                this.updateStatus(Status.OK_STATUS);
            }
        }

        private void checkAttributeField(boolean showErrorText) {
            if (!this.fEdits.contains((Object)Edits.Attribute)) {
                return;
            }
            if (this.fCmbAttributes.getCombo().getSelectionIndex() == -1) {
                Status status = new Status(4, PlanningClientPlugin.getPluginId(), Messages.PlanConfigurationElementAspectEditor_MSG_ATTRIBUTE_MUST_BE);
                if (showErrorText) {
                    this.updateStatus((IStatus)status);
                } else {
                    this.updateButtonsEnableState((IStatus)status);
                }
            } else {
                this.updateStatus(Status.OK_STATUS);
            }
        }

        protected void updateStatus(IStatus status) {
            this.updateBusy(this.fBusyCount.get() != 0);
            super.updateStatus(status);
        }

        protected void updateBusy(final boolean busy) {
            if (this.fParent == null) {
                return;
            }
            UI.asyncExec((Control)this.fParent, new Runnable(){

                @Override
                public void run() {
                    if (busy) {
                        PlanElementDialog.this.fUiState = PlanElementDialog.this.fUiState == null ? ControlEnableState.disable((Control)PlanElementDialog.this.fParent) : PlanElementDialog.this.fUiState;
                    } else {
                        if (PlanElementDialog.this.fUiState != null) {
                            PlanElementDialog.this.fUiState.restore();
                            PlanElementDialog.this.fUiState = null;
                        }
                        PlanElementDialog.this.fCmbAttributes.refresh();
                        if (!PlanElementDialog.this.fPrePopulated) {
                            PlanElementDialog.this.fPrePopulated = true;
                            if (PlanElementDialog.this.fResult.getDisplayName() != null) {
                                PlanElementDialog.this.fTxtName.setText(PlanElementDialog.this.fResult.getDisplayName());
                            }
                            if (PlanElementDialog.this.fResult.getImplementationName() != null) {
                                PlanElementDialog.this.fTxtImplentation.setText(PlanElementDialog.this.fResult.getImplementationName());
                            }
                            PlanElementDialog.this.fCmbAttributes.refresh();
                            IParameter parameter = IParameter.FACTORY.findFirst("attribute", PlanElementDialog.this.fResult.getParameters());
                            if (parameter != null) {
                                for (IAttributeDefinitionDescriptor attribute : PlanElementDialog.this.fEnumAttributes) {
                                    if (!attribute.getId().equals(parameter.getValue())) continue;
                                    PlanElementDialog.this.fCmbAttributes.setSelection((ISelection)new StructuredSelection((Object)attribute));
                                    break;
                                }
                            }
                            PlanElementDialog.this.fTxtName.setEditable(PlanElementDialog.this.fEdits.contains((Object)Edits.Name));
                            PlanElementDialog.this.fCmbAttributes.getControl().setEnabled(PlanElementDialog.this.fEdits.contains((Object)Edits.Attribute));
                        }
                    }
                }
            });
        }

        protected void setBusy(boolean busy) {
            if (busy) {
                this.fBusyCount.incrementAndGet();
            } else {
                this.fBusyCount.decrementAndGet();
            }
        }

        private class AttributeLoader
        extends FoundationJob {
            public AttributeLoader() {
                super(Messages.PlanConfigurationElementAspectEditor_MONITOR_RESOLVE_ATTR, (FoundationJobContext)new JobContext());
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                PlanElementDialog.this.setBusy(true);
                try {
                    IProjectAreaHandle projectArea = PlanElementDialog.this.this$0.getProjectArea();
                    List attributes = PlanElementDialog.this.this$0.findConfigurationElements(IAttributeDefinitionDescriptor.class, (IProgressMonitor)progress.newChild(1));
                    progress.beginTask(Messages.PlanConfigurationElementAspectEditor_MONITOR_CHECKING_ATTR, attributes.size());
                    IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)projectArea);
                    Iterator iter = attributes.iterator();
                    while (iter.hasNext()) {
                        IAttributeDefinitionDescriptor attribute = (IAttributeDefinitionDescriptor)iter.next();
                        Identifier identifier = PlanItemAttributes.getAttributeId((IAttributeDefinitionDescriptor)attribute);
                        if (identifier == null) {
                            iter.remove();
                            continue;
                        }
                        IAttribute resolvedAttribute = workItemClient.findAttribute(projectArea, identifier.getStringIdentifier(), (IProgressMonitor)progress.newChild(1));
                        if (resolvedAttribute != null && PublicAttributeHelper.isPublic((IAttribute)resolvedAttribute) && (AttributeTypes.isEnumerationAttributeType((String)resolvedAttribute.getAttributeType()) || "decimal".equals(resolvedAttribute.getAttributeType()) && PlanConfigurationElementAspectEditor.SORT_PROVIDER_IMPLEMENTATION.equals(PlanElementDialog.this.dialogImplementation) || "smallString".equals(resolvedAttribute.getAttributeType()) && PlanConfigurationElementAspectEditor.SORT_PROVIDER_IMPLEMENTATION.equals(PlanElementDialog.this.dialogImplementation))) continue;
                        iter.remove();
                    }
                    PlanElementDialog.this.fEnumAttributes.addAll(attributes);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    PlanElementDialog.this.setBusy(false);
                }
            }
        }

        private class JobContext
        extends FoundationJobContext {
            private JobContext() {
            }

            public void handleStatus(Job job, final IStatus status) {
                UI.asyncExec((Control)PlanElementDialog.this.fParent, new Runnable(){

                    @Override
                    public void run() {
                        PlanElementDialog.this.updateStatus(status);
                        PlanElementDialog.this.validateFields(false);
                    }
                });
            }
        }
    }

    private class RemovePlanElementAction<T extends IPlanConfigurationElement>
    extends EditPlanElementAction<T> {
        public RemovePlanElementAction(Class<T> type, Set<T> target, ISelectionProvider provider) {
            super(type, target, null, provider);
            this.setText(Messages.PlanConfigurationElementAspectEditor_DEL_LABEL);
            this.setImageDescriptor(ImagePool.REMOVE);
            this.setDisabledImageDescriptor(null);
        }

        @Override
        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            IStructuredSelection selection = (IStructuredSelection)this.fProvider.getSelection();
            IPlanConfigurationElement element = (IPlanConfigurationElement)selection.getFirstElement();
            return PlanConfigurationElementAspectEditor.this.fProcessSpecElements.contains(element);
        }

        @Override
        public void run() {
            IStructuredSelection selection = (IStructuredSelection)this.fProvider.getSelection();
            final IPlanConfigurationElement element = (IPlanConfigurationElement)selection.getFirstElement();
            if (MessageDialog.openConfirm((Shell)PlanConfigurationElementAspectEditor.this.fParent.getShell(), (String)this.getText(), (String)NLS.bind((String)Messages.PlanConfigurationElementAspectEditor_DEL_CONFIRMATION, (Object)element.getDisplayName(), (Object[])new Object[0]))) {
                TeamRunnable runnable = new TeamRunnable(){

                    @Override
                    protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                        final MultiStatus status = new MultiStatus(PlanningUIPlugin.getPluginId(), 0, Messages.PlanConfigurationElementAspectEditor_DEL_FAIL_SHORT, null);
                        ArrayList planModes = new ArrayList();
                        planModes.addAll(PlanConfigurationElementAspectEditor.this.findConfigurationElements(IPlanModeDescription.class, (IProgressMonitor)progress.newChild(1)));
                        progress.beginTask(Messages.PlanConfigurationElementAspectEditor_DEL_MONITOR_DEP_CHECK, planModes.size());
                        for (IPlanModeDescription planMode : planModes) {
                            if (!ConfigurationElements.references((Object)planMode, (Object)element)) continue;
                            status.add((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanConfigurationElementAspectEditor_DEL_FAIL_MSG_DETAIL, (Object)planMode.getDisplayName(), (Object[])new Object[]{element.getDisplayName()})));
                        }
                        final List unmodifiableInherited = StaticConfigurationDataRegistry.getInstance().getInstances(RemovePlanElementAction.this.fType);
                        UI.asyncExec((Control)PlanConfigurationElementAspectEditor.this.fParent, new Runnable(){

                            @Override
                            public void run() {
                                if (status.isOK()) {
                                    (this).RemovePlanElementAction.this.fTarget.remove(element);
                                    PlanConfigurationElementAspectEditor.this.fProcessSpecElements.remove(element);
                                    int index = unmodifiableInherited.indexOf(element);
                                    if (index != -1) {
                                        IPlanConfigurationElement inheritedElement = (IPlanConfigurationElement)unmodifiableInherited.get(index);
                                        (this).RemovePlanElementAction.this.fTarget.add(inheritedElement);
                                    }
                                    PlanConfigurationElementAspectEditor.this.update();
                                    PlanConfigurationElementAspectEditor.this.setDirty(true);
                                } else {
                                    MultiStatus displayStatus = status.getChildren().length > 1 ? status : status.getChildren()[0];
                                    ErrorDialog.openError((Shell)PlanConfigurationElementAspectEditor.this.fParent.getShell(), (String)RemovePlanElementAction.this.getText(), (String)Messages.PlanConfigurationElementAspectEditor_DEL_FAIL_MSG, (IStatus)displayStatus);
                                }
                            }
                        });
                    }
                };
                try {
                    PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException e) {
                    PlanningClientPlugin.log((Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private class ResolveJob
    extends FoundationJob {
        public ResolveJob() {
            super(Messages.PlanConfigurationElementAspectEditor_MONITOR_LOAD_ELEMENTS);
        }

        public boolean shouldSchedule() {
            return PlanConfigurationElementAspectEditor.this.isEnabled();
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            PlanConfigurationElementAspectEditor.this.busy(true);
            try {
                PlanConfigurationElementAspectEditor.this.fGroupModes.clear();
                PlanConfigurationElementAspectEditor.this.fSortModes.clear();
                PlanConfigurationElementAspectEditor.this.fFilters.clear();
                PlanConfigurationElementAspectEditor.this.fGroupModes.addAll(PlanConfigurationElementAspectEditor.this.findConfigurationElements(IGroupModeDescription.class, (IProgressMonitor)progress.newChild(1)));
                PlanConfigurationElementAspectEditor.this.fSortModes.addAll(PlanConfigurationElementAspectEditor.this.findConfigurationElements(ISortModeDescription.class, (IProgressMonitor)progress.newChild(1)));
                PlanConfigurationElementAspectEditor.this.fFilters.addAll(PlanConfigurationElementAspectEditor.this.findConfigurationElements(IFilterDescription.class, (IProgressMonitor)progress.newChild(1)));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                PlanConfigurationElementAspectEditor.this.busy(false);
            }
        }
    }

    private class ToolbarUpdater
    implements ISelectionChangedListener {
        private ToolBarManager fToolbar;

        public ToolbarUpdater(ToolBarManager toolbar) {
            this.fToolbar = toolbar;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = this.fToolbar.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update();
                ++n2;
            }
        }
    }
}

