/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.AbstractConfigurationDataAspectEditor;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.ProcessAspect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractProcessAspectEditor
extends AbstractConfigurationDataAspectEditor {
    protected static ModelElement findConfigurationElement(ModelElement parent, String name) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)name);
        List children = parent.getChildElements();
        for (ModelElement child : children) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        for (ModelElement child : children) {
            ModelElement candidate = AbstractProcessAspectEditor.findConfigurationElement(child, name);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    protected static Collection<ModelElement> findConfigurationElements(ModelElement parent, String name) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)name);
        ArrayList<ModelElement> result = new ArrayList<ModelElement>(16);
        List children = parent.getChildElements();
        for (ModelElement child : children) {
            if (!name.equals(child.getName())) continue;
            result.add(child);
        }
        for (ModelElement child : children) {
            result.addAll(AbstractProcessAspectEditor.findConfigurationElements(child, name));
        }
        return result;
    }

    protected AbstractProcessAspectEditor() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.doSetInput(inputAspect);
    }

    protected abstract void doSetInput(ProcessAspect var1);

    protected final ProcessAspect getInput() {
        return this.getAspect();
    }

    protected abstract void createContents(Composite var1);

    public final void createControl(Composite parent, FormToolkit toolkit) {
        Composite container = new Composite(parent, 0);
        parent.setLayout((Layout)new FillLayout());
        this.createContents(container);
        Dialog.applyDialogFont((Control)container);
    }

    public boolean needsApplyAndRevertButtons() {
        return false;
    }

    protected abstract String getOptionName();

    protected final boolean saveState(IMemento memento) {
        memento.putString("id", this.getAspect().getId());
        memento.putString("xmlns", this.getAspect().getSchemaNamespaceURI());
        this.doSaveState(memento);
        return true;
    }

    protected abstract void doSaveState(IMemento var1);

    public void dispose() {
    }
}

