/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.AddPlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.ConfigureDefaultWorkItemTypeAction;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.NoActionAvailable;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.widgets.QuickMenuAction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.common.model.IWorkItemType;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class WorkItemTypeSelectionAction
extends QuickMenuAction
implements ISelectionChangedListener {
    private IWorkbenchSite fSite;
    private PlanViewModel fViewModel;
    private IHandlerActivation fHandlerActivation;

    public WorkItemTypeSelectionAction(IWorkbenchSite site, PlanViewModel viewModel, String commandId) {
        super(commandId);
        this.fSite = site;
        this.fViewModel = viewModel;
    }

    @Override
    public void run() {
        IOutlineSettings settings = this.fViewModel.getViewer().getSettings();
        if (settings.getDefaultWorkItemType() == null) {
            super.run();
        } else {
            AddPlanItemAction.run(this.fSite, this.fViewModel, this.findType(settings.getDefaultWorkItemType()));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) {
            this.setEnabled(false);
        }
        this.setEnabled(this.checkEnabled(((IStructuredSelection)selection).getFirstElement()));
    }

    public void activate(IHandlerService service) {
        this.fHandlerActivation = service.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    public void deactivate(IHandlerService service) {
        if (this.fHandlerActivation != null) {
            service.deactivateHandler(this.fHandlerActivation);
        }
    }

    private boolean checkEnabled(Object selectedElement) {
        if (selectedElement instanceof IViewEntry) {
            selectedElement = ((IViewEntry)selectedElement).getElement();
        }
        return selectedElement instanceof PlanItem || selectedElement instanceof GroupElement;
    }

    @Override
    protected void fillMenu(IMenuManager menu) {
        List types = this.fViewModel.getInput().getWorkItemTypes();
        int created = 0;
        for (IWorkItemType type : types) {
            AddPlanItemAction action = new AddPlanItemAction(this.fSite, this.fViewModel, type);
            action.update();
            if (!action.isEnabled()) continue;
            menu.add((IAction)action);
            ++created;
        }
        if (created == 0) {
            menu.add((IAction)new NoActionAvailable(Messages.WorkItemTypeSelectionAction_NO_WORK_ITEM_TYPE_AVAILABLE));
        }
    }

    private IWorkItemType findType(String id) {
        List workItemTypes = this.fViewModel.getInput().getWorkItemTypes();
        for (IWorkItemType type : workItemTypes) {
            if (!id.equals(type.getIdentifier())) continue;
            return type;
        }
        return null;
    }

    public IMenuManager buildContextMenu(IMenuManager parent) {
        MenuManager result = new MenuManager(this.addShortcut(Messages.WorkItemTypeSelectionAction_LABEL));
        if (WorkItemTypeSelectionAction.fillContextMenu((IMenuManager)result, this.fSite, this.fViewModel) == 0) {
            return null;
        }
        WorkItemTypeSelectionAction.addConfigureAction((IMenuManager)result, this.fSite, this.fViewModel);
        return result;
    }

    public static int fillContextMenu(IMenuManager menu, IWorkbenchSite site, PlanViewModel viewModel) {
        IOutlineSettings settings = viewModel.getViewer().getSettings();
        List types = viewModel.getInput().getCreatableWorkItemTypes();
        int created = 0;
        for (IWorkItemType type : types) {
            AddPlanItemAction action = new AddPlanItemAction(site, viewModel, type);
            action.update();
            if (!action.isEnabled()) continue;
            menu.add((IAction)action);
            if (type.getIdentifier().equals(settings.getDefaultWorkItemType())) {
                action.setChecked(true);
            }
            ++created;
        }
        return created;
    }

    public static void addConfigureAction(IMenuManager menu, IWorkbenchSite site, PlanViewModel viewModel) {
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new ConfigureDefaultWorkItemTypeAction(site, viewModel));
    }
}

