/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class TagsTextField {
    private Text fText;
    private TagFetchingJob fFetchingJob;
    private Object[] fAllTags;
    private IProjectAreaHandle fProjectArea;
    private ControlDecoration fDecoration;

    public TagsTextField(Composite parent, IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
        this.fText = new Text(parent, 2048);
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        this.fDecoration = new ControlDecoration((Control)this.fText, 16512);
        FieldDecoration contentAssistDecoration = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
        this.fDecoration.setImage(contentAssistDecoration.getImage());
        this.fDecoration.setDescriptionText(contentAssistDecoration.getDescription());
        this.fDecoration.show();
        this.fFetchingJob = new TagFetchingJob(Messages.TagsTextField_JOB_FETCH_TAGS);
        this.fFetchingJob.schedule();
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.fText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TagContentProposalProvider(), keyStroke, new char[]{'*'});
        adapter.setProposalAcceptanceStyle(3);
        adapter.setPropagateKeys(true);
        adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (proposal instanceof TagContentProposal) {
                    TagContentProposal prop = (TagContentProposal)proposal;
                    String text = TagsTextField.this.fText.getText();
                    String result = prop.getBegin() > text.length() ? String.valueOf(text) + ", " + prop.getLabel() : String.valueOf(text.substring(0, prop.getBegin())) + prop.getLabel() + ", " + text.substring(prop.getEnd());
                    result = TagsAttributeType.normalizeTags((String)result);
                    int pos = result.indexOf(prop.getLabel().toLowerCase()) + prop.getLabel().length() + 1;
                    TagsTextField.this.fText.setText(result);
                    TagsTextField.this.fText.setSelection(pos, pos);
                }
            }
        });
    }

    public Text getTextField() {
        return this.fText;
    }

    public String getTags() {
        return this.fText.getText();
    }

    public boolean isKnownTag(String tag) {
        if (this.fAllTags == null) {
            return true;
        }
        Object[] objectArray = this.fAllTags;
        int n = this.fAllTags.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (tag.equals(element.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class TagContentProposal
    implements IContentProposal {
        private String fTag;
        private int fBegin;
        private int fEnd;

        public TagContentProposal(String tag, int begin, int end) {
            this.fTag = tag;
            this.fBegin = begin;
            this.fEnd = end;
        }

        public String getContent() {
            return this.fTag;
        }

        public String getLabel() {
            return this.fTag;
        }

        public String getDescription() {
            return null;
        }

        public int getCursorPosition() {
            return (this.fBegin == this.fEnd ? this.fBegin + 1 : this.fBegin) + this.fTag.length();
        }

        public int getBegin() {
            return this.fBegin;
        }

        public int getEnd() {
            return this.fEnd;
        }
    }

    private class TagContentProposalProvider
    implements IContentProposalProvider {
        private TagContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            int beginOfWord = 0;
            int i = position - 1;
            while (i >= 0) {
                if (contents.charAt(i) == ',' || contents.charAt(i) == ' ') {
                    beginOfWord = i + 1 < contents.length() ? i + 1 : i;
                    break;
                }
                --i;
            }
            int endOfWord = contents.length();
            if (position == 0) {
                endOfWord = 0;
            } else {
                int i2 = position - 1;
                while (i2 < contents.length()) {
                    if (contents.charAt(i2) == ',' || contents.charAt(i2) == ' ') {
                        endOfWord = i2;
                        break;
                    }
                    ++i2;
                }
            }
            String word = contents.substring(beginOfWord, position);
            if (word.equals(" ") || word.equals(",")) {
                word = "";
                ++beginOfWord;
                ++endOfWord;
            }
            ArrayList<TagContentProposal> proposals = new ArrayList<TagContentProposal>();
            WildcardMatcher matcher = new WildcardMatcher(String.valueOf(word) + '*');
            if (TagsTextField.this.fAllTags == null && TagsTextField.this.fFetchingJob.getState() != 4) {
                TagsTextField.this.fFetchingJob.schedule();
            }
            int t = 0;
            try {
                while (TagsTextField.this.fAllTags == null && t < 2000) {
                    Thread.sleep(100L);
                    t += 100;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (TagsTextField.this.fAllTags != null && TagsTextField.this.fAllTags.length > 0) {
                Object[] objectArray = TagsTextField.this.fAllTags;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String tag = element.toString();
                    if (matcher.match(tag)) {
                        proposals.add(new TagContentProposal(tag, beginOfWord, endOfWord));
                    }
                    ++n2;
                }
                Collections.sort(proposals, new Comparator<TagContentProposal>(){
                    Collator collator = CollatorCache.getInstance();

                    @Override
                    public int compare(TagContentProposal o1, TagContentProposal o2) {
                        return this.collator.compare(o1.getLabel(), o2.getLabel());
                    }
                });
                return proposals.toArray(new TagContentProposal[proposals.size()]);
            }
            String msg = Messages.TagsTextField_NO_PROPOSALS_AVAILABLE;
            if (TagsTextField.this.fAllTags == null) {
                msg = Messages.TagsTextField_FAILED_TO_RETRIEVE_PROPOSALS;
            }
            final String message = msg;
            return new IContentProposal[]{new IContentProposal(){

                public String getContent() {
                    return null;
                }

                public int getCursorPosition() {
                    return 0;
                }

                public String getDescription() {
                    return null;
                }

                public String getLabel() {
                    return message;
                }
            }};
        }
    }

    private class TagFetchingJob
    extends FoundationJob {
        public TagFetchingJob(String name) {
            super(name);
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            if (TagsTextField.this.fProjectArea == null) {
                return Status.CANCEL_STATUS;
            }
            ITeamRepository repository = (ITeamRepository)TagsTextField.this.fProjectArea.getOrigin();
            try {
                TagsTextField.this.fAllTags = ((IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class)).findTags(TagsTextField.this.fProjectArea, monitor).toArray();
            }
            catch (TeamRepositoryException e) {
                PlanningUIPlugin.log("Error retrieving tags valueset", e);
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

