/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.IProgressService;

public class ShowWorkItemInPlanAction
implements IObjectActionDelegate {
    private IWorkbenchPart fWorkbenchPart;
    private IWorkItem fWorkItem;

    public void run(IAction action) {
        if (this.fWorkbenchPart == null) {
            PlanningUIPlugin.log((IStatus)new Status(2, PlanningUIPlugin.getPluginId(), String.format("%s.run() - active workbench part is missing%n", this.getClass())));
            action.setEnabled(false);
            return;
        }
        IProgressService service = UI.getProgressService(this.fWorkbenchPart);
        TeamRunnable runnable = new TeamRunnable(){

            @Override
            protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)ShowWorkItemInPlanAction.this.fWorkItem);
                IIterationHandle target = ShowWorkItemInPlanAction.this.fWorkItem.getTarget();
                IProcessAreaHandle processArea = workItemClient.findProcessArea((IWorkItemHandle)ShowWorkItemInPlanAction.this.fWorkItem, (IProgressMonitor)progress.newChild(1));
                if (target != null && processArea != null) {
                    PlanningUIPlugin.openIterationPlanEditor(processArea, target, ShowWorkItemInPlanAction.this.fWorkbenchPart.getSite().getPage());
                }
                monitor.done();
            }
        };
        try {
            service.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        catch (InterruptedException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fWorkbenchPart = targetPart;
        action.setEnabled(this.fWorkbenchPart != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.fWorkItem = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IWorkItem) {
            this.fWorkItem = (IWorkItem)element;
        }
        if (action != null) {
            action.setEnabled(this.fWorkItem != null && this.fWorkItem.isPropertySet(IWorkItem.TARGET_PROPERTY) && this.fWorkItem.getTarget() != null);
        }
    }
}

