/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

public class RecentlyUsedTagsManager
implements IRecentlyUsedTagsRegistry {
    private static final String TAG_LIST_PREFERENCE = "recentlyUsedTags";
    private static final int MAX_LRU_ENTRIES = 3;
    private LinkedList<String> fTags = new LinkedList();

    public RecentlyUsedTagsManager() {
        this.loadList(PlanningUIPlugin.getDefault().getPreferenceStore());
    }

    public void dispose() {
        this.storeList(PlanningUIPlugin.getDefault().getPreferenceStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTags(int maxTags) {
        LinkedList<String> linkedList = this.fTags;
        synchronized (linkedList) {
            return new ArrayList<String>(this.fTags.subList(0, Math.min(maxTags, this.fTags.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRecentlyUsedTag(String tag) {
        LinkedList<String> linkedList = this.fTags;
        synchronized (linkedList) {
            if (!this.fTags.remove(tag)) {
                while (this.fTags.size() >= 3) {
                    this.fTags.removeLast();
                }
            }
            this.fTags.addFirst(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadList(IPreferenceStore preferenceStore) {
        LinkedList<String> linkedList = this.fTags;
        synchronized (linkedList) {
            String tagListString = preferenceStore.getString(TAG_LIST_PREFERENCE);
            if (tagListString != null) {
                this.fTags.clear();
                this.fTags.addAll(Tags.parseTags((String)tagListString));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeList(IPreferenceStore preferenceStore) {
        LinkedList<String> linkedList = this.fTags;
        synchronized (linkedList) {
            preferenceStore.setValue(TAG_LIST_PREFERENCE, Tags.printTags(this.fTags));
        }
    }
}

