/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public abstract class PlanViewModelAction<T>
extends Action
implements ISelectionChangedListener {
    protected static final LengthMode NONE = new LengthMode("none");
    protected static final LengthMode NONE_OR_ONE = new LengthMode("None or one");
    protected static final LengthMode ONE = new LengthMode("One");
    protected static final LengthMode ONE_OR_MORE = new LengthMode("One or more");
    protected static final LengthMode ANY_NUMBER = new LengthMode("Any number");
    private final IWorkbenchSite fSite;
    private final PlanViewModel fViewModel;
    private Class<T> fType;
    private LengthMode fLengthMode;

    protected PlanViewModelAction(IWorkbenchSite site, PlanViewModel viewModel, Class<T> type, LengthMode mode) {
        this.fSite = site;
        this.fViewModel = viewModel;
        this.fType = type;
        this.fLengthMode = mode;
    }

    protected PlanViewModel getPlanViewModel() {
        return this.fViewModel;
    }

    public void update() {
        this.selectionChanged(this.getSelectedEntries());
    }

    public Shell getShell() {
        return this.fViewModel.getViewer().getOutline().getShell();
    }

    public IWorkbenchSite getSite() {
        return this.fSite;
    }

    public abstract void run(Collection<IViewEntry<T>> var1);

    protected boolean checkElement(IViewEntry<T> selectedEntry) {
        return true;
    }

    protected boolean checkSelection(Collection<IViewEntry<T>> selectedEntries) {
        return true;
    }

    protected void updateAction(Collection<IViewEntry<T>> selectedEntries) {
    }

    public final void run() {
        this.run(this.castSelection(this.getSelectedEntries()));
    }

    protected Collection<IViewEntry<?>> getSelectedEntries() {
        return this.fViewModel != null ? this.fViewModel.getSelectedEntries() : Collections.EMPTY_LIST;
    }

    private Collection<IViewEntry<T>> castSelection(Collection<IViewEntry<?>> selectedEntries) {
        Collection<IViewEntry<T>> toCast = selectedEntries;
        return toCast;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    private void selectionChanged(Collection<IViewEntry<?>> selectedEntries) {
        boolean enabled = this.checkEnabled(selectedEntries);
        if (enabled) {
            Collection<IViewEntry<T>> castedSelection = this.castSelection(selectedEntries);
            enabled = this.checkSelection(castedSelection);
            this.updateAction(castedSelection);
        }
        this.setEnabled(enabled);
    }

    private boolean checkEnabled(Collection<IViewEntry<?>> selectedEntries) {
        if (!this.checkSize(selectedEntries.size())) {
            return false;
        }
        for (IViewEntry<?> selectedEntry : selectedEntries) {
            if (this.fType != null && !this.fType.isInstance(selectedEntry.getElement())) {
                return false;
            }
            if (!selectedEntry.isVisible()) {
                return false;
            }
            if (this.checkElement(selectedEntry)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSize(int size) {
        if (NONE == this.fLengthMode) {
            return size == 0;
        }
        if (NONE_OR_ONE == this.fLengthMode) {
            return size == 0 || size == 1;
        }
        if (ONE == this.fLengthMode) {
            return size == 1;
        }
        if (ONE_OR_MORE == this.fLengthMode) {
            return size >= 1;
        }
        return true;
    }

    protected static class LengthMode {
        private String fMode;

        public LengthMode(String mode) {
            this.fMode = mode;
        }

        public String toString() {
            return this.fMode;
        }
    }
}

