/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ReferenceAttribute;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.CustomMarkerTag;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.OutlinePage;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanViewModel;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class LinkTypeColorizeAction
extends IterationPlanEditor.PlanAction
implements IPropertyChangeListener {
    private Map<ReferenceAttribute, ReferenceColorizer> fRegistry = new HashMap<ReferenceAttribute, ReferenceColorizer>();
    private IMenuCreator fMenuCreator;
    private List<Action> fActions;
    private Set<String> fActionCheckedState = new HashSet<String>();
    private ImageDescriptor fNormalImage = ImagePool.LINKS_COLORIZE_ENABLED;
    private ImageDescriptor fActiveImage;

    public LinkTypeColorizeAction(IterationPlanEditor editor) {
        super(editor, 4, OutlinePage.class);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.ITERATION_UPDATED;
        this.fActiveImage = new OverlayIcon(ImagePool.LINKS_COLORIZE_ENABLED, imageDescriptorArray, new Point(16, 16), 132096);
        this.setText(Messages.LinkTypeColorizeAction_LABEL);
        this.setToolTipText(Messages.LinkTypeColorizeAction_TOOL_TIP);
        this.setImageDescriptor(this.fActiveImage);
        this.addPropertyChangeListener(this);
    }

    protected Boolean preferences(String name, Boolean value) {
        IPreferenceStore store = PlanningUIPlugin.getDefault().getPreferenceStore();
        if (value == null) {
            return store.getBoolean(name);
        }
        store.putValue(name, String.valueOf(value));
        return value;
    }

    @Override
    protected boolean updateEnabled() {
        IterationPlanViewModel model = this.fEditor.getOutlinePage().getViewModel();
        return model != null && model.getInput() != null;
    }

    private List<Action> getActions() {
        if (this.fActions == null) {
            this.fActions = new ArrayList<Action>();
            Iterator iter = this.getPlanViewModel().getInput().getAttributeRegistry().getAttributes(ReferenceAttribute.class).iterator();
            while (iter.hasNext()) {
                this.fActions.add(new LinkTypeAction((ReferenceAttribute)iter.next()));
            }
        }
        return this.fActions;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block3: {
            iter = this.getActions().iterator();
            if (this.fActionCheckedState.isEmpty()) ** GOTO lbl15
            while (iter.hasNext()) {
                action = iter.next();
                if (!this.fActionCheckedState.contains(LinkTypeAction.access$0((LinkTypeAction)action).getId())) continue;
                action.setChecked(true);
            }
            this.fActionCheckedState.clear();
            break block3;
lbl-1000:
            // 1 sources

            {
                action = iter.next();
                if (action.isChecked()) {
                    this.fActionCheckedState.add(LinkTypeAction.access$0((LinkTypeAction)action).getId());
                }
                action.setChecked(false);
lbl15:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
        this.setImageDescriptor(this.fActionCheckedState.isEmpty() != false ? this.fActiveImage : this.fNormalImage);
    }

    public IMenuCreator getMenuCreator() {
        if (this.fMenuCreator == null) {
            final MenuManager mgr = new MenuManager();
            Iterator<Action> iter = this.getActions().iterator();
            while (iter.hasNext()) {
                mgr.add((IAction)iter.next());
            }
            this.fMenuCreator = new IMenuCreator(){

                public Menu getMenu(Control parent) {
                    return mgr.createContextMenu(parent);
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public void dispose() {
                    mgr.dispose();
                }
            };
        }
        return this.fMenuCreator;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().equals("enabled")) {
            return;
        }
        if (this.isEnabled()) {
            this.getActions();
        }
    }

    protected PlanViewModel getPlanViewModel() {
        return this.fEditor.getOutlinePage().getViewModel();
    }

    protected IViewEntry<PlanItem> getSelectedPlanItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fEditor.getOutlinePage().getViewModel().getViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        IViewEntry entry = (IViewEntry)selection.getFirstElement();
        if (!EntryUtils.isType(entry, PlanItem.class)) {
            return null;
        }
        return entry;
    }

    public class LinkTypeAction
    extends Action
    implements IPropertyChangeListener {
        private ReferenceAttribute fAttribute;
        private final String fPrefKey;

        public LinkTypeAction(ReferenceAttribute attribute) {
            super(null, 2);
            this.fAttribute = attribute;
            this.fPrefKey = String.valueOf(LinkTypeColorizeAction.class.getName()) + this.fAttribute.getId();
            ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(this.fAttribute.getLinkType());
            IEndPointDescriptor endPoint = this.fAttribute.isSource() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
            this.setText(endPoint.getDisplayName());
            this.setImageDescriptor(ImageDescriptor.createFromURL((URL)endPoint.getIcon()));
            ReferenceColorizer colorizer = new ReferenceColorizer(this.fAttribute);
            LinkTypeColorizeAction.this.fRegistry.put(this.fAttribute, colorizer);
            if (LinkTypeColorizeAction.this.preferences(this.fPrefKey, null).booleanValue()) {
                colorizer.install();
                this.setChecked(true);
            }
            this.addPropertyChangeListener(this);
        }

        public boolean isEnabled() {
            return LinkTypeColorizeAction.this.fRegistry.containsKey(this.fAttribute);
        }

        public void run() {
            LinkTypeColorizeAction.this.preferences(this.fPrefKey, this.isChecked());
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().equals("checked")) {
                return;
            }
            if (this.isChecked()) {
                ((ReferenceColorizer)LinkTypeColorizeAction.this.fRegistry.get(this.fAttribute)).install();
            } else {
                ((ReferenceColorizer)LinkTypeColorizeAction.this.fRegistry.get(this.fAttribute)).uninstall();
            }
        }

        static /* synthetic */ ReferenceAttribute access$0(LinkTypeAction linkTypeAction) {
            return linkTypeAction.fAttribute;
        }
    }

    private class ReferenceColorizer
    implements ISelectionChangedListener,
    IPlanElementListener {
        private ReferenceAttribute fAttribute;
        private boolean fInstalled = false;
        private int fTokenPool = 0;

        public ReferenceColorizer(ReferenceAttribute attribute) {
            this.fAttribute = attribute;
        }

        public boolean isInstalled() {
            return this.fInstalled;
        }

        public void install() {
            if (this.fInstalled) {
                return;
            }
            this.updateTags(false);
            LinkTypeColorizeAction.this.getPlanViewModel().getViewer().addSelectionChangedListener(this);
            this.fInstalled = true;
        }

        public void uninstall() {
            if (!this.fInstalled) {
                return;
            }
            LinkTypeColorizeAction.this.getPlanViewModel().getViewer().removeSelectionChangedListener(this);
            this.updateTags(true);
            this.fInstalled = false;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.updateTags(true);
            Display display = LinkTypeColorizeAction.this.getPlanViewModel().getViewer().getControl().getDisplay();
            final long token = this.fTokenPool++;
            display.timerExec(300, new Runnable(){

                @Override
                public void run() {
                    if (token + 1L == (long)ReferenceColorizer.this.fTokenPool) {
                        ReferenceColorizer.this.updateTags(false);
                    }
                }
            });
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            IPlanAttributeDelta delta = event.getDelta().getAttributeDelta((IPlanningAttributeIdentifier)this.fAttribute);
            if (delta == null) {
                return;
            }
            this.updateTags(false);
        }

        protected void updateTags(final boolean clearOnly) {
            IViewModelUpdateFunction<Void, RuntimeException> runnable = new IViewModelUpdateFunction<Void, RuntimeException>(){

                public Void run(final IViewModelUpdater updateAccessor) throws RuntimeException {
                    updateAccessor.accept(new IViewEntryVisitor(){

                        public boolean visit(IViewEntry<?> entry) {
                            List tags = entry.getTags(ReferenceTag.class);
                            for (ReferenceTag tag : tags) {
                                if (!tag.getAttribute().equals((Object)ReferenceColorizer.this.fAttribute)) continue;
                                updateAccessor.clearTag(entry, (IViewEntryTag)tag);
                            }
                            return true;
                        }
                    }, null);
                    if (clearOnly) {
                        return null;
                    }
                    final IViewEntry<PlanItem> planItemEntry = LinkTypeColorizeAction.this.getSelectedPlanItem();
                    if (planItemEntry == null) {
                        return null;
                    }
                    List references = ReferenceColorizer.this.fAttribute.getValue((PlanItem)planItemEntry.getElement());
                    final ArrayList<UUID> itemIds = new ArrayList<UUID>(references.size());
                    for (IReference reference : references) {
                        if (!reference.isItemReference()) continue;
                        itemIds.add(((IItemReference)reference).getReferencedItem().getItemId());
                    }
                    final ArrayList referencedItems = new ArrayList();
                    updateAccessor.accept(new IViewEntryVisitor(){

                        public boolean visit(IViewEntry<?> entry) {
                            UUID itemId;
                            Object element = entry.getElement();
                            if (element instanceof PlanItem && itemIds.remove(itemId = ((PlanItem)element).getWorkItemId())) {
                                updateAccessor.setTag(entry, (IViewEntryTag)new ReferenceTargetTag(ReferenceColorizer.this.fAttribute, (PlanItem)planItemEntry.getElement()));
                                referencedItems.add((PlanItem)element);
                            }
                            return !itemIds.isEmpty();
                        }
                    }, null);
                    if (!references.isEmpty() && itemIds.isEmpty()) {
                        updateAccessor.setTag(planItemEntry, (IViewEntryTag)new ReferenceSourceTag(ReferenceColorizer.this.fAttribute, referencedItems));
                    }
                    return null;
                }
            };
            IDeferredResolver<Void> resolver = new IDeferredResolver<Void>(){

                public Void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    ResolvedPlan plan = LinkTypeColorizeAction.this.getPlanViewModel().getInput();
                    plan.prepare((PlanElement)plan, Collections.singleton(ReferenceColorizer.this.fAttribute), monitor);
                    return null;
                }
            };
            IDeferredResolveListener<Void> resolveListener = new IDeferredResolveListener<Void>((IViewModelUpdateFunction)runnable){
                private final /* synthetic */ IViewModelUpdateFunction val$runnable;
                {
                    this.val$runnable = iViewModelUpdateFunction;
                }

                public void resolved(Void result) {
                    UI.asyncExec(LinkTypeColorizeAction.this.getPlanViewModel().getViewer().getControl(), new Runnable(){

                        @Override
                        public void run() {
                            LinkTypeColorizeAction.this.getPlanViewModel().updateModel(val$runnable);
                        }
                    });
                }

                public void failed(IStatus state) {
                    PlanningClientPlugin.log((IStatus)state);
                    ReferenceColorizer.this.uninstall();
                }

                public void canceled() {
                }
            };
            if (!LinkTypeColorizeAction.this.getPlanViewModel().getInput().isPrepared(Collections.singleton(this.fAttribute))) {
                LinkTypeColorizeAction.this.fEditor.deferredResolve(resolver, resolveListener, false);
            } else {
                resolveListener.resolved(null);
            }
        }
    }

    public class ReferenceSourceTag
    extends ReferenceTag {
        public ReferenceSourceTag(ReferenceAttribute attribute, Collection<? extends PlanElement> elements) {
            super(attribute, elements);
        }

        @Override
        protected IEndPointDescriptor getEndPointDescriptor() {
            ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(this.fAttribute.getLinkType());
            IEndPointDescriptor endPoint = this.fAttribute.isSource() ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor();
            return endPoint;
        }
    }

    public abstract class ReferenceTag
    extends CustomMarkerTag {
        protected final ReferenceAttribute fAttribute;
        private final Collection<? extends PlanElement> fElements;

        public ReferenceTag(ReferenceAttribute attribute, Collection<? extends PlanElement> elements) {
            super(new Object(), Severity.INFO, "");
            this.fAttribute = attribute;
            this.fElements = elements;
        }

        public ReferenceAttribute getAttribute() {
            return this.fAttribute;
        }

        public ImageDescriptor getImage() {
            try {
                URL url = JazzResources.createImageURL((URL)this.getEndPointDescriptor().getIcon());
                ImageDescriptor result = ImageDescriptor.createFromURL((URL)url);
                JazzResources.registerUrl((ImageDescriptor)result, (URL)url);
                return result;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public String getMessage() {
            if (this.fElements.isEmpty()) {
                return "";
            }
            IPlanningAttribute attribute = this.fElements.iterator().next().getPlan().findAttribute(PlanItem.SUMMARY);
            if (attribute == null) {
                return "";
            }
            HashSet<String> summaries = new HashSet<String>();
            for (PlanElement planElement : this.fElements) {
                if (!attribute.isDefined((Object)planElement)) continue;
                Object value = attribute.getValue((Object)planElement);
                summaries.add(String.valueOf(value));
            }
            Html.Writer writer = new Html.Writer();
            writer.img(JazzResources.createURL((ImageDescriptor)this.getImage()).toString());
            writer.open(Html.BOLD).text((CharSequence)NLS.bind((String)Messages.LinkTypeColorizeAction_ENDPOINT_LABEL_PATTERN, (Object)this.getEndPointDescriptor().getDisplayName(), (Object[])new Object[]{summaries.size()})).close();
            writer.open(Html.BR);
            writer.open(Html.OL).many(Html.LI, summaries).close();
            return writer.toString();
        }

        protected abstract IEndPointDescriptor getEndPointDescriptor();
    }

    public class ReferenceTargetTag
    extends ReferenceTag {
        public ReferenceTargetTag(ReferenceAttribute attribute, PlanItem planItem) {
            super(attribute, Collections.singleton(planItem));
        }

        @Override
        protected IEndPointDescriptor getEndPointDescriptor() {
            ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(this.fAttribute.getLinkType());
            IEndPointDescriptor endPoint = this.fAttribute.isSource() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
            return endPoint;
        }
    }
}

