/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.progress.UIJob;

public class DeferredContributionItem
extends ContributionItem {
    private UIJob fRunAfter;
    private Job fRunBefore;
    private MenuItem fMenuItem;
    private boolean fNeedsPending;

    public DeferredContributionItem(Job runBefore, UIJob runAfter) {
        Assert.isNotNull((Object)runAfter);
        Assert.isNotNull((Object)runBefore);
        Assert.isTrue((runBefore.getState() == 0 ? 1 : 0) != 0);
        this.fRunAfter = runAfter;
        this.fRunBefore = runBefore;
        if (this.fRunBefore.shouldSchedule()) {
            this.fNeedsPending = true;
            this.fRunBefore.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    DeferredContributionItem.this.fNeedsPending = false;
                    DeferredContributionItem.this.update();
                }
            });
            this.fRunBefore.schedule();
        } else {
            this.fNeedsPending = false;
            this.update();
        }
    }

    public void fill(Menu menu, int index) {
        if (!this.fNeedsPending) {
            return;
        }
        this.fMenuItem = new MenuItem(menu, 0);
        this.fMenuItem.setEnabled(false);
        this.fMenuItem.setText(Messages.DeferredContributionItem_MESSAGE_PENDING);
    }

    public void fill(Composite parent) {
        throw new UnsupportedOperationException();
    }

    public void fill(CoolBar parent, int index) {
        throw new UnsupportedOperationException();
    }

    public void fill(ToolBar parent, int index) {
        throw new UnsupportedOperationException();
    }

    public void update() {
        this.fRunAfter.schedule();
        this.fRunAfter.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UI.syncExec(DeferredContributionItem.this.fRunAfter.getDisplay(), new Runnable(){

                    @Override
                    public void run() {
                        IContributionManager parent;
                        if (DeferredContributionItem.this.fMenuItem != null) {
                            DeferredContributionItem.this.fMenuItem.dispose();
                            DeferredContributionItem.this.fMenuItem = null;
                        }
                        if ((parent = DeferredContributionItem.this.getParent()) != null) {
                            DeferredContributionItem.this.getParent().update(true);
                        }
                    }
                });
            }
        });
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return this.fRunBefore == null;
    }
}

