/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.ITimeSheetEntryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.ListDialog;

public class ContinueWorkMenuAction
extends PlanViewModelAction<PlanItem> {
    private MenuManager fMenuMgr;

    public ContinueWorkMenuAction(IWorkbenchSite site, PlanViewModel viewModel) {
        super(site, viewModel, PlanItem.class, ONE_OR_MORE);
        this.setText(Messages.ContinueWorkAction_LABEL);
    }

    @Override
    public void run(Collection<IViewEntry<PlanItem>> selectedEntries) {
    }

    @Override
    protected boolean checkSelection(Collection<IViewEntry<PlanItem>> selectedEntries) {
        if (selectedEntries.isEmpty()) {
            return false;
        }
        for (IViewEntry<PlanItem> entry : selectedEntries) {
            if (!((PlanItem)entry.getElement()).isResolved() && !((PlanItem)entry.getElement()).isTopLevelPlanItem()) continue;
            return false;
        }
        return true;
    }

    public MenuManager getMenuManager() {
        if (this.fMenuMgr == null) {
            this.fMenuMgr = new MenuManager(this.getText());
            this.fMenuMgr.setRemoveAllWhenShown(true);
            this.fMenuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    block5: {
                        ResolvedIterationPlan input;
                        HashSet<UUID> ids;
                        ResolvedPlan plan;
                        ItemArrayList selectedWorkItems;
                        block4: {
                            Collection<IViewEntry<?>> entries = ContinueWorkMenuAction.this.getSelectedEntries();
                            selectedWorkItems = new ItemArrayList();
                            for (IViewEntry<?> entry : entries) {
                                Object element = entry.getElement();
                                if (!(element instanceof PlanItem)) continue;
                                selectedWorkItems.add((Object)((PlanItem)element).getWorkItem(true));
                            }
                            plan = ContinueWorkMenuAction.this.getPlanViewModel().getInput();
                            ids = new HashSet<UUID>();
                            if (!(plan instanceof ResolvedIterationPlan)) break block4;
                            input = (ResolvedIterationPlan)plan;
                            ids.add(input.getInterval().getItemId());
                            Iterator iter = input.getContextIterations().depthFirstIterator();
                            while (iter.hasNext()) {
                                Node next = (Node)iter.next();
                                if (next.getElement() == null || ids.contains(((IIteration)next.getElement()).getItemId())) continue;
                                ids.add(((IIteration)next.getElement()).getItemId());
                                ContinueWorkMenuAction.this.fMenuMgr.add((IAction)new ContinueWorkAction(ContinueWorkMenuAction.this.getSite(), (IIteration)next.getElement(), (ItemList<IWorkItem>)selectedWorkItems));
                            }
                            break block5;
                        }
                        if (!(plan instanceof ResolvedPersonalPlan)) break block5;
                        input = (ResolvedPersonalPlan)plan;
                        for (IIteration next : input.getPlannedIterations()) {
                            if (next == null) continue;
                            ids.add(next.getItemId());
                        }
                        for (IIteration next : input.getIntervals()) {
                            if (next == null || ids.contains(next.getItemId())) continue;
                            ids.add(next.getItemId());
                            ContinueWorkMenuAction.this.fMenuMgr.add((IAction)new ContinueWorkAction(ContinueWorkMenuAction.this.getSite(), next, (ItemList<IWorkItem>)selectedWorkItems));
                        }
                    }
                }
            });
        }
        return this.fMenuMgr;
    }

    public static class ContinueWorkAction
    extends Action {
        private final IWorkbenchSite fSite;
        private final IIteration fIteration;
        private final ItemList<IWorkItem> fWorkItems;
        private final StandardLabelProvider fLabelProvider;

        public ContinueWorkAction(IWorkbenchSite site, IIteration iteration, ItemList<IWorkItem> workItems) {
            super(iteration.getLabel(), 1);
            this.fSite = site;
            this.fLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
            this.fIteration = iteration;
            this.fWorkItems = workItems;
        }

        public void run() {
            ItemArrayList noTimeSpentWorkItems = new ItemArrayList();
            for (IWorkItem workItem : this.fWorkItems) {
                if (WorkItems.getTimeSpent((IWorkItem)workItem) != -1L) continue;
                noTimeSpentWorkItems.add((Object)workItem);
            }
            if (!noTimeSpentWorkItems.isEmpty()) {
                int REPLAN = 1024;
                int CONTINUE = 2048;
                ListDialog dialog = new ListDialog(this.fSite.getShell()){

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 1024 || buttonId == 2048) {
                            this.setReturnCode(buttonId);
                        } else {
                            super.buttonPressed(buttonId);
                        }
                    }

                    protected void setReturnCode(int code) {
                        if (code != 0) {
                            super.setReturnCode(code);
                        }
                    }

                    protected Control createDialogArea(Composite container) {
                        Composite result = (Composite)super.createDialogArea(container);
                        new Label(result, 0).setText(Messages.ContinueWorkAction_CHOISE);
                        this.createButton(result, 1024, NLS.bind((String)Messages.ContinueWorkAction_CHOISE_REPLAN, (Object)fIteration.getLabel(), (Object[])new Object[0]), 16, true);
                        this.createButton(result, 2048, Messages.ContinueWorkAction_CHOISE_CONTINUE, 16, false);
                        return result;
                    }

                    protected Button createButton(Composite parent, int id, String label, int style, boolean selected) {
                        Button button = new Button(parent, style);
                        button.setText(label);
                        button.setFont(JFaceResources.getDialogFont());
                        button.setSelection(selected);
                        button.setData((Object)new Integer(id));
                        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                this.buttonPressed((Integer)event.widget.getData());
                            }
                        });
                        if (selected) {
                            this.setReturnCode(id);
                        }
                        return button;
                    }
                };
                dialog.setTitle(Messages.ContinueWorkAction_CONFIRMATION_TITLE);
                dialog.setMessage(NLS.bind((String)Messages.ContinueWorkAction_CONFIRMATION_TEXT, (Object)this.fIteration.getLabel(), (Object[])new Object[0]));
                dialog.setLabelProvider((ILabelProvider)this.fLabelProvider);
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setInput((Object)noTimeSpentWorkItems.toArray());
                int result = dialog.open();
                if (result == 1) {
                    return;
                }
                if (result == 2048) {
                    noTimeSpentWorkItems.clear();
                }
            }
            FoundationJobContext context = new FoundationJobContext(){

                public void handleStatus(Job job, IStatus status) {
                    Throwable exception = status.getException();
                    if (exception instanceof TeamOperationCanceledException) {
                        return;
                    }
                    super.handleStatus(job, status);
                }
            };
            new FoundationJob(Messages.ContinueWorkAction_CONFIRMATION_TITLE, context, (ItemList)noTimeSpentWorkItems){
                private final /* synthetic */ ItemList val$noTimeSpentWorkItems;
                {
                    this.val$noTimeSpentWorkItems = itemList;
                    super($anonymous0, $anonymous1);
                }

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    return this.execute((ItemList<IWorkItem>)this.val$noTimeSpentWorkItems, monitor);
                }
            }.schedule();
        }

        public IStatus execute(ItemList<IWorkItem> noTimeSpentWorkItems, IProgressMonitor monitor) throws TeamRepositoryException, MultiStaleDataException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
            IProjectAreaHandle projectArea = ((IWorkItem)this.fWorkItems.get(0)).getProjectArea();
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)((IItemHandle)this.fWorkItems.get(0)));
            IWorkItemWorkingCopyManager copyManager = workItemClient.getWorkItemWorkingCopyManager();
            ArrayList<WorkItemWorkingCopy> workingCopies = new ArrayList<WorkItemWorkingCopy>();
            IAttribute estimate = workItemClient.findAttribute(projectArea, IWorkItem.DURATION_PROPERTY, (IProgressMonitor)progress.newChild(1));
            IAttribute correctedEstimate = workItemClient.findAttribute(projectArea, WorkItem.CORRECTED_ESTIMATE_PROPERTY, (IProgressMonitor)progress.newChild(1));
            IAttribute timeSpent = workItemClient.findAttribute(projectArea, WorkItem.TIME_SPENT_PROPERTY, (IProgressMonitor)progress.newChild(1));
            ItemHashMap workItemToPrequel = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
            for (IWorkItem workItem : this.fWorkItems) {
                IWorkflowInfo workflowInfo = workItemClient.findWorkflowInfo(workItem, (IProgressMonitor)progress.newChild(1));
                PlanDuration planDuration = new PlanDuration(workItem.getDuration(), WorkItems.getCorrectedEstimate((IWorkItem)workItem), WorkItems.getTimeSpent((IWorkItem)workItem), WorkItems.isResolved((IWorkItem)workItem, (IWorkflowInfo)workflowInfo));
                copyManager.connect((IWorkItemHandle)workItem, IWorkItem.FULL_PROFILE, (IProgressMonitor)progress.newChild(1));
                WorkItemWorkingCopy existingWorkingCopy = copyManager.getWorkingCopy((IWorkItemHandle)workItem);
                IWorkItem existingWorkItem = existingWorkingCopy.getWorkItem();
                workingCopies.add(existingWorkingCopy);
                IWorkItemReferences existingWorkItemReferences = existingWorkingCopy.getReferences();
                List existingWorkItemTimeSheet = existingWorkItemReferences.getReferences(WorkItemEndPoints.WORK_TIME);
                if (!noTimeSpentWorkItems.contains((Object)existingWorkItem)) {
                    IWorkItemType workItemType = workItemClient.findWorkItemType(projectArea, existingWorkItem.getWorkItemType(), (IProgressMonitor)progress.newChild(1));
                    WorkItemWorkingCopy workingCopy = copyManager.getWorkingCopy(copyManager.connectNew(workItemType, (IProgressMonitor)progress.newChild(1)));
                    workingCopies.add(workingCopy);
                    IWorkItem newWorkItem = workingCopy.getWorkItem();
                    workItemToPrequel.put((IItemHandle)existingWorkItem, (Object)newWorkItem);
                    ArrayList<String> attributes = new ArrayList<String>();
                    attributes.addAll(Arrays.asList(IWorkItem.SUMMARY_PROPERTY, IWorkItem.OWNER_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.TARGET_PROPERTY, IWorkItem.DESCRIPTION_PROPERTY));
                    attributes.addAll(workItemClient.findRequiredAttributes(newWorkItem, null, (IProgressMonitor)progress.newChild(1)));
                    this.copyAttributes(existingWorkItem, newWorkItem, attributes, (IProgressMonitor)progress.newChild(1));
                    XMLString content = XMLString.createFromPlainText((String)NLS.bind((String)Messages.ContinueWorkAction_COMMENT_PREQUEL, (Object)workItemType.getDisplayName(), (Object[])new Object[]{existingWorkItem.getId()}));
                    IComment comment = existingWorkItem.getComments().createComment((IContributorHandle)PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).loggedInContributor(), content);
                    newWorkItem.getComments().append(comment);
                    newWorkItem.setValue(estimate, (Object)planDuration.getOriginalEstimateDuration());
                    newWorkItem.setValue(correctedEstimate, (Object)planDuration.getTimeSpentDuration());
                    newWorkItem.setValue(timeSpent, (Object)planDuration.getTimeSpentDuration());
                    workingCopy.getReferences().add(WorkItemEndPoints.RELATED_WORK_ITEM, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)existingWorkItem));
                    for (IReference reference : existingWorkItemTimeSheet) {
                        workingCopy.getReferences().add(WorkItemEndPoints.WORK_TIME, (IReference)IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)((ITimeSheetEntryHandle)((IItemReference)reference).getReferencedItem())));
                    }
                    this.copyParentReference(existingWorkItemReferences, workingCopy);
                }
                for (IReference reference : existingWorkItemTimeSheet) {
                    existingWorkItemReferences.remove(reference);
                }
                existingWorkItem.setTarget((IIterationHandle)this.fIteration);
                existingWorkItem.setValue(timeSpent, (Object)-1L);
                existingWorkItem.setValue(correctedEstimate, (Object)-1L);
                long newEstimate = planDuration.getCurrentEstimateDuration();
                if (planDuration.getTimeSpentDuration() > 0L) {
                    newEstimate = Math.max(-1L, newEstimate - planDuration.getTimeSpentDuration());
                }
                existingWorkItem.setValue(estimate, (Object)newEstimate);
            }
            IDetailedStatus status = copyManager.save(workingCopies.toArray(new WorkItemWorkingCopy[workingCopies.size()]), (IProgressMonitor)progress.newChild(1));
            if (status.isOK()) {
                for (Map.Entry entry : workItemToPrequel.entrySet()) {
                    IWorkItem workItem = (IWorkItem)entry.getKey();
                    IWorkItem newWorkItem = (IWorkItem)entry.getValue();
                    IWorkItemType workItemType = workItemClient.findWorkItemType(projectArea, newWorkItem.getWorkItemType(), (IProgressMonitor)progress.newChild(1));
                    copyManager.refreshWithCurrent((IWorkItemHandle)newWorkItem, (IProgressMonitor)progress.newChild(1));
                    WorkItemWorkingCopy workingCopy = copyManager.getWorkingCopy((IWorkItemHandle)newWorkItem);
                    Identifier resolveActionId = workItemClient.findWorkflowInfo(newWorkItem, (IProgressMonitor)progress.newChild(1)).getResolveActionId();
                    if (resolveActionId != null) {
                        workingCopy.setWorkflowAction(resolveActionId.getStringIdentifier());
                    }
                    XMLString content = XMLString.createFromPlainText((String)NLS.bind((String)Messages.ContinueWorkAction_COMMENT_WORK, (Object)workItemType.getDisplayName(), (Object[])new Object[]{newWorkItem.getId()}));
                    IComment comment = workItem.getComments().createComment((IContributorHandle)PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).loggedInContributor(), content);
                    workItem.getComments().append(comment);
                }
                status = copyManager.save(workingCopies.toArray(new WorkItemWorkingCopy[workingCopies.size()]), (IProgressMonitor)progress.newChild(1));
            }
            Iterator iter = workingCopies.iterator();
            while (iter.hasNext()) {
                copyManager.disconnect((IWorkItemHandle)((WorkItemWorkingCopy)iter.next()).getWorkItem());
            }
            return status;
        }

        private void copyParentReference(IWorkItemReferences existingWorkItemReferences, WorkItemWorkingCopy newWorkItemWorkingCopy) {
            List existingParent = existingWorkItemReferences.getReferences(WorkItemEndPoints.PARENT_WORK_ITEM);
            if (!existingParent.isEmpty()) {
                IWorkItemReferences references = newWorkItemWorkingCopy.getReferences();
                references.add(WorkItemEndPoints.PARENT_WORK_ITEM, ((IReference)existingParent.get(0)).makeClone());
            }
        }

        public void copyAttributes(IWorkItem source, IWorkItem target, Collection<String> attributes, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient((IItemHandle)source);
            HashSet<String> set = new HashSet<String>(attributes);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)set.size());
            for (String attribute : set) {
                IAttribute attr = workItemClient.findAttribute(source.getProjectArea(), attribute, (IProgressMonitor)progress.newChild(1));
                target.setValue(attr, source.getValue(attr));
            }
        }
    }
}

