/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.widgets.SingleListSelectionDialog;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchSite;

public class ConfigureDefaultWorkItemTypeAction
extends Action {
    private IWorkbenchSite fSite;
    private PlanViewModel fViewModel;

    public ConfigureDefaultWorkItemTypeAction(IWorkbenchSite site, PlanViewModel viewModel) {
        this.setText(Messages.ConfigureDefaultWorkItemTypeAction_LABEL);
        this.fSite = site;
        this.fViewModel = viewModel;
    }

    public void run() {
        IOutlineSettings settings = this.fViewModel.getViewer().getSettings();
        List workItemTypes = this.fViewModel.getInput().getCreatableWorkItemTypes();
        SingleListSelectionDialog dialog = new SingleListSelectionDialog(this.fSite.getShell(), Messages.ConfigureDefaultWorkItemTypeAction_SELECTION_DIALOG_TITLE, Messages.ConfigureDefaultWorkItemTypeAction_SELECTION_DIALOG_MESSAGE, "com.ibm.team.apt.ide.ui.dialog_workitem_type_selection", new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }
        }, (ILabelProvider)new LabelProvider(){
            private Map<String, Image> fImages = new HashMap<String, Image>();

            public void dispose() {
                for (Image image : this.fImages.values()) {
                    image.dispose();
                }
                super.dispose();
            }

            public String getText(Object element) {
                if (element instanceof IWorkItemType) {
                    return ((IWorkItemType)element).getDisplayName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                if (element instanceof IWorkItemType) {
                    IWorkItemType type = (IWorkItemType)element;
                    Image result = this.fImages.get(type.getIdentifier());
                    if (result != null) {
                        return result;
                    }
                    result = WorkItemUI.getImageDescriptor((IWorkItemType)type).createImage();
                    this.fImages.put(type.getIdentifier(), result);
                    return result;
                }
                return null;
            }
        }, workItemTypes);
        if (settings.getDefaultWorkItemType() != null) {
            for (IWorkItemType type : workItemTypes) {
                if (!type.getIdentifier().equals(settings.getDefaultWorkItemType())) continue;
                dialog.setInitialElementSelections(Collections.singletonList(type));
                break;
            }
        }
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result.length == 0) {
                settings.setDefaultWorkItemType(null);
            } else if (result.length == 1 && result[0] instanceof IWorkItemType) {
                settings.setDefaultWorkItemType(((IWorkItemType)result[0]).getIdentifier());
            }
        }
    }
}

