/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.util.IterationSelectionDialog;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

public class AssignTargetAction
extends PlanViewModelAction<PlanItem> {
    private IIteration fInterval;
    private final boolean fSetWorkAccepted;
    private IProjectAreaHandle fProjectAreaHandle;

    public AssignTargetAction(IWorkbenchSite site, PlanViewModel planViewModel, boolean setWorkAccepted, IProjectAreaHandle projectAreaHandle) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.fProjectAreaHandle = projectAreaHandle;
        this.fInterval = null;
        this.fSetWorkAccepted = setWorkAccepted;
        this.setText(Messages.AssignTagAction_LABEL_MORE_TAGS);
    }

    public AssignTargetAction(IWorkbenchSite site, PlanViewModel planViewModel, IIteration interval, boolean setWorkAccepted) {
        this(site, planViewModel, interval, setWorkAccepted, interval != null ? interval.getLabel() : Messages.AssignTargetAction_LABEL_UNASSIGN_ITERATION);
    }

    public AssignTargetAction(IWorkbenchSite site, PlanViewModel planViewModel, IIteration interval, boolean setWorkAccepted, String label) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.fInterval = interval;
        this.fSetWorkAccepted = setWorkAccepted;
        this.setText(label);
    }

    @Override
    protected void updateAction(Collection<IViewEntry<PlanItem>> selectedEntries) {
        this.setChecked(this.computeChecked(selectedEntries));
    }

    protected boolean computeChecked(Collection<IViewEntry<PlanItem>> selectedEntries) {
        for (IViewEntry<PlanItem> selectedEntry : selectedEntries) {
            if (!this.computeChecked((PlanItem)selectedEntry.getElement())) continue;
            return true;
        }
        return false;
    }

    protected boolean computeChecked(PlanItem item) {
        IIteration currentTarget = item.getTarget();
        if (this.fInterval == null) {
            return currentTarget == null;
        }
        return this.fInterval.sameItemId((IItemHandle)currentTarget);
    }

    @Override
    public void run(Collection<IViewEntry<PlanItem>> selectedEntries) {
        if (this.fProjectAreaHandle != null) {
            IterationSelectionDialog iterationSelectionDialog = new IterationSelectionDialog(this.getShell(), false, false);
            iterationSelectionDialog.setInput(this.fProjectAreaHandle);
            int open = iterationSelectionDialog.open();
            if (open == 1) {
                return;
            }
            Object[] result = iterationSelectionDialog.getResult();
            if (result == null || result.length != 1 || !(result[0] instanceof IIteration)) {
                return;
            }
            this.fInterval = (IIteration)result[0];
        }
        for (IViewEntry iViewEntry : selectedEntries) {
            final PlanItem item = (PlanItem)iViewEntry.getElement();
            item.getPlan().runWithDeltaBuilder(new Runnable(){

                @Override
                public void run() {
                    item.setTarget(AssignTargetAction.this.fInterval);
                    if (AssignTargetAction.this.fSetWorkAccepted) {
                        item.markAsNewItem(false);
                    }
                    item.markRead();
                }
            });
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

