/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.TagSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

public class AssignTagAction
extends PlanViewModelAction<PlanItem> {
    private final String fTag;
    private final IRecentlyUsedTagsRegistry fRecentlyUsedTagsRegistry;

    public AssignTagAction(IWorkbenchSite site, PlanViewModel viewModel, String tag, IRecentlyUsedTagsRegistry recentlyUsedTagsRegistry) {
        super(site, viewModel, PlanItem.class, ONE_OR_MORE);
        this.fTag = tag;
        this.fRecentlyUsedTagsRegistry = recentlyUsedTagsRegistry;
        this.setText(this.fTag != null ? this.fTag : Messages.AssignTagAction_LABEL_MORE_TAGS);
    }

    @Override
    protected void updateAction(Collection<IViewEntry<PlanItem>> selectedEntries) {
        boolean checked = false;
        if (this.fTag != null && selectedEntries.size() == 1) {
            PlanItem item = (PlanItem)EntryUtils.firstEntry(selectedEntries).getElement();
            checked = item.hasTag(this.fTag);
        }
        this.setChecked(checked);
    }

    @Override
    public void run(Collection<IViewEntry<PlanItem>> selectedEntries) {
        TagSelectionDialog tagSelectionDialog;
        String tag = this.fTag;
        if (tag == null && (tagSelectionDialog = new TagSelectionDialog(this.getShell(), (IProjectAreaHandle)this.getPlanViewModel().getInput().getProjectArea())).open() == 0) {
            tag = tagSelectionDialog.getResult();
        }
        if (tag != null && tag.length() > 0) {
            for (IViewEntry iViewEntry : selectedEntries) {
                ((PlanItem)iViewEntry.getElement()).toggleTag(tag);
            }
            this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
            if (this.fRecentlyUsedTagsRegistry != null) {
                this.fRecentlyUsedTagsRegistry.registerRecentlyUsedTag(tag);
            }
        }
    }
}

