/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

public class AssignCategoryAction
extends PlanViewModelAction<PlanItem> {
    private ICategory fCategory;

    public AssignCategoryAction(IWorkbenchSite site, PlanViewModel viewModel, ICategory predecessor, ICategory category) {
        super(site, viewModel, PlanItem.class, ONE_OR_MORE);
        String predecessorName = predecessor != null ? String.valueOf(predecessor.getHierarchicalName()) + "/" : "/";
        String currentName = category.getHierarchicalName();
        int maxLength = Math.min(predecessorName.length(), currentName.length());
        int lastCommonSeparator = 0;
        int i = 0;
        while (i < maxLength) {
            if (predecessorName.charAt(i) != currentName.charAt(i)) break;
            if (currentName.charAt(i) == '/') {
                lastCommonSeparator = i;
            }
            ++i;
        }
        String prependedCategories = "";
        int indent = category.getDepth();
        int lastSlash = currentName.lastIndexOf(47);
        if (lastSlash != lastCommonSeparator) {
            prependedCategories = currentName.substring(0, lastSlash + 1);
            indent = 0;
        }
        StringBuilder labelBuilder = new StringBuilder();
        int i2 = 0;
        while (i2 < indent) {
            labelBuilder.append(Messages.AssignCategoryAction_INDENTATION);
            ++i2;
        }
        labelBuilder.append(prependedCategories);
        labelBuilder.append(category.getName());
        this.setText(labelBuilder.toString());
        this.fCategory = category;
    }

    @Override
    protected void updateAction(Collection<IViewEntry<PlanItem>> selectedEntries) {
        PlanItem item;
        boolean checked = false;
        if (selectedEntries.size() == 1 && this.fCategory.equals((Object)(item = (PlanItem)EntryUtils.firstEntry(selectedEntries).getElement()).getCategory())) {
            checked = true;
        }
        this.setChecked(checked);
    }

    @Override
    public void run(Collection<IViewEntry<PlanItem>> selectedEntries) {
        for (IViewEntry iViewEntry : selectedEntries) {
            ((PlanItem)iViewEntry.getElement()).setCategory(this.fCategory);
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

