/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.LinkedItemHashSet;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.AssignCategoryAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignOwnerAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignPlanTargetAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignTagAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignTargetAction;
import com.ibm.team.apt.internal.ide.ui.actions.DeferredContributionItem;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.SchedulePlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.ScheduleTime;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.UIJob;

public class AssignActionFactory {
    private final IWorkbenchSite fSite;
    private final PlanViewModel fViewModel;

    public AssignActionFactory(IWorkbenchSite site, PlanViewModel viewModel) {
        this.fSite = site;
        this.fViewModel = viewModel;
    }

    public boolean isEnabled() {
        List<?> elements = this.fViewModel.getSelectedElements();
        for (Object elememt : elements) {
            if (!(elememt instanceof PlanItem)) {
                return false;
            }
            if (!((PlanItem)elememt).isProgressPlanItem()) continue;
            return false;
        }
        return true;
    }

    public IMenuManager getAssignTargetMenu() {
        final MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_PLAN_FOR_ITERATION_ONLY);
        UIJob runAfter = new UIJob(this.fSite.getShell().getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Node contextIterations = null;
                IIteration planIteration = null;
                IProjectAreaHandle projectAreaHandle = null;
                if (AssignActionFactory.this.getPlan() instanceof ResolvedIterationPlan) {
                    ResolvedIterationPlan plan = (ResolvedIterationPlan)AssignActionFactory.this.getPlan();
                    contextIterations = plan.getContextIterations();
                    planIteration = plan.getInterval();
                    projectAreaHandle = plan.getProjectAreaHandle();
                }
                if (contextIterations != null) {
                    ItemHashSet set = new ItemHashSet(CMode.CURRENT_HANDLEONLY);
                    Iterator iter = contextIterations.depthFirstIterator();
                    while (iter.hasNext()) {
                        Node node = (Node)iter.next();
                        IIteration iteration = (IIteration)node.getElement();
                        if (node.isRoot() || planIteration != null && planIteration.getItemId().equals((Object)iteration.getItemId()) || set.contains((Object)iteration) || !iteration.hasDeliverable()) continue;
                        set.add((Object)iteration);
                        menu.add((IAction)new AssignTargetAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, iteration, false));
                    }
                    menu.add((IAction)new AssignTargetAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, null, false));
                    menu.add((IContributionItem)new Separator());
                    menu.add((IAction)new AssignTargetAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, false, projectAreaHandle));
                }
                return Status.OK_STATUS;
            }
        };
        this.addDeferredContributionItem(menu, Arrays.asList(PlanItem.TARGET), runAfter);
        return menu;
    }

    public IMenuManager getAssignOwnerMenu() {
        final MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_ASSIGN_OWNER);
        UIJob runAfter = new UIJob(this.fSite.getShell().getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ArrayList<IContributor> owners = new ArrayList<IContributor>();
                for (IContributor owner : AssignActionFactory.this.getPlan().getOwners()) {
                    owners.add(owner);
                }
                owners.remove(AssignActionFactory.this.getPlan().getNullOwner());
                Collections.sort(owners, new Comparator<IContributor>(){
                    Collator collator = CollatorCache.getInstance();

                    @Override
                    public int compare(IContributor o1, IContributor o2) {
                        return this.collator.compare(o1.getName(), o2.getName());
                    }
                });
                menu.add((IAction)new AssignOwnerAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, AssignActionFactory.this.getPlan().getNullOwner()));
                for (IContributor contributor : owners) {
                    menu.add((IAction)new AssignOwnerAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, contributor));
                }
                return Status.OK_STATUS;
            }
        };
        this.addDeferredContributionItem(menu, Arrays.asList(PlanItem.OWNER), runAfter);
        return menu;
    }

    public IMenuManager getAssignCategoryMenu() {
        final MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_ASSIGN_CATEGORY);
        UIJob runAfter = new UIJob(this.fSite.getShell().getDisplay(), ""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ArrayList<ICategory> categories = new ArrayList<ICategory>();
                for (ICategory category : AssignActionFactory.this.getPlan().getCategories()) {
                    categories.add(category);
                }
                Categories.sort(categories);
                ICategory previousCategory = null;
                for (ICategory category : categories) {
                    if (category.isArchived()) continue;
                    menu.add((IAction)new AssignCategoryAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, previousCategory, category));
                    previousCategory = category;
                }
                return Status.OK_STATUS;
            }
        };
        this.addDeferredContributionItem(menu, Arrays.asList(PlanItem.CATEGORY), runAfter);
        return menu;
    }

    public IMenuManager getAssignTagMenu() {
        final List<IViewEntry<?>> selectedEntries = this.fViewModel.getSelectedEntries();
        final MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_ASSIGN_TAG);
        if (!selectedEntries.isEmpty()) {
            List<IPlanningAttributeIdentifier> dependantAttributes = Arrays.asList(PlanItem.TAGS);
            UIJob runAfter = new UIJob(this.fSite.getShell().getDisplay(), ""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    HashSet<String> allTags = new HashSet<String>();
                    for (IViewEntry entry : selectedEntries) {
                        Object node = entry.getElement();
                        if (!(node instanceof PlanItem)) continue;
                        allTags.addAll(Arrays.asList(((PlanItem)node).getTags()));
                    }
                    allTags.addAll(AssignActionFactory.this.fViewModel.getInput().getPopularTags(5));
                    IRecentlyUsedTagsRegistry recentlyUsedTagsRegistry = PlanningUIPlugin.getDefault().getRecentlyUsedTagsRegistry();
                    allTags.addAll(recentlyUsedTagsRegistry.getTags(3));
                    ArrayList sortedTags = new ArrayList(allTags);
                    Collections.sort(sortedTags, CollatorCache.getInstance());
                    for (String tag : sortedTags) {
                        AssignActionFactory.this.addToMenu(new AssignTagAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, tag, recentlyUsedTagsRegistry), (IMenuManager)menu, false);
                    }
                    AssignActionFactory.this.addToMenu(new AssignTagAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, null, recentlyUsedTagsRegistry), (IMenuManager)menu, true);
                    return Status.OK_STATUS;
                }
            };
            this.addDeferredContributionItem(menu, dependantAttributes, runAfter);
        }
        return menu;
    }

    public IMenuManager getPlanningMenu() {
        final List<IViewEntry<?>> selectedEntries = this.fViewModel.getSelectedEntries();
        final MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_PLAN_FOR_WITH_SCHEDULE);
        if (!selectedEntries.isEmpty()) {
            UIJob runAfter = new UIJob(this.fSite.getShell().getDisplay(), ""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkedItemHashSet allRelatedIterations = new LinkedItemHashSet();
                    for (IViewEntry entry : selectedEntries) {
                        Object node = entry.getElement();
                        if (!(node instanceof PlanItem)) continue;
                        for (IIteration iteration : ((PlanItem)node).getRelatedIterations()) {
                            if (allRelatedIterations.contains((Object)iteration)) continue;
                            allRelatedIterations.add((Object)iteration);
                        }
                    }
                    ItemSet plannedIterations = AssignActionFactory.this.getPlan().getPlannedIterations();
                    boolean needsSeparator = false;
                    for (IIteration iteration : plannedIterations) {
                        if (!allRelatedIterations.contains((Object)iteration)) continue;
                        needsSeparator = AssignActionFactory.this.buildScheduleMenu(selectedEntries, iteration, (IMenuManager)menu, needsSeparator);
                    }
                    for (IIteration iteration : allRelatedIterations) {
                        if (plannedIterations.contains((Object)iteration)) continue;
                        needsSeparator &= !AssignActionFactory.this.addToMenu(new AssignTargetAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, iteration, true), (IMenuManager)menu, needsSeparator);
                    }
                    AssignActionFactory.this.addToMenu(new AssignTargetAction(AssignActionFactory.this.fSite, AssignActionFactory.this.fViewModel, null, true), (IMenuManager)menu, needsSeparator);
                    return Status.OK_STATUS;
                }
            };
            this.addDeferredContributionItem(menu, Arrays.asList(PlanItem.TARGET, PlanItem.OWNER), runAfter);
        }
        return menu;
    }

    private boolean buildScheduleMenu(Collection<IViewEntry<?>> selectedEntries, IIteration iteration, IMenuManager menu, boolean needsSeparator) {
        ArrayList actions = new ArrayList();
        IWorkHoursDefinition workHours = null;
        for (IViewEntry<?> entry : selectedEntries) {
            Object element = entry.getElement();
            if (!(element instanceof PlanItem)) continue;
            PlanItem planItem = (PlanItem)element;
            ResolvedPlan plan = planItem.getPlan();
            if (plan instanceof ResolvedIterationPlan) {
                IContributor owner = planItem.getOwner();
                if (plan.getNullOwner().sameItemId((IItemHandle)owner)) continue;
                workHours = ((ResolvedIterationPlan)plan).getWorkHourDefinitions((IContributorHandle)owner);
                continue;
            }
            if (!(plan instanceof ResolvedPersonalPlan)) continue;
            workHours = ((ResolvedPersonalPlan)plan).getWorkHourDefinitions();
        }
        actions.add(new AssignPlanTargetAction(this.fSite, this.fViewModel, iteration, true, iteration.getLabel()));
        if (workHours != null) {
            Date referenceTime = this.getPlan().getReferenceTime();
            ScheduleTime[] times = new ScheduleTime[]{new ScheduleTime.LaterToday(referenceTime, workHours), new ScheduleTime.Day(Messages.AssignActionFactory_PLAN_FOR_TOMORROW, 1, referenceTime, workHours), new ScheduleTime.DayWithDayLabel(2, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_LATER_THIS_WEEK, 0, 1, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_NEXT_WEEK, 1, 1, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_IN_TWO_WEEKS, 2, 2, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_IN_ONE_MONTH, 4, 4, referenceTime, workHours), new ScheduleTime.Future(Messages.AssignActionFactory_PLAN_FOR_FUTURE, 5, referenceTime, workHours)};
            int i = 0;
            while (i < times.length) {
                ScheduleTime time = times[i];
                if (i > 0) {
                    time.setPrevious(times[i - 1]);
                }
                actions.add(new SchedulePlanItemAction(this.fSite, this.fViewModel, time, iteration));
                ++i;
            }
        }
        return this.addToMenu(actions, menu, needsSeparator);
    }

    private void addDeferredContributionItem(MenuManager menu, final Collection<IPlanningAttributeIdentifier> dependantAttributes, UIJob runAfter) {
        FoundationJob runBefore = new FoundationJob(menu.getMenuText()){

            public boolean shouldSchedule() {
                return !AssignActionFactory.this.getPlan().isPrepared(dependantAttributes);
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AssignActionFactory.this.getPlan().prepare((PlanElement)AssignActionFactory.this.getPlan(), dependantAttributes, monitor);
                return Status.OK_STATUS;
            }
        };
        menu.add((IContributionItem)new DeferredContributionItem((Job)runBefore, runAfter));
    }

    private boolean addToMenu(List<PlanViewModelAction<?>> actions, IMenuManager menu, boolean needsSeparator) {
        boolean result = false;
        for (PlanViewModelAction<?> action : actions) {
            boolean wasAdded;
            needsSeparator &= !(wasAdded = this.addToMenu(action, menu, needsSeparator));
            result |= wasAdded;
        }
        return result;
    }

    private boolean addToMenu(PlanViewModelAction<?> action, IMenuManager menu, boolean needsSeparator) {
        action.update();
        if (action.isEnabled()) {
            if (needsSeparator) {
                menu.add((IContributionItem)new Separator());
            }
            menu.add(action);
            return true;
        }
        return false;
    }

    private ResolvedPlan getPlan() {
        return this.fViewModel.getInput();
    }
}

