/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.MovePlanItemAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.workitem.common.internal.template.AttributeVariable;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.ITemplateAttributeIdentifiers;
import com.ibm.team.workitem.common.template.ITemplateTypeIdentifiers;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.IWorkItemCreationListener;
import com.ibm.team.workitem.rcp.ui.internal.wizards.templates.NewWorkItemsFromTemplateWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IProgressService;

public class AddWorkItemsFromTemplateAction
extends MovePlanItemAction<PlatformObject> {
    private IProjectArea fProjectArea;
    private PlanViewModel fPlanViewModel;
    private NewWorkItemsFromTemplateWizard fWizard;
    private IWorkItemCreationListener fWorkItemCreationListener = new WorkItemCreationListener();
    private IPlanElementListener fPlanElementListener = new PlanElementListener();
    private OutlineEntry<GroupElement> fGroupEntry;
    private GroupElement fSelectedElement;
    private BlockingQueue<PlanItem> fNewPlanItemQueue = new LinkedBlockingQueue<PlanItem>();

    public AddWorkItemsFromTemplateAction(IWorkbenchSite site, PlanViewModel planViewModel) {
        super(site, planViewModel, PlatformObject.class, ONE_OR_MORE);
        this.fPlanViewModel = planViewModel;
        this.setText(Messages.AddWorkItemsFromTemplateAction_LABEL);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        Object entry;
        boolean enable = false;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (entry = ((IStructuredSelection)selection).getFirstElement()) instanceof OutlineEntry && EntryUtils.isType((OutlineEntry)entry, GroupElement.class)) {
            this.fGroupEntry = (OutlineEntry)entry;
            this.fSelectedElement = this.fGroupEntry.getElement();
            List types = this.fPlanViewModel.getInput().getCreatableWorkItemTypes();
            for (IWorkItemType type : types) {
                boolean bl = enable = enable || this.getMovePolicy().canAddItemBelow((IViewEntry)entry, type);
            }
        }
        this.setEnabled(enable);
    }

    @Override
    public void run(Collection<IViewEntry<PlatformObject>> selectedEntries) {
        IWorkbenchWindow activeWindow = this.getActiveWorkbenchWindow();
        if (activeWindow != null) {
            ResolvedPlan plan = this.fPlanViewModel.getInput();
            this.fProjectArea = plan.getProjectArea();
            this.fWizard = new NewWorkItemsFromTemplateWizard((IProjectAreaHandle)this.fProjectArea);
            this.fWizard.setPromptForAttributeVariableValues(false);
            this.fWizard.setUserCanSelectProjectArea(false);
            if (plan instanceof ResolvedIterationPlan) {
                ResolvedIterationPlan iterationPlan = (ResolvedIterationPlan)plan;
                AttributeVariable categoryAttribute = new AttributeVariable(ITemplateAttributeIdentifiers.WORKITEM_CATEGORY, ITemplateTypeIdentifiers.CATEGORY);
                AttributeVariable iterationAttribute = new AttributeVariable(ITemplateAttributeIdentifiers.WORKITEM_ITERATION, ITemplateTypeIdentifiers.ITERATION);
                IProcessArea processArea = iterationPlan.getTeamMemberArea();
                ICategory categoryValue = iterationPlan.getPrimaryCategoryFor(processArea);
                IIteration iterationValue = iterationPlan.getInterval();
                this.fWizard.setAttributeVariableValue((IAttributeVariable)categoryAttribute, (Object)categoryValue);
                this.fWizard.setAttributeVariableValue((IAttributeVariable)iterationAttribute, (Object)iterationValue);
                try {
                    this.fWizard.addListener(this.fWorkItemCreationListener);
                    iterationPlan.addListener(this.fPlanElementListener);
                    WizardDialog dialog = new WizardDialog(activeWindow.getShell(), (IWizard)this.fWizard);
                    dialog.create();
                    dialog.open();
                }
                finally {
                    this.fWizard.removeListener(this.fWorkItemCreationListener);
                    iterationPlan.removeListener(this.fPlanElementListener);
                }
            }
        }
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlanningUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow activeWindow = null;
        if (workbench != null) {
            activeWindow = workbench.getActiveWorkbenchWindow();
        }
        return activeWindow;
    }

    private class PlanElementListener
    implements IPlanElementListener {
        private PlanElementListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            IPlanElementDelta delta = event.getDelta();
            delta.accept(new IPlanElementDeltaVisitor(){

                public boolean visit(IPlanElementDelta delta) {
                    PlanElement planElement = delta.getPlanElement();
                    if (planElement instanceof PlanItem && delta.isAdded() && !delta.isMoveChange()) {
                        AddWorkItemsFromTemplateAction.this.fNewPlanItemQueue.add((PlanItem)planElement);
                    }
                    return true;
                }
            });
        }
    }

    private class WorkItemCreationListener
    implements IWorkItemCreationListener {
        private WorkItemCreationListener() {
        }

        public void workItemCreationFinished() {
            IProgressService progressService = PlanningUIPlugin.getDefault().getWorkbench().getProgressService();
            try {
                progressService.run(true, true, (IRunnableWithProgress)new TeamRunnable(){
                    private IProgressMonitor fMonitor = null;
                    private ItemHashSet<IWorkItemHandle> newWorkItemsFromWizard;
                    {
                        this.newWorkItemsFromWizard = new ItemHashSet((Collection)AddWorkItemsFromTemplateAction.this.fWizard.getNewWorkItems(), CMode.CURRENT_HANDLEONLY);
                    }

                    @Override
                    protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        this.fMonitor = monitor;
                        int totalWork = this.newWorkItemsFromWizard.size() * 2;
                        monitor.beginTask(Messages.AddWorkItemsFromTemplateAction_ADOPT_WORK_ITEMS_MESSAGE, totalWork);
                        ResolvedPlan plan = AddWorkItemsFromTemplateAction.this.fPlanViewModel.getInput();
                        if (plan instanceof ResolvedIterationPlan) {
                            ResolvedIterationPlan iterationPlan = (ResolvedIterationPlan)plan;
                            final ArrayList<PlanItem> newItemsInPlan = new ArrayList<PlanItem>();
                            while (!this.newWorkItemsFromWizard.isEmpty()) {
                                PlanItem newItemInPlan = (PlanItem)AddWorkItemsFromTemplateAction.this.fNewPlanItemQueue.take();
                                if (!this.newWorkItemsFromWizard.contains((Object)newItemInPlan.getWorkItemHandle())) continue;
                                newItemsInPlan.add(newItemInPlan);
                                this.newWorkItemsFromWizard.remove((Object)newItemInPlan.getWorkItemHandle());
                                monitor.worked(1);
                            }
                            iterationPlan.runConnected((PlanRunnable)new PlanRunnable<InterruptedException>(){

                                public void run() throws InterruptedException {
                                    for (PlanItem planItem : newItemsInPlan) {
                                        AddWorkItemsFromTemplateAction.this.fSelectedElement.adopt((PlanElement)planItem, AddWorkItemsFromTemplateAction.this.fGroupEntry, (IProgressMonitor)new SubProgressMonitor(fMonitor, 1));
                                    }
                                }
                            });
                        }
                    }
                });
            }
            catch (InvocationTargetException ite) {
                PlanningUIPlugin.log(ite);
            }
            catch (InterruptedException ie) {
                PlanningUIPlugin.log(ie);
            }
        }
    }
}

