/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WikiPageHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            return IWikiPage.ITEM_TYPE.equals(location.getItemType());
        }
        catch (TeamRepositoryException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void open(URI uri, ContextProvider context, IProgressMonitor monitor) {
        final IWorkbenchWindow workbenchWindow = WikiPageHyperlinkHandler.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        Location location = null;
        try {
            location = Location.location((URI)uri);
        }
        catch (TeamRepositoryException e) {
            PlanningUIPlugin.log(e);
        }
        catch (IllegalArgumentException e) {
            PlanningUIPlugin.log(e);
        }
        if (location == null) {
            return;
        }
        IItemHandle itemHandle = location.getItemHandle();
        if (itemHandle == null) {
            return;
        }
        if (!(itemHandle instanceof IWikiPageHandle)) {
            return;
        }
        ITeamRepository repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(location.getRepoUri());
        Display display = workbenchWindow.getShell().getDisplay();
        try {
            final IWikiPage wikiPage = (IWikiPage)repository.itemManager().fetchCompleteItem(itemHandle, 0, monitor);
            if (wikiPage.getOwner() instanceof IIterationPlanRecordHandle) {
                final IIterationPlanRecordHandle planHandle = (IIterationPlanRecordHandle)wikiPage.getOwner();
                UI.asyncExec(display, new Runnable(){

                    @Override
                    public void run() {
                        PlanningUI.openIterationPlanEditor(planHandle, wikiPage, workbenchWindow.getActivePage());
                    }
                });
            }
        }
        catch (TeamRepositoryException e) {
            PlanningUIPlugin.log(e);
        }
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        return window;
    }
}

