/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.ide.ui.Messages;
import com.ibm.team.apt.internal.ide.ui.PlanSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import com.ibm.team.apt.internal.ide.ui.actions.RecentlyUsedTagsManager;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditorInput;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.FilterUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.UsageStatistics;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkView;
import com.ibm.team.apt.internal.ide.ui.navigator.NewIterationPlanAction;
import com.ibm.team.apt.internal.ide.ui.util.IterationPlansDropDownAction;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PlanningUIPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "com.ibm.team.apt.ide.ui";
    public static final String SYMBOLIC_PLAN_EDITOR_FONT_NAME = "com.ibm.team.apt.ide.ui.iterationPlanEditor.font";
    public static final String SYMBOLIC_PAGES_EDITOR_FONT_NAME = "com.ibm.team.apt.ide.ui.iterationPlanEditor.wiki.font";
    private static final String MID_SHADOW = "com.ibm.team.apt.ide.ui.MID_SHADOW";
    private static final String DARK_SHADOW = "com.ibm.team.apt.ide.ui.DARK_SHADOW";
    public static final String PREF_ASK_PLAN_EDITOR_USE_WEB = "ask.planeditor.open.web";
    private static PlanningUIPlugin plugin;
    private Map<String, IUsageStatistics> fStatistics = new HashMap<String, IUsageStatistics>();
    private FilterUsageStatistics fFilterStatistics = null;
    private RecentlyUsedTagsManager fRecentlyUsedTagsMagaer = null;

    public PlanningUIPlugin() {
        plugin = this;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(String message, Throwable exception) {
        PlanningUIPlugin.log((IStatus)new Status(4, PlanningUI.getPluginId(), 0, message, exception));
    }

    public static void log(IStatus status) {
        PlanningUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        PlanningUIPlugin.log((IStatus)new Status(4, PlanningUI.getPluginId(), 4, "An internal error has occurred.", t));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fFilterStatistics != null) {
            this.fFilterStatistics.dispose();
            this.fFilterStatistics = null;
        }
        if (this.fRecentlyUsedTagsMagaer != null) {
            this.fRecentlyUsedTagsMagaer.dispose();
            this.fRecentlyUsedTagsMagaer = null;
        }
        for (Map.Entry<String, IUsageStatistics> entry : this.fStatistics.entrySet()) {
            this.getPreferenceStore().putValue(entry.getKey(), entry.getValue().toString());
        }
        super.stop(context);
        plugin = null;
    }

    public static PlanningUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return PlanningUIPlugin.getImageDescriptor(path, false);
    }

    public static ImageDescriptor getImageDescriptor(String path, boolean register) {
        ImageDescriptor result = AbstractUIPlugin.imageDescriptorFromPlugin((String)PlanningUI.getPluginId(), (String)path);
        if (result == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        if (register) {
            JazzResources.registerPath((ImageDescriptor)result, (String)PlanningUI.getPluginId(), (String)path);
        }
        return result;
    }

    public static void openIterationPlanMenu(IWorkbenchPage page, Point location, List<? extends IIterationPlanRecordHandle> plans) {
        if (plans.isEmpty()) {
            return;
        }
        if (plans.size() == 1) {
            PlanningUIPlugin.openIterationPlanEditor(plans.iterator().next(), null, page);
        } else {
            IterationPlansDropDownAction menuAction = new IterationPlansDropDownAction(page, plans);
            Shell shell = page.getActivePart().getSite().getShell();
            Menu menu = menuAction.getMenu((Control)shell);
            UI.showAndDisposeMenu(menu, location);
        }
    }

    public static void openIterationPlanEditor(final IProcessAreaHandle processAreaHandle, final IIterationHandle iterationHandle, final IWorkbenchPage page) {
        FoundationJob job = new FoundationJob(Messages.PlanningUIPlugin_JOB_OPEN_PLAN){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                Display display = page.getWorkbenchWindow().getShell().getDisplay();
                IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)processAreaHandle);
                final List records = ((IterationPlanClient)client).fetchIterationPlanRecords(Arrays.asList(processAreaHandle), iterationHandle, monitor);
                if (records.size() == 1) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PlanningUIPlugin.openIterationPlanEditor((IIterationPlanRecordHandle)records.iterator().next(), null, page);
                        }
                    });
                } else {
                    IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)processAreaHandle).itemManager();
                    final IIteration iteration = (IIteration)manager.fetchCompleteItem((IItemHandle)iterationHandle, 0, monitor);
                    final IProcessArea processArea = (IProcessArea)manager.fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                    if (records.size() > 1) {
                        final List plans = manager.fetchPartialItems(records, 0, Arrays.asList(IIterationPlanRecord.NAME_PROPERTY), monitor);
                        final Shell shell = page.getActivePart().getSite().getShell();
                        UI.syncExec((Control)shell, new Runnable(){

                            @Override
                            public void run() {
                                List<IIterationPlanRecord> selection = PlanSelectionDialog.getPlans(shell, plans);
                                for (IIterationPlanRecord plan : selection) {
                                    PlanningUIPlugin.openIterationPlanEditor((IIterationPlanRecordHandle)plan, page);
                                }
                            }
                        });
                    } else {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                boolean create = MessageDialog.openQuestion((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.PlanningUIPlugin_NO_PLANS_CREATEDIALOG_TITLE, (String)NLS.bind((String)Messages.PlanningUIPlugin_NO_PLANS_CREATEDIALOG_MESSAGE, (Object)processArea.getName(), (Object[])new Object[]{iteration.getLabel()}));
                                if (create) {
                                    IterationPlanWizardContext context = new IterationPlanWizardContext(ProjectAreaPicker.getAllConnectedProjectAreas((boolean)true));
                                    context.setTeamMemberArea((IProcessAreaHandle)processArea);
                                    context.setIteration((IIterationHandle)iteration);
                                    new NewIterationPlanAction(page.getWorkbenchWindow().getWorkbench(), context).run();
                                }
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, IWorkbenchPage page) {
        return PlanningUIPlugin.openIterationPlanEditor(handle, null, page);
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, IWikiPage wikiPage, IWorkbenchPage page) {
        Shell shell = page.getWorkbenchWindow().getShell();
        IPreferenceStore store = PlanningUIPlugin.getDefault().getPreferenceStore();
        if (!"always".equals(store.getString(PREF_ASK_PLAN_EDITOR_USE_WEB))) {
            MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, Messages.PlanEditorSelectionDialog_TITLE, null, Messages.PlanEditorSelectionDialog_MESSAGE, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, Messages.PlanEditorSelectionDialog_ASK_MESSAGE, false);
            dialog.setPrefStore(PlanningUIPlugin.getDefault().getPreferenceStore());
            dialog.setPrefKey(PREF_ASK_PLAN_EDITOR_USE_WEB);
            int open = dialog.open();
            if (open != 0) {
                return null;
            }
        }
        PlanningUIPlugin.doOpenPlanInWebClient(handle);
        return null;
    }

    private static void doOpenPlanInWebClient(final IIterationPlanRecordHandle handle) {
        new FoundationUIJob(""){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                URIReference uri = Hyperlinks.create((Object)handle, (IProgressMonitor)monitor);
                WorkItemRCPUIPlugin.openInBrowser((URI)uri.getURI());
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean closeIterationPlanEditor(IIterationPlanRecordHandle handle, IWorkbenchPage page, boolean save) {
        try {
            IEditorReference[] editors;
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IEditorReference editor = iEditorReferenceArray[n2];
                if (editor.getEditorInput() instanceof IterationPlanEditorInput && ((IterationPlanEditorInput)editor.getEditorInput()).getHandle().sameItemId((IItemHandle)handle)) {
                    page.closeEditor(editor.getEditor(true), save);
                    return true;
                }
                ++n2;
            }
        }
        catch (PartInitException e) {
            PlanningUIPlugin.log(e);
        }
        return false;
    }

    public IUsageStatistics getUsageStatistics(String scope) {
        IUsageStatistics stats = this.fStatistics.get(scope);
        if (stats == null) {
            stats = new UsageStatistics(this.getPreferenceStore().getString(scope));
            this.fStatistics.put(scope, stats);
        }
        return stats;
    }

    public FilterUsageStatistics getFilterUsageStatistics() {
        if (this.fFilterStatistics == null) {
            this.fFilterStatistics = new FilterUsageStatistics();
        }
        return this.fFilterStatistics;
    }

    public IRecentlyUsedTagsRegistry getRecentlyUsedTagsRegistry() {
        if (this.fRecentlyUsedTagsMagaer == null) {
            this.fRecentlyUsedTagsMagaer = new RecentlyUsedTagsManager();
        }
        return this.fRecentlyUsedTagsMagaer;
    }

    public MyWorkView getMyWorkViewInstance() {
        return (MyWorkView)this.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.ibm.team.apt.internal.ui.myWorkView");
    }

    public Color getMidShadow() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(MID_SHADOW);
    }

    public Color getDarkShadow() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(DARK_SHADOW);
    }
}

