/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public class IterationPlanRecordLabelProvider
extends TypeLabelProvider {
    private final List<UUID> fPendingUpdates = Collections.synchronizedList(new ArrayList());

    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof IIterationPlanRecord) {
            IIterationPlanRecord plan = (IIterationPlanRecord)element;
            if (!this.hasCachedPlanTypeDef(plan) && !this.fPendingUpdates.contains(plan.getItemId())) {
                new PlanTypeLoader(plan).schedule();
            }
            label.setImage(JazzResources.getImageWithDefault((ResourceManager)this.getResources(), (ImageDescriptor)PlanningUI.getImageDescriptor(plan)));
            label.setText(plan.getName());
        } else {
            label.setImage(super.getImage(element));
            label.setText(super.getText(element));
        }
    }

    public boolean hasCachedPlanTypeDef(IIterationPlanRecord plan) {
        if (!plan.isPropertySet(IIterationPlanRecord.PLAN_TYPE_PROPERTY)) {
            return false;
        }
        IProjectAreaHandle projectArea = null;
        IProcessAreaHandle processArea = plan.getOwner();
        if (processArea instanceof IProjectAreaHandle) {
            projectArea = (IProjectAreaHandle)processArea;
        } else {
            IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)processArea).itemManager();
            IProcessArea sharedProcessArea = (IProcessArea)itemManager.getSharedItemIfKnown((IItemHandle)processArea);
            if (sharedProcessArea != null) {
                projectArea = sharedProcessArea.getProjectArea();
            }
        }
        if (projectArea == null) {
            return false;
        }
        ConfigurationElementCache cache = PlanningClientPlugin.getIterationPlanClient((IItemHandle)plan).getConfigurationElementCache(projectArea);
        String planType = plan.getPlanType();
        return cache.contains(planType, IPlanType.class);
    }

    class PlanTypeLoader
    extends UIUpdaterJob {
        private IIterationPlanRecord fPlan;
        private boolean fShouldUpdate;

        PlanTypeLoader(IIterationPlanRecord plan) {
            super("");
            this.fShouldUpdate = true;
            this.fPlan = plan;
            IterationPlanRecordLabelProvider.this.fPendingUpdates.add(plan.getItemId());
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            IIterationPlanClient planningClient = PlanningClientPlugin.getIterationPlanClient((IItemHandle)this.fPlan);
            IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)this.fPlan);
            IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)this.fPlan).itemManager();
            try {
                try {
                    this.fPlan = (IIterationPlanRecord)itemManager.fetchPartialItem((IItemHandle)this.fPlan, 0, IIterationPlanRecord.MEDIUM_PROFILE.getProperties(), (IProgressMonitor)progress.newChild(1));
                    IAuditableCommonProcess process = auditableClient.getProcess(this.fPlan.getOwner(), (IProgressMonitor)progress.newChild(1));
                    IPlanType planType = planningClient.findPlanType(process, this.fPlan.getPlanType(), (IProgressMonitor)progress.newChild(1));
                    this.fShouldUpdate = planType.getId().equals(this.fPlan.getPlanType());
                }
                catch (TeamRepositoryException e) {
                    this.fShouldUpdate = false;
                    PlanningClientPlugin.log((Throwable)e);
                    IterationPlanRecordLabelProvider.this.fPendingUpdates.remove(this.fPlan.getItemId());
                }
            }
            finally {
                IterationPlanRecordLabelProvider.this.fPendingUpdates.remove(this.fPlan.getItemId());
            }
            return Status.OK_STATUS;
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (this.fShouldUpdate) {
                IterationPlanRecordLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)IterationPlanRecordLabelProvider.this, (Object)this.fPlan));
            }
            return Status.OK_STATUS;
        }
    }
}

