/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.Items;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.ide.ui.Messages;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.PlanningUIStatus;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.model.IterationMigration;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IterationPlanRecordHyperlinkHandler
extends HyperlinkHandler {
    private static final Status STATUS_UNKNOWN_OBJECT = new PlanningUIStatus(PlanningUIStatus.Codes.IterationPlanRecordHyperlinkHandler_UNKNOWN_OBJECT, Messages.IterationPlanRecordHyperlinkHandler_UNKNOWN_OBJECT);
    private static final Status STATUS_NO_WORKBENCH = new PlanningUIStatus(PlanningUIStatus.Codes.IterationPlanRecordHyperlinkHandler_NO_WORKBENCH, Messages.IterationPlanRecordHyperlinkHandler_NO_WORKBENCH);

    public boolean handles(URI uri) {
        return IIterationPlanRecord.ITEM_TYPE.equals(URIService.findItemType((URI)uri)) && URIService.findTeamRepository((URI)uri) != null;
    }

    public boolean resolves(URI uri) {
        return IIterationPlanRecord.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException e) {
            throw new CoreException((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), "", (Throwable)e));
        }
    }

    public IStatus open2(final URI uri, ContextProvider context, IProgressMonitor monitor) {
        try {
            final IWorkbenchWindow workbenchWindow = IterationPlanRecordHyperlinkHandler.getWorkbenchWindow();
            if (workbenchWindow == null) {
                return STATUS_NO_WORKBENCH;
            }
            final Object object = URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
            workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (object instanceof IIterationPlanRecordHandle) {
                        PlanningUI.openIterationPlanEditor((IIterationPlanRecordHandle)object, workbenchWindow.getActivePage());
                    } else {
                        WorkItemRCPUIPlugin.openInBrowser((URI)uri);
                    }
                }
            });
        }
        catch (ItemNotFoundException e) {
            return new PlanningUIStatus(PlanningUIStatus.Codes.IterationPlanRecordHyperlinkHandler_PLAN_NOT_FOUND, Messages.IterationPlanRecordHyperlinkHandler_PLAN_NOT_FOUND);
        }
        catch (TeamRepositoryException e) {
            return new PlanningUIStatus(PlanningUIStatus.Codes.IterationPlanRecordHyperlinkHandler_ERROR_RESOLVING_PLAN, Messages.IterationPlanRecordHyperlinkHandler_ERROR_RESOLVING_PLAN, e);
        }
        return Status.OK_STATUS;
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        return window;
    }

    public URIReference createHyperlink(Object object) {
        if (object instanceof IIterationPlanRecordHandle) {
            IIterationPlanRecordHandle handle = (IIterationPlanRecordHandle)object;
            try {
                ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)handle);
                IItemManager manager = repository.itemManager();
                IIterationPlanRecord record = (IIterationPlanRecord)manager.fetchPartialItem((IItemHandle)handle, 0, Arrays.asList(IIterationPlanRecord.NAME_PROPERTY, IIterationPlanRecord.ITERATION_PROPERTY), null);
                if (record != null) {
                    IIteration interval = (IIteration)manager.fetchPartialItem((IItemHandle)record.getIteration(), 0, Iterations.UI_PROFILE.getProperties(), null);
                    return new URIReference(NLS.bind((String)Messages.IterationPlanRecordHyperlinkHandler_REFERENCE_NAME, (Object)record.getName(), (Object[])new Object[]{IterationMigration.getName((IIteration)interval)}), NLS.bind((String)Messages.IterationPlanRecordHyperlinkHandler_REFERENCE_DETAILS, (Object)record.getName(), (Object[])new Object[]{IterationMigration.getName((IIteration)interval)}), Items.createLocation((IItem)record).toAbsoluteUri());
                }
            }
            catch (IllegalStateException e) {
                PlanningUIPlugin.log("Could not create URI:", e);
            }
            catch (TeamRepositoryException e) {
                PlanningUIPlugin.log("Exception while resolving iteration plan:", e);
            }
            return null;
        }
        return super.createHyperlink(object);
    }

    public boolean links(Object object) {
        if (object instanceof IIterationPlanRecordHandle) {
            return true;
        }
        return super.links(object);
    }
}

