/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.Messages;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.ShowWorkItemInPlanAction;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IterationHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        return IIteration.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean resolves(URI uri) {
        return IIteration.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean links(Object object) {
        return object instanceof IIterationHandle;
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException x) {
            throw new CoreException((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), x.getMessage(), (Throwable)x));
        }
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri, null);
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof IIterationHandle) {
            try {
                IIterationHandle handle = (IIterationHandle)object;
                ITeamRepository repository = (ITeamRepository)handle.getOrigin();
                IAuditableClient auditableClient = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
                ItemProfile profile = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.getProcessPropertiesFromIds(IIteration.class, (String[])new String[]{"name", "descriptionSummary"}));
                IIteration iteration = (IIteration)auditableClient.resolveAuditable((IAuditableHandle)handle, profile, monitor);
                URI uri = Location.itemLocation((IItemHandle)handle, (String)repository.getRepositoryURI()).toAbsoluteUri();
                String name = iteration.getName();
                if (name == null || "".equals(name.trim())) {
                    name = iteration.getId();
                }
                return new URIReference(name, NLS.bind((String)Messages.IterationHyperlinkHandler_NAME_SUMMARY, (Object)iteration.getName(), (Object[])new Object[]{iteration.getDescription().getSummary()}), IIteration.class.getName(), uri);
            }
            catch (TeamRepositoryException x) {
                PlanningUIPlugin.log(Messages.IterationHyperlinkHandler_EXCEPTION_RESOLVING_ITERATION, x);
            }
        }
        return null;
    }

    public void open(URI uri, ContextProvider context, IProgressMonitor monitor) {
        block9: {
            IWorkbenchWindow workbenchWindow = IterationHyperlinkHandler.getWorkbenchWindow();
            if (workbenchWindow == null) {
                return;
            }
            URIReference contextRef = null;
            if (context != null) {
                contextRef = context.getContext();
            }
            if (contextRef != null) {
                try {
                    URI contextRefUri = contextRef.getURI();
                    Location location = Location.location((URI)contextRefUri);
                    IItemHandle itemHandle = location.getItemHandle();
                    ITeamRepository teamRepository = ClientURIUtils.findTeamRepository((URI)contextRefUri);
                    if (itemHandle == null || teamRepository == null || !IWorkItem.ITEM_TYPE.equals(itemHandle.getItemType())) break block9;
                    IWorkItemCommon workItemCommon = (IWorkItemCommon)teamRepository.getClientLibrary(IWorkItemCommon.class);
                    IWorkItemWorkingCopyManager workingCopyManager = ((IWorkItemClient)workItemCommon).getWorkItemWorkingCopyManager();
                    IWorkItem item = null;
                    try {
                        workingCopyManager.connect((IWorkItemHandle)itemHandle, IWorkItem.SMALL_PROFILE.createExtension(new String[]{IWorkItem.TARGET_PROPERTY}), monitor);
                        item = workingCopyManager.getWorkingCopy((IWorkItemHandle)itemHandle).getWorkItem();
                    }
                    finally {
                        workingCopyManager.disconnect((IWorkItemHandle)itemHandle);
                    }
                    if (item != null) {
                        Action action = new Action(){};
                        final ShowWorkItemInPlanAction delegate = new ShowWorkItemInPlanAction();
                        delegate.setActivePart((IAction)action, workbenchWindow.getPartService().getActivePart());
                        delegate.selectionChanged((IAction)action, (ISelection)new StructuredSelection((Object)item));
                        new FoundationUIJob(Messages.IterationHyperlinkHandler_SHOW_WORKITEM_IN_PLAN, (IAction)action){
                            private final /* synthetic */ IAction val$action;
                            {
                                this.val$action = iAction;
                                super($anonymous0);
                            }

                            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                                delegate.run(this.val$action);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
                catch (TeamRepositoryException e) {
                    PlanningClientPlugin.log((Throwable)e);
                }
            }
        }
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            if (workbench.getWorkbenchWindowCount() > 0) {
                window = workbench.getWorkbenchWindows()[0];
            } else {
                return null;
            }
        }
        return window;
    }

    public IItemType guessItemType(URI uri) {
        String uriString = uri.toString();
        if (uriString.contains("com.ibm.team.apt.viewPlan")) {
            return IIterationPlanRecord.ITEM_TYPE;
        }
        return super.guessItemType(uri);
    }
}

