/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.ide.ui;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class PlanningUI {
    public static String getPluginId() {
        return PlanningUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, IWorkbenchPage page) {
        return PlanningUIPlugin.openIterationPlanEditor(handle, null, page);
    }

    public static IEditorPart openIterationPlanEditor(IIterationPlanRecordHandle handle, IWikiPage wikiPage, IWorkbenchPage page) {
        return PlanningUIPlugin.openIterationPlanEditor(handle, wikiPage, page);
    }

    public static ImageDescriptor getImageDescriptor(IPlanType planType) {
        URI uri;
        if (planType != null && (uri = planType.getIconURI()) != null) {
            try {
                return WorkItemUI.getImageDescriptor((URL)uri.toURL());
            }
            catch (MalformedURLException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
        }
        return ImagePool.ITERATION_PLAN_OBJ;
    }

    public static ImageDescriptor getImageDescriptor(IIterationPlanRecord plan) {
        if (plan != null && plan.isPropertySet(IIterationPlanRecord.PLAN_TYPE_PROPERTY)) {
            IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)plan);
            IProjectAreaHandle projectArea = null;
            IProcessAreaHandle processArea = plan.getOwner();
            if (processArea instanceof IProjectAreaHandle) {
                projectArea = (IProjectAreaHandle)processArea;
            } else {
                IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)processArea).itemManager();
                IProcessArea sharedProcessArea = (IProcessArea)itemManager.getSharedItemIfKnown((IItemHandle)processArea);
                if (sharedProcessArea != null) {
                    projectArea = sharedProcessArea.getProjectArea();
                }
            }
            if (projectArea != null) {
                ConfigurationElementCache cache = client.getConfigurationElementCache(projectArea);
                IPlanType planType = (IPlanType)cache.get(plan.getPlanType(), IPlanType.class);
                return PlanningUI.getImageDescriptor(planType);
            }
        }
        return ImagePool.ITERATION_PLAN_OBJ;
    }
}

