/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki.transformer;

import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachmentService;
import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.ILinkDetectorContextProvider;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.linkdetection.SimpleWorkItemLinkDetectorContextProvider;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class WikiPageAttachmentReferenceDetector
implements IItemReferenceDetector {
    private LinkDetector fDelegate;
    private URI fBaseUri;
    protected Map<String, IWikiPageAttachment> fAttachmentsMap = new HashMap<String, IWikiPageAttachment>();

    public WikiPageAttachmentReferenceDetector(URI baseUri, IProjectAreaHandle projectArea) {
        this(baseUri, projectArea, false);
    }

    public WikiPageAttachmentReferenceDetector(URI baseUri, IProjectAreaHandle projectArea, boolean isServer) {
        Assert.isNotNull((Object)baseUri);
        this.fBaseUri = baseUri;
        this.fDelegate = TextLinkDetectorManager.getDefault().createLinkDetector(isServer);
        this.fDelegate.setContext((ILinkDetectorContextProvider)new SimpleWorkItemLinkDetectorContextProvider(baseUri, projectArea));
    }

    public void setAttachments(List<IWikiPageAttachment> attachments) {
        Assert.isNotNull(attachments);
        this.fAttachmentsMap.clear();
        for (IWikiPageAttachment attachment : attachments) {
            this.fAttachmentsMap.put(attachment.getName(), attachment);
        }
    }

    public IItemReferenceDetector.Reference detect(String text) {
        List uris;
        IWikiPageAttachment attachment = this.fAttachmentsMap.get(text);
        if (attachment != null) {
            String query = "itemId=" + attachment.getItemId().getUuidValue();
            return new IItemReferenceDetector.Reference(Location.serviceLocation((String)this.fBaseUri.toASCIIString(), IWikiPageAttachmentService.class, (String)attachment.getName(), (String)query));
        }
        List match = this.fDelegate.match(text);
        if (!match.isEmpty() && !(uris = ((DetectedTextLink)match.get(0)).createURIs()).isEmpty()) {
            URI uri = (URI)((DetectedTextLink)match.get(0)).createURIs().get(0);
            try {
                Location location = Location.location((URI)uri);
                return WikiPageAttachmentReferenceDetector.safeReference(location);
            }
            catch (TeamRepositoryException e) {
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (this.fBaseUri != null) {
            URI uri;
            try {
                uri = new URI(text);
            }
            catch (URISyntaxException e) {
                return null;
            }
            try {
                Location tmp = Location.location((URI)uri);
                Location location = Location.location((Location)tmp, (String)this.fBaseUri.toASCIIString(), null);
                return WikiPageAttachmentReferenceDetector.safeReference(location);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (TeamRepositoryException e) {
                return null;
            }
        }
        return null;
    }

    private static IItemReferenceDetector.Reference safeReference(Location location) {
        if (location.getType() == null) {
            return null;
        }
        return new IItemReferenceDetector.Reference(location);
    }
}

