/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.common.wiki.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IContributor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class WikiPath {
    public static final String MSG_INVALID_NAME_1 = Messages.getString("WikiPath_NAME_TO_LONG");
    public static final String MSG_INVALID_NAME_2 = Messages.getString("WikiPath_INVALID_CHARACTERS");
    private static final char TYPE_SEPARATOR = '$';
    private static final char PAGE_SEPARATOR = ':';
    private static final char PROCESS_AREA_SEPARATOR = '/';
    private static final String PROJECT_AREA_PATH = "ProjectArea";
    private static final String PROJECT_AREA_PATH_PREFIX = "ProjectArea$";
    private static final String TEAM_AREA_PATH = "TeamArea";
    private static final String TEAM_AREA_PATH_PREFIX = "TeamArea$";
    private static final String USER_PATH = "User";
    private static final String USER_PATH_PREFIX = "User$";
    private static final String ITERATION_PLAN_PATH = "IterationPlan";
    private static final int LONG_SCOPE_GROUP = 2;
    private static final int LONG_PAGE_GROUP = 3;
    private static final int LONG_TEXT_GROUP = 7;
    private static final int SHORT_SCOPE_GROUP = 9;
    private static final int SHORT_PAGE_GROUP = 10;
    private static final Pattern REGEX_PATTERN = Pattern.compile("(\\[\\[(.*:)?((([A-Z][a-z]+){2,})|(Home))\\]\\[(.*)\\]\\])|(\\[([^\\[].*:)?((([A-Z][a-z]+){2,})|(Home))\\])");
    private final String fScopeType;
    private final String fScopeValue;
    private final String fPageId;
    private final String fText;

    private WikiPath(String scopeType, String scope, String pageId) {
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        this.fScopeType = scopeType;
        this.fScopeValue = scope;
        this.fPageId = pageId;
        this.fText = null;
    }

    private WikiPath(String scopeType, String scope, String pageId, String text) {
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        this.fScopeType = scopeType;
        this.fScopeValue = scope;
        this.fPageId = pageId;
        this.fText = text;
    }

    public String getScopeType() {
        return this.fScopeType;
    }

    public boolean isProjectAreaPath() {
        return PROJECT_AREA_PATH.equals(this.fScopeType);
    }

    public boolean isTeamAreaPath() {
        return TEAM_AREA_PATH.equals(this.fScopeType);
    }

    public boolean isUserPath() {
        return USER_PATH.equals(this.fScopeType);
    }

    public String getScopeValue() {
        return this.fScopeValue;
    }

    public String getScope() {
        return String.valueOf(this.fScopeType) + '$' + this.fScopeValue;
    }

    public String getPageId() {
        return this.fPageId;
    }

    public String getText() {
        if (this.fText != null) {
            return this.fText;
        }
        return this.fPageId;
    }

    public boolean isLongForm() {
        return this.fText != null;
    }

    public boolean isShortForm() {
        return this.fText == null;
    }

    public String getPagePath() {
        StringBuilder result = new StringBuilder();
        if (this.fScopeType != null) {
            result.append(this.fScopeType).append('$').append(this.fScopeValue).append(':');
        }
        return result.append(this.fPageId).toString();
    }

    public static String isValidPageName(String name) {
        if (name.length() > 250) {
            return MSG_INVALID_NAME_1;
        }
        if (name.indexOf(36) != -1) {
            return MSG_INVALID_NAME_2;
        }
        if (name.indexOf(58) != -1) {
            return MSG_INVALID_NAME_2;
        }
        if (name.indexOf(47) != -1) {
            return MSG_INVALID_NAME_2;
        }
        return null;
    }

    public static WikiPath create(IProjectArea area, String pageName) {
        return new WikiPath(PROJECT_AREA_PATH, area.getName(), pageName);
    }

    public static WikiPath create(List<? extends IProcessArea> areas, String pageName) {
        StringBuilder scope = new StringBuilder();
        for (IProcessArea iProcessArea : areas) {
            scope.append('/');
            scope.append(iProcessArea.getName());
        }
        return new WikiPath(TEAM_AREA_PATH, scope.toString(), pageName);
    }

    public static WikiPath create(IContributor user, String pageName) {
        return new WikiPath(USER_PATH, user.getUserId(), pageName);
    }

    public static WikiPath create(IIterationPlanRecord record, String pageName) {
        return new WikiPath(ITERATION_PLAN_PATH, record.getName(), pageName);
    }

    public static WikiPath create(String wikiPath) {
        int index = wikiPath.lastIndexOf(58);
        if (index == -1) {
            return new WikiPath(null, null, wikiPath);
        }
        String pageId = wikiPath.substring(index + 1);
        String prefix = wikiPath.substring(0, index);
        if ((index = prefix.indexOf(36)) == -1) {
            return new WikiPath(TEAM_AREA_PATH, prefix, pageId);
        }
        return new WikiPath(prefix.substring(0, index), prefix.substring(index + 1), pageId);
    }

    public static WikiPath create(String scopePart, String pageId) {
        int index = scopePart.indexOf(36);
        if (index == -1) {
            return new WikiPath(TEAM_AREA_PATH, scopePart, pageId);
        }
        return new WikiPath(scopePart.substring(0, index), scopePart.substring(index + 1), pageId);
    }

    public static String concatScopePartAndPageId(String scopePart, String pageId) {
        return String.valueOf(scopePart) + ':' + pageId;
    }

    public static Pattern getRegexPattern() {
        return REGEX_PATTERN;
    }

    public static WikiPath create(Matcher matcher, String defaultScopePart) {
        String scope = matcher.group(2);
        String pageName = matcher.group(3);
        String text = matcher.group(7);
        if (pageName == null) {
            scope = matcher.group(9);
            pageName = matcher.group(10);
        }
        String scopeType = null;
        String scopeValue = null;
        if (scope != null) {
            if (scope.startsWith(PROJECT_AREA_PATH_PREFIX)) {
                scopeType = PROJECT_AREA_PATH;
                scopeValue = new String(scope.substring(PROJECT_AREA_PATH_PREFIX.length(), scope.length() - 1));
            } else if (scope.startsWith(TEAM_AREA_PATH_PREFIX)) {
                scopeType = TEAM_AREA_PATH;
                scopeValue = new String(scope.substring(TEAM_AREA_PATH_PREFIX.length(), scope.length() - 1));
            } else if (scope.startsWith(USER_PATH_PREFIX)) {
                scopeType = USER_PATH;
                scopeValue = new String(scope.substring(USER_PATH_PREFIX.length(), scope.length() - 1));
            }
        }
        if (scopeType != null && scopeValue != null) {
            return new WikiPath(scopeType.substring(0), scopeValue, pageName, text);
        }
        int index = defaultScopePart.indexOf(36);
        Assert.isTrue((index != -1 ? 1 : 0) != 0);
        return new WikiPath(defaultScopePart.substring(0, index), defaultScopePart.substring(index + 1), pageName, text);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fPageId.hashCode();
        result = 31 * result + (this.fScopeType == null ? 0 : this.fScopeType.hashCode());
        result = 31 * result + (this.fScopeValue == null ? 0 : this.fScopeValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WikiPath other = (WikiPath)obj;
        if (!this.fPageId.equals(other.fPageId)) {
            return false;
        }
        if (this.fScopeType == null ? other.fScopeType != null : !this.fScopeType.equals(other.fScopeType)) {
            return false;
        }
        return !(this.fScopeValue == null ? other.fScopeValue != null : !this.fScopeValue.equals(other.fScopeValue));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        if (this.fText != null) {
            result.append('[');
        }
        if (this.fScopeType != null) {
            result.append(this.fScopeType).append('$').append(this.fScopeValue).append(':');
        }
        result.append(this.fPageId);
        result.append(']');
        if (this.fText != null) {
            result.append('[');
            result.append(this.fText);
            result.append("]]");
        }
        return result.toString();
    }
}

