/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.util.AttributeDefinitionUtil;
import com.ibm.team.apt.internal.common.util.Messages;
import com.ibm.team.process.internal.common.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class UniqueFilterMutator<T extends IConfigurationElement> {
    private final Collection<T> fElements;
    private static final List<String> LABELS_BLACKLIST = Arrays.asList("com.ibm.team.workitem.linktype.tracksworkitem", "com.ibm.team.workitem.linktype.trackedworkitem", "com.ibm.team.workitem.linktype.cm.affectedByDefect", "com.ibm.team.workitem.linktype.cm.affectsPlanItem", "com.ibm.team.apt.attribute.tracksWorkItem", "com.ibm.team.apt.attribute.trackedWorkItem", "com.ibm.team.apt.attribute.planitem.humanReadableRanking");
    private final UniqueStrategy fDisplayNameStrategy = new DisplayNameUniqueStrategy();
    private final UniqueStrategy fQueryIdUniqueStrategy = new QueryIdUniqueStrategy();

    public UniqueFilterMutator(Collection<T> elements) {
        this.fElements = elements;
    }

    public void filter() {
        this.doFilterFor(this.fDisplayNameStrategy);
        this.doFilterFor(this.fQueryIdUniqueStrategy);
    }

    private void doFilterFor(UniqueStrategy uniqueStrategy) {
        HashMap<String, List<T>> elementsToMutate = new HashMap<String, List<T>>();
        HashMap<String, IConfigurationElement> uniqueLabels = new HashMap<String, IConfigurationElement>();
        for (IConfigurationElement element : this.fElements) {
            IAttributeDefinitionDescriptor descriptor;
            IConfigurationElement repeatedElement;
            if (!this.applies(element) || (repeatedElement = uniqueLabels.put(uniqueStrategy.getUniquePropertyValue(descriptor = this.getDescriptor(element)), element)) == null) continue;
            List<T> repeatedInstances = elementsToMutate.get(uniqueStrategy.getUniquePropertyValue(descriptor));
            if (repeatedInstances == null) {
                repeatedInstances = new ArrayList<T>();
                repeatedInstances.add(repeatedElement);
                elementsToMutate.put(uniqueStrategy.getUniquePropertyValue(descriptor), repeatedInstances);
            }
            repeatedInstances.add(element);
        }
        if (!elementsToMutate.isEmpty()) {
            this.updateRepeatedInstances(elementsToMutate, uniqueStrategy);
        }
    }

    private IAttributeDefinitionDescriptor getDescriptor(T element) {
        return (IAttributeDefinitionDescriptor)element;
    }

    private void updateRepeatedInstances(HashMap<String, List<T>> updatedElements, UniqueStrategy uniqueStrategy) {
        for (List<T> entry : updatedElements.values()) {
            this.makeUnique(entry, uniqueStrategy);
        }
    }

    private void makeUnique(List<T> repeatedElements, UniqueStrategy uniqueStrategy) {
        uniqueStrategy.getDifferentiator().makeUnique(repeatedElements);
    }

    private boolean applies(T element) {
        return element instanceof IAttributeDefinitionDescriptor && this.hasDisplayedValue(element) && this.isNotIgnored(element);
    }

    private boolean isNotIgnored(T element) {
        String id = element.getId();
        if (id == null) {
            return true;
        }
        for (String idToIgnore : LABELS_BLACKLIST) {
            if (!id.contains(idToIgnore)) continue;
            return false;
        }
        return true;
    }

    private boolean hasDisplayedValue(T element) {
        return element.getDisplayName() != null && element.getDisplayName().trim().length() > 0;
    }

    private static class DifferentiateById
    implements Differentiator {
        private DifferentiateById() {
        }

        @Override
        public void makeUnique(List<? extends IAttributeDefinitionDescriptor> elements) {
            for (IAttributeDefinitionDescriptor iAttributeDefinitionDescriptor : elements) {
                if (!this.isNotReference(iAttributeDefinitionDescriptor)) continue;
                iAttributeDefinitionDescriptor.setDisplayName(NLS.bind((String)Messages.getString("DifferentiateById.UpdatedName"), (Object)iAttributeDefinitionDescriptor.getDisplayName(), (Object)this.removePlanningPrefix(iAttributeDefinitionDescriptor.getId())));
            }
        }

        private String removePlanningPrefix(String id) {
            return id.replace("com.ibm.team.apt.attributes._", "");
        }

        private boolean isNotReference(IAttributeDefinitionDescriptor descriptor) {
            PlanningAttributeType type = descriptor.getType();
            return type != null && PlanningAttributeType.REFERENCE != type;
        }
    }

    private static class DifferentiateQueryId
    implements Differentiator {
        private DifferentiateQueryId() {
        }

        @Override
        public void makeUnique(List<? extends IAttributeDefinitionDescriptor> elements) {
            for (IAttributeDefinitionDescriptor iAttributeDefinitionDescriptor : elements) {
                String displayName = iAttributeDefinitionDescriptor.getDisplayName();
                String removedParenthesis = displayName.replaceAll("[\\(|\\)]", "");
                iAttributeDefinitionDescriptor.setQueryId(AttributeDefinitionUtil.toCamelCase(removedParenthesis));
            }
        }
    }

    private static interface Differentiator {
        public void makeUnique(List<? extends IAttributeDefinitionDescriptor> var1);
    }

    private static class DisplayNameUniqueStrategy
    implements UniqueStrategy {
        private final Differentiator fDifferentiators = new DifferentiateById();

        private DisplayNameUniqueStrategy() {
        }

        @Override
        public String getUniquePropertyValue(IAttributeDefinitionDescriptor descriptor) {
            return descriptor.getDisplayName();
        }

        @Override
        public Differentiator getDifferentiator() {
            return this.fDifferentiators;
        }
    }

    private static class QueryIdUniqueStrategy
    implements UniqueStrategy {
        private final Differentiator fDifferentiators = new DifferentiateQueryId();

        private QueryIdUniqueStrategy() {
        }

        @Override
        public String getUniquePropertyValue(IAttributeDefinitionDescriptor descriptor) {
            return descriptor.getQueryId();
        }

        @Override
        public Differentiator getDifferentiator() {
            return this.fDifferentiators;
        }
    }

    private static interface UniqueStrategy {
        public String getUniquePropertyValue(IAttributeDefinitionDescriptor var1);

        public Differentiator getDifferentiator();
    }
}

