/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnionIterator<E>
implements Iterator<E> {
    private List<Iterator<E>> fDelegates = new ArrayList<Iterator<E>>();
    private int fPos = 0;
    private boolean fAdvance = true;
    private Iterator<E> fNext;

    public UnionIterator(Iterator<E> first, Iterator<E> ... rest) {
        this.fDelegates.add(first);
        Iterator<E>[] iteratorArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator<E> iter = iteratorArray[n2];
            this.fDelegates.add(iter);
            ++n2;
        }
    }

    private void computeNext() {
        if (!this.fAdvance) {
            return;
        }
        if (this.fPos >= this.fDelegates.size()) {
            return;
        }
        this.fNext = this.fDelegates.get(this.fPos++);
        if (!this.fNext.hasNext()) {
            this.fNext = null;
            this.computeNext();
        }
        this.fAdvance = this.fNext == null;
    }

    public boolean is(int n) {
        return n + 1 == this.fPos;
    }

    @Override
    public E next() {
        this.computeNext();
        if (this.fNext == null) {
            return null;
        }
        E next = this.fNext.next();
        if (next == null) {
            this.next();
        }
        if (!this.fNext.hasNext()) {
            this.fAdvance = true;
        }
        return next;
    }

    @Override
    public boolean hasNext() {
        this.computeNext();
        return this.fNext != null && this.fNext.hasNext();
    }

    @Override
    public void remove() {
        if (this.fNext != null) {
            this.fNext.remove();
        }
    }
}

