/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import java.util.Locale;

public enum SizeUnit {
    BYTE(1L),
    KB(1024L),
    MB(0x100000L);

    private long fDivisor;

    private SizeUnit(long divisor) {
        this.fDivisor = divisor;
    }

    public long getDivisor() {
        return this.fDivisor;
    }

    public String toString() {
        switch (this) {
            case BYTE: {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
        return this.name();
    }

    public static SizeUnit find(long value) {
        SizeUnit[] sizeUnitArray = SizeUnit.values();
        int n = sizeUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            SizeUnit unit = sizeUnitArray[n2];
            if (value <= unit.getDivisor() && unit.ordinal() > 0) {
                return SizeUnit.values()[unit.ordinal() - 1];
            }
            ++n2;
        }
        return MB;
    }

    public static long convert(long value, SizeUnit from, SizeUnit to) {
        value *= from.getDivisor();
        return value /= to.getDivisor();
    }
}

