/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.api.common.ItemType;
import com.ibm.team.apt.internal.common.rest.dto.WorkItemAttributeType;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class SerializeHelper {
    public static final String CLASS_OBJECT_TYPE = "object";
    public static final String CLASS_ITEM_TYPE = "item";
    public static final String ENUMERATION_NAMESPACE = "com.ibm.team.workitem.enumeration";
    public static final String TYPE_SEPARATOR = ":";
    private static Map<String, WorkItemAttributeType> PRIMITIVE_ATTRIBUTE_TYPES = new HashMap<String, WorkItemAttributeType>();
    private static Map<String, String> ITEM_REFERENCE_TYPES = new HashMap<String, String>();

    static {
        PRIMITIVE_ATTRIBUTE_TYPES.put("smallString", WorkItemAttributeType.STRING_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("mediumString", WorkItemAttributeType.STRING_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("string", WorkItemAttributeType.STRING_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("mediumHtml", WorkItemAttributeType.HTML_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("html", WorkItemAttributeType.HTML_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("timestamp", WorkItemAttributeType.DATE_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("integer", WorkItemAttributeType.INTEGER_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("float", WorkItemAttributeType.FLOAT_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("long", WorkItemAttributeType.INTEGER_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("decimal", WorkItemAttributeType.DECIMAL_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("boolean", WorkItemAttributeType.BOOLEAN_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("duration", WorkItemAttributeType.DURATION_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("tags", WorkItemAttributeType.TAGS_LITERAL);
        PRIMITIVE_ATTRIBUTE_TYPES.put("type", WorkItemAttributeType.TYPE_LITERAL);
        ITEM_REFERENCE_TYPES.put("projectArea", SerializeHelper.itemTypeId(IProjectArea.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("teamArea", SerializeHelper.itemTypeId(ITeamArea.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("category", SerializeHelper.itemTypeId(ICategory.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("interval", SerializeHelper.itemTypeId(IIteration.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("contributor", SerializeHelper.itemTypeId(IContributor.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("workItem", SerializeHelper.itemTypeId(IWorkItem.ITEM_TYPE));
        ITEM_REFERENCE_TYPES.put("deliverable", SerializeHelper.itemTypeId(IDeliverable.ITEM_TYPE));
    }

    public static String itemTypeId(IItemType itemType) {
        return SerializeHelper.typeId(CLASS_ITEM_TYPE, itemType.getNamespaceURI(), itemType.getName());
    }

    public static String enumerationTypeId(String enumerationTypeId) {
        return SerializeHelper.typeId(CLASS_OBJECT_TYPE, ENUMERATION_NAMESPACE, enumerationTypeId);
    }

    public static String objectTypeId(String namespace, String type) {
        return SerializeHelper.typeId(CLASS_OBJECT_TYPE, namespace, type);
    }

    public static WorkItemAttributeType getAttributeType(IAttribute attribute) {
        if (attribute.isBuiltIn() && IWorkItem.STATE_PROPERTY.equals(attribute.getIdentifier())) {
            return WorkItemAttributeType.STATE_LITERAL;
        }
        if (attribute.isBuiltIn() && IWorkItem.RESOLUTION_PROPERTY.equals(attribute.getIdentifier())) {
            return WorkItemAttributeType.RESOLUTION_LITERAL;
        }
        String workItemAttributeType = attribute.getAttributeType();
        WorkItemAttributeType result = PRIMITIVE_ATTRIBUTE_TYPES.get(workItemAttributeType);
        if (result != null) {
            return result;
        }
        if (ITEM_REFERENCE_TYPES.containsKey(workItemAttributeType)) {
            return WorkItemAttributeType.ITEM_LITERAL;
        }
        if (AttributeTypes.isEnumerationAttributeType((String)workItemAttributeType)) {
            return WorkItemAttributeType.ENUMERATION_LITERAL;
        }
        throw new IllegalArgumentException(String.format("Unknown attributeType '%s'", workItemAttributeType));
    }

    public static String getReferenceType(IAttribute attribute) {
        if (attribute.isBuiltIn() && IWorkItem.STATE_PROPERTY.equals(attribute.getIdentifier())) {
            return ItemType.WorkflowState.getQualifiedName();
        }
        if (attribute.isBuiltIn() && IWorkItem.RESOLUTION_PROPERTY.equals(attribute.getIdentifier())) {
            return ItemType.WorkflowResolution.getQualifiedName();
        }
        String attributeType = attribute.getAttributeType();
        String result = ITEM_REFERENCE_TYPES.get(attributeType);
        if (result != null) {
            return result;
        }
        if (AttributeTypes.isEnumerationAttributeType((String)attributeType)) {
            return ItemType.EnumerationElement.getQualifiedName();
        }
        return null;
    }

    public static String getPath(URL iconUrl) {
        return iconUrl != null ? iconUrl.toString() : null;
    }

    private static String typeId(String type, String ... scope) {
        StringBuilder builder = new StringBuilder(type).append(TYPE_SEPARATOR);
        int i = 0;
        while (i < scope.length - 1) {
            builder.append(scope[i]).append(TYPE_SEPARATOR);
            ++i;
        }
        return builder.append(scope[scope.length - 1]).toString();
    }
}

