/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.common.progress.ProgressBarMarkupStrategy;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class IterationPlanUtil {
    private static final String GENERAL_CSS = "GENERAL_PLAN_CSS";

    public static void buildPlanHover(Map head, StringBuffer body, IIterationPlanRecord plan, IProcessArea owner, IIteration iteration, ProgressBarMarkupStrategy strategy, IProgressLabelProvider progressProvider, IProgressInformation progressInformation, Locale clientLocale, String font, boolean focusHover) throws TeamRepositoryException {
        IterationPlanUtil.generateHeader(head, font, strategy);
        IterationPlanUtil.populateBody(body, plan, owner, iteration, strategy, progressProvider, progressInformation, clientLocale, focusHover);
    }

    private static void populateBody(StringBuffer body, IIterationPlanRecord plan, IProcessArea owner, IIteration iteration, ProgressBarMarkupStrategy progressBarMarkupStrategy, IProgressLabelProvider progressProvider, IProgressInformation progressInformation, Locale clientLocale, boolean focusHover) throws TeamRepositoryException {
        String ownerName = IterationPlanUtil.fromText2HTML(owner.getName());
        String iterationName = IterationPlanUtil.fromText2HTML(iteration.getName());
        Html.DIV.open(body, new Html.Attribute[0]);
        Html.TABLE.open(body, new Html.Attribute("class", "section"));
        Html.TR.open(body, new Html.Attribute[0]);
        Html.TD.open(body, new Html.Attribute("class", "label"));
        Html.append(body, Messages.getString("AbstractPlanHoverRepresentation.OwnerLabel"));
        Html.TD.close(body);
        Html.TD.open(body, new Html.Attribute("class", "value"));
        Html.SPAN.open(body, new Html.Attribute("class", "btd"));
        Html.append(body, ownerName);
        Html.SPAN.close(body);
        Html.TD.close(body);
        Html.TR.close(body);
        Html.TR.open(body, new Html.Attribute[0]);
        Html.TD.open(body, new Html.Attribute("class", "label"));
        Html.append(body, Messages.getString("AbstractPlanHoverRepresentation.IterationLabel"));
        Html.TD.close(body);
        Html.TD.open(body, new Html.Attribute("class", "value"), new Html.Attribute("style", "padding-left:0px;"));
        Html.SPAN.open(body, new Html.Attribute("class", "btd"));
        Html.append(body, iterationName);
        Html.SPAN.close(body);
        if (iteration.getStartDate() != null && iteration.getEndDate() != null) {
            MessageFormat messageFormat = new MessageFormat(" ({0,date,short} - {1,date,short})", clientLocale);
            Html.append(body, messageFormat.format(new Object[]{iteration.getStartDate(), iteration.getEndDate()}));
        }
        Html.TD.close(body);
        Html.TR.close(body);
        Html.TABLE.close(body);
        Html.DIV.open(body, new Html.Attribute("style", "width: 95%; margin:4px; margin-left: 6px; height: 10px;"));
        progressBarMarkupStrategy.generateBody(body);
        Html.DIV.open(body, new Html.Attribute("style", "clear: both; font-size: 7pt; font-family: 'IBM Plex Sans', 'Helvetica Neue', Arial, sans-serif;"));
        Html.SPAN.open(body, new Html.Attribute("style", "float: left;"));
        Html.append(body, progressProvider.getProgressText(progressInformation));
        Html.SPAN.close(body);
        Html.SPAN.open(body, new Html.Attribute("style", "float: right;"));
        Html.append(body, progressProvider.getQualityText(progressInformation));
        Html.SPAN.close(body);
        Html.DIV.close(body);
        Html.DIV.close(body);
        Html.DIV.close(body);
        if (focusHover) {
            IterationPlanUtil.addProgressReport(body, progressProvider, progressInformation);
        }
    }

    public static String fromText2HTML(String text) {
        return XMLString.createFromPlainText((String)text).getXMLText();
    }

    private static void addProgressReport(StringBuffer body, IProgressLabelProvider progressLabelProvider, IProgressInformation queryableProgressInformation) {
        Html.DIV.open(body, new Html.Attribute("style", "clear: both; margin-top: 20px;"));
        IProgressLabelProvider.IDescription[] allDescriptions = progressLabelProvider.getAllDescriptions(queryableProgressInformation);
        if (allDescriptions != null) {
            Html.TABLE.open(body, new Html.Attribute("class", "section"));
            IProgressLabelProvider.IDescription[] iDescriptionArray = allDescriptions;
            int n = allDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IProgressLabelProvider.IDescription description = iDescriptionArray[n2];
                IterationPlanUtil.populateRow(body, description);
                ++n2;
            }
            Html.TABLE.close(body);
        } else {
            String configurationMissingMessage = progressLabelProvider.getConfigurationMissingMessage();
            if (configurationMissingMessage != null) {
                body.append(configurationMissingMessage);
            }
        }
        Html.DIV.close(body);
    }

    private static void populateRow(StringBuffer body, IProgressLabelProvider.IDescription labelValuePair) {
        Html.TR.open(body, new Html.Attribute[0]);
        Html.TD.open(body, new Html.Attribute("class", "label"));
        Html.append(body, labelValuePair.getLabel());
        Html.TD.close(body);
        Html.TD.open(body, new Html.Attribute("class", "value"));
        Html.append(body, labelValuePair.getValue());
        Html.TD.close(body);
    }

    private static void generateHeader(Map head, String font, ProgressBarMarkupStrategy strategy) {
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { background-color: transparent; margin: 0px; padding: 0px; }\n");
        css.append("table { ").append(font).append(" }\n");
        css.append("table.section { margin: 4px; }\n");
        css.append("th { text-align: left; }\n");
        css.append("a:link { color: #005C87; text-decoration: none; }");
        css.append("a:hover { color: #8a9084; text-decoration: underline; }");
        css.append("a:visited { color: #005C87; text-decoration: none; }\n");
        css.append("a.yellow:link { color: rgb(128,128,0); text-decoration: none; }");
        css.append("a.yellow:hover { color: rgb(128,128,0); text-decoration: underline; }");
        css.append("a.yellow:visited { color: rgb(128,128,0); text-decoration: none; }");
        css.append("td.label { padding-top:0; color: #666666; padding-right:10px; vertical-align:top; }");
        css.append("td.value { padding-left:1px; padding-right:10px; vertical-align:top;}");
        css.append("span.imageLabel {padding-left:3px;vertical-align:top;}");
        css.append("</style>");
        head.put(GENERAL_CSS, css.toString());
        strategy.generateHead(head);
    }
}

